/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.cmd.CmdAutoHelp;
import com.massivecraft.factions.cmd.FCmdRoot;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.integration.Essentials;
import com.massivecraft.factions.integration.Worldguard;
import com.massivecraft.factions.integration.dynmap.EngineDynmap;
import com.massivecraft.factions.listeners.FactionsBlockListener;
import com.massivecraft.factions.listeners.FactionsChatListener;
import com.massivecraft.factions.listeners.FactionsEntityListener;
import com.massivecraft.factions.listeners.FactionsExploitListener;
import com.massivecraft.factions.listeners.FactionsPlayerListener;
import com.massivecraft.factions.shade.com.google.gson.GsonBuilder;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.struct.ChatMode;
import com.massivecraft.factions.util.AutoLeaveTask;
import com.massivecraft.factions.util.EnumTypeAdapter;
import com.massivecraft.factions.util.LazyLocation;
import com.massivecraft.factions.util.MapFLocToStringSetTypeAdapter;
import com.massivecraft.factions.util.MyLocationTypeAdapter;
import com.massivecraft.factions.zcore.MPlugin;
import com.massivecraft.factions.zcore.util.TextUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class P
extends MPlugin {
    public static P p;
    public static Permission perms;
    private boolean locked = false;
    private Integer AutoLeaveTask = null;
    public FCmdRoot cmdBase;
    public CmdAutoHelp cmdAutoHelp;

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean val) {
        this.locked = val;
        this.setAutoSave(val);
    }

    public P() {
        p = this;
    }

    public void onEnable() {
        if (!this.preEnable()) {
            return;
        }
        this.loadSuccessful = false;
        this.saveDefaultConfig();
        Conf.load();
        Essentials.setup();
        FPlayers.getInstance().load();
        Factions.getInstance().load();
        for (FPlayer fPlayer : FPlayers.getInstance().getAllFPlayers()) {
            Faction faction = Factions.getInstance().getFactionById(fPlayer.getFactionId());
            if (faction == null) {
                this.log("Invalid faction id on " + fPlayer.getName() + ":" + fPlayer.getFactionId());
                fPlayer.resetFactionData(false);
                continue;
            }
            faction.addFPlayer(fPlayer);
        }
        Board.getInstance().load();
        Board.getInstance().clean();
        this.cmdBase = new FCmdRoot();
        this.cmdAutoHelp = new CmdAutoHelp();
        this.getBaseCommands().add(this.cmdBase);
        Econ.setup();
        this.setupPermissions();
        if (Conf.worldGuardChecking || Conf.worldGuardBuildPriority) {
            Worldguard.init((Plugin)this);
        }
        EngineDynmap.getInstance().init();
        this.startAutoLeaveTask(false);
        this.getServer().getPluginManager().registerEvents((Listener)new FactionsPlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FactionsChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FactionsEntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FactionsExploitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FactionsBlockListener(this), (Plugin)this);
        this.getCommand(this.refCommand).setExecutor((CommandExecutor)this);
        this.postEnable();
        this.loadSuccessful = true;
    }

    private boolean setupPermissions() {
        try {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
            if (rsp != null) {
                perms = (Permission)rsp.getProvider();
            }
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
        return perms != null;
    }

    @Override
    public GsonBuilder getGsonBuilder() {
        Type mapFLocToStringSetType = new TypeToken<Map<FLocation, Set<String>>>(){}.getType();
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().excludeFieldsWithModifiers(128, 64).registerTypeAdapter((Type)((Object)LazyLocation.class), new MyLocationTypeAdapter()).registerTypeAdapter(mapFLocToStringSetType, new MapFLocToStringSetTypeAdapter()).registerTypeAdapterFactory(EnumTypeAdapter.ENUM_FACTORY);
    }

    @Override
    public void onDisable() {
        if (this.loadSuccessful) {
            Conf.save();
        }
        if (this.AutoLeaveTask != null) {
            this.getServer().getScheduler().cancelTask(this.AutoLeaveTask.intValue());
            this.AutoLeaveTask = null;
        }
        super.onDisable();
    }

    public void startAutoLeaveTask(boolean restartIfRunning) {
        if (this.AutoLeaveTask != null) {
            if (!restartIfRunning) {
                return;
            }
            this.getServer().getScheduler().cancelTask(this.AutoLeaveTask.intValue());
        }
        if (Conf.autoLeaveRoutineRunsEveryXMinutes > 0.0) {
            long ticks = (long)(1200.0 * Conf.autoLeaveRoutineRunsEveryXMinutes);
            this.AutoLeaveTask = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new AutoLeaveTask(), ticks, ticks);
        }
    }

    @Override
    public void postAutoSave() {
        Board.getInstance().forceSave();
        Conf.save();
    }

    @Override
    public boolean logPlayerCommands() {
        return Conf.logPlayerCommands;
    }

    @Override
    public boolean handleCommand(CommandSender sender, String commandString, boolean testOnly) {
        return sender instanceof Player && FactionsPlayerListener.preventCommand(commandString, (Player)sender) || super.handleCommand(sender, commandString, testOnly);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] split) {
        if (split == null || split.length == 0) {
            return this.handleCommand(sender, "/f help", false);
        }
        String cmd = Conf.baseCommandAliases.isEmpty() ? "/f" : "/" + Conf.baseCommandAliases.get(0);
        return this.handleCommand(sender, cmd + " " + TextUtil.implode(Arrays.asList(split), " "), false);
    }

    public int hookSupportVersion() {
        return 3;
    }

    public void handleFactionTagExternally(boolean notByFactions) {
        Conf.chatTagHandledByAnotherPlugin = notByFactions;
    }

    public boolean shouldLetFactionsHandleThisChat(AsyncPlayerChatEvent event) {
        return event != null && (this.isPlayerFactionChatting(event.getPlayer()) || this.isFactionsCommand(event.getMessage()));
    }

    public boolean isPlayerFactionChatting(Player player) {
        if (player == null) {
            return false;
        }
        FPlayer me = FPlayers.getInstance().getByPlayer(player);
        return me != null && me.getChatMode().isAtLeast(ChatMode.ALLIANCE);
    }

    public boolean isFactionsCommand(String check) {
        return check != null && !check.isEmpty() && this.handleCommand(null, check, true);
    }

    public String getPlayerFactionTag(Player player) {
        return this.getPlayerFactionTagRelation(player, null);
    }

    public String getPlayerFactionTagRelation(Player speaker, Player listener) {
        FPlayer you;
        String tag = "~";
        if (speaker == null) {
            return tag;
        }
        FPlayer me = FPlayers.getInstance().getByPlayer(speaker);
        if (me == null) {
            return tag;
        }
        tag = listener == null || !Conf.chatTagRelationColored ? me.getChatTag().trim() : ((you = FPlayers.getInstance().getByPlayer(listener)) == null ? me.getChatTag().trim() : me.getChatTag(you).trim());
        if (tag.isEmpty()) {
            tag = "~";
        }
        return tag;
    }

    public String getPlayerTitle(Player player) {
        if (player == null) {
            return "";
        }
        FPlayer me = FPlayers.getInstance().getByPlayer(player);
        if (me == null) {
            return "";
        }
        return me.getTitle().trim();
    }

    public Set<String> getFactionTags() {
        return Factions.getInstance().getFactionTags();
    }

    public Set<String> getPlayersInFaction(String factionTag) {
        HashSet<String> players = new HashSet<String>();
        Faction faction = Factions.getInstance().getByTag(factionTag);
        if (faction != null) {
            for (FPlayer fplayer : faction.getFPlayers()) {
                players.add(fplayer.getName());
            }
        }
        return players;
    }

    public Set<String> getOnlinePlayersInFaction(String factionTag) {
        HashSet<String> players = new HashSet<String>();
        Faction faction = Factions.getInstance().getByTag(factionTag);
        if (faction != null) {
            for (FPlayer fplayer : faction.getFPlayersWhereOnline(true)) {
                players.add(fplayer.getName());
            }
        }
        return players;
    }

    public String getPrimaryGroup(OfflinePlayer player) {
        return perms == null || !perms.hasGroupSupport() ? " " : perms.getPrimaryGroup(((World)Bukkit.getWorlds().get(0)).toString(), player);
    }

    public void debug(Level level, String s) {
        if (this.getConfig().getBoolean("debug", false)) {
            this.getLogger().log(level, s);
        }
    }

    public void debug(String s) {
        this.debug(Level.INFO, s);
    }

    static {
        perms = null;
    }
}

