/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FPlayerJoinEvent;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdAdmin
extends FCommand {
    public CmdAdmin() {
        this.aliases.add("admin");
        this.requiredArgs.add("player name");
        this.permission = Permission.ADMIN.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        FPlayer admin;
        FPlayer fyou = this.argAsBestFPlayerMatch(0);
        if (fyou == null) {
            return;
        }
        boolean permAny = Permission.ADMIN_ANY.has(this.sender, false);
        Faction targetFaction = fyou.getFaction();
        if (targetFaction != this.myFaction && !permAny) {
            this.msg(TL.COMMAND_ADMIN_NOTMEMBER, fyou.describeTo(this.fme, true));
            return;
        }
        if (this.fme != null && this.fme.getRole() != Role.ADMIN && !permAny) {
            this.msg(TL.COMMAND_ADMIN_NOTADMIN, new Object[0]);
            return;
        }
        if (fyou == this.fme && !permAny) {
            this.msg(TL.COMMAND_ADMIN_TARGETSELF, new Object[0]);
            return;
        }
        if (fyou.getFaction() != targetFaction) {
            FPlayerJoinEvent event = new FPlayerJoinEvent(FPlayers.getInstance().getByPlayer(this.me), targetFaction, FPlayerJoinEvent.PlayerJoinReason.LEADER);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (fyou == (admin = targetFaction.getFPlayerAdmin())) {
            targetFaction.promoteNewLeader();
            this.msg(TL.COMMAND_ADMIN_DEMOTES, fyou.describeTo(this.fme, true));
            fyou.msg(TL.COMMAND_ADMIN_DEMOTED, this.senderIsConsole ? TL.GENERIC_SERVERADMIN.toString() : this.fme.describeTo(fyou, true));
            return;
        }
        if (admin != null) {
            admin.setRole(Role.MODERATOR);
        }
        fyou.setRole(Role.ADMIN);
        this.msg(TL.COMMAND_ADMIN_PROMOTES, fyou.describeTo(this.fme, true));
        for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
            fplayer.msg(TL.COMMAND_ADMIN_PROMOTED, this.senderIsConsole ? TL.GENERIC_SERVERADMIN.toString() : this.fme.describeTo(fplayer, true), fyou.describeTo(fplayer), targetFaction.describeTo(fplayer));
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_ADMIN_DESCRIPTION;
    }
}

