/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.util.TL;

public class CmdAutoClaim
extends FCommand {
    public CmdAutoClaim() {
        this.aliases.add("autoclaim");
        this.optionalArgs.put("faction", "your");
        this.permission = Permission.AUTOCLAIM.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        Faction forFaction = this.argAsFaction(0, this.myFaction);
        if (forFaction == null || forFaction == this.fme.getAutoClaimFor()) {
            this.fme.setAutoClaimFor(null);
            this.msg(TL.COMMAND_AUTOCLAIM_DISABLED, new Object[0]);
            return;
        }
        if (!this.fme.canClaimForFaction(forFaction)) {
            if (this.myFaction == forFaction) {
                this.msg(TL.COMMAND_AUTOCLAIM_REQUIREDRANK, new Object[]{Role.MODERATOR.getTranslation()});
            } else {
                this.msg(TL.COMMAND_AUTOCLAIM_OTHERFACTION, forFaction.describeTo(this.fme));
            }
            return;
        }
        this.fme.setAutoClaimFor(forFaction);
        this.msg(TL.COMMAND_AUTOCLAIM_ENABLED, forFaction.describeTo(this.fme));
        this.fme.attemptClaim(forFaction, this.me.getLocation(), true);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_AUTOCLAIM_DESCRIPTION;
    }
}

