/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.ChatMode;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;

public class CmdChat
extends FCommand {
    public CmdChat() {
        this.aliases.add("c");
        this.aliases.add("chat");
        this.optionalArgs.put("mode", "next");
        this.permission = Permission.CHAT.node;
        this.disableOnLock = false;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = true;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        if (!Conf.factionOnlyChat) {
            this.msg(TL.COMMAND_CHAT_DISABLED.toString(), new Object[0]);
            return;
        }
        String modeString = this.argAsString(0);
        ChatMode modeTarget = this.fme.getChatMode().getNext();
        if (modeString != null) {
            if ((modeString = modeString.toLowerCase()).startsWith("p")) {
                modeTarget = ChatMode.PUBLIC;
            } else if (modeString.startsWith("a")) {
                modeTarget = ChatMode.ALLIANCE;
            } else if (modeString.startsWith("f")) {
                modeTarget = ChatMode.FACTION;
            } else if (modeString.startsWith("t")) {
                modeTarget = ChatMode.TRUCE;
            } else {
                this.msg(TL.COMMAND_CHAT_INVALIDMODE, new Object[0]);
                return;
            }
        }
        this.fme.setChatMode(modeTarget);
        if (this.fme.getChatMode() == ChatMode.PUBLIC) {
            this.msg(TL.COMMAND_CHAT_MODE_PUBLIC, new Object[0]);
        } else if (this.fme.getChatMode() == ChatMode.ALLIANCE) {
            this.msg(TL.COMMAND_CHAT_MODE_ALLIANCE, new Object[0]);
        } else if (this.fme.getChatMode() == ChatMode.TRUCE) {
            this.msg(TL.COMMAND_CHAT_MODE_TRUCE, new Object[0]);
        } else {
            this.msg(TL.COMMAND_CHAT_MODE_FACTION, new Object[0]);
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_CHAT_DESCRIPTION;
    }
}

