/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.util.SpiralTask;
import com.massivecraft.factions.zcore.util.TL;

public class CmdClaim
extends FCommand {
    public CmdClaim() {
        this.aliases.add("claim");
        this.optionalArgs.put("radius", "1");
        this.optionalArgs.put("faction", "your");
        this.permission = Permission.CLAIM.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        int radius = this.argAsInt(0, 1);
        final Faction forFaction = this.argAsFaction(1, this.myFaction);
        if (radius < 1) {
            this.msg(TL.COMMAND_CLAIM_INVALIDRADIUS, new Object[0]);
            return;
        }
        if (radius < 2) {
            this.fme.attemptClaim(forFaction, this.me.getLocation(), true);
        } else {
            if (!Permission.CLAIM_RADIUS.has(this.sender, false)) {
                this.msg(TL.COMMAND_CLAIM_DENIED, new Object[0]);
                return;
            }
            new SpiralTask(new FLocation(this.me), radius){
                private int failCount;
                private final int limit;
                {
                    super(fLocation, radius);
                    this.failCount = 0;
                    this.limit = Conf.radiusClaimFailureLimit - 1;
                }

                @Override
                public boolean work() {
                    boolean success = CmdClaim.this.fme.attemptClaim(forFaction, this.currentLocation(), true);
                    if (success) {
                        this.failCount = 0;
                    } else if (this.failCount++ >= this.limit) {
                        this.stop();
                        return false;
                    }
                    return true;
                }
            };
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_CLAIM_DESCRIPTION;
    }
}

