/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;

public class CmdClaimLine
extends FCommand {
    public static final BlockFace[] axis = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};

    public CmdClaimLine() {
        this.aliases.add("claimline");
        this.aliases.add("cl");
        this.optionalArgs.put("amount", "1");
        this.optionalArgs.put("direction", "facing");
        this.optionalArgs.put("faction", "you");
        this.permission = Permission.CLAIM_LINE.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        BlockFace blockFace;
        Integer amount = this.argAsInt(0, 1);
        if (amount > Conf.lineClaimLimit) {
            this.fme.msg(TL.COMMAND_CLAIMLINE_ABOVEMAX, Conf.lineClaimLimit);
            return;
        }
        String direction = this.argAsString(1);
        if (direction == null) {
            blockFace = axis[Math.round(this.me.getLocation().getYaw() / 90.0f) & 3];
        } else if (direction.equalsIgnoreCase("north")) {
            blockFace = BlockFace.NORTH;
        } else if (direction.equalsIgnoreCase("east")) {
            blockFace = BlockFace.EAST;
        } else if (direction.equalsIgnoreCase("south")) {
            blockFace = BlockFace.SOUTH;
        } else if (direction.equalsIgnoreCase("west")) {
            blockFace = BlockFace.WEST;
        } else {
            this.fme.msg(TL.COMMAND_CLAIMLINE_NOTVALID, direction);
            return;
        }
        Faction forFaction = this.argAsFaction(2, this.myFaction);
        Location location = this.me.getLocation();
        for (int i = 0; i < amount; ++i) {
            this.fme.attemptClaim(forFaction, location, true);
            location = location.add((double)(blockFace.getModX() * 16), 0.0, (double)(blockFace.getModZ() * 16));
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_CLAIMLINE_DESCRIPTION;
    }
}

