/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class CmdConfig
extends FCommand {
    private static HashMap<String, String> properFieldNames = new HashMap();

    public CmdConfig() {
        this.aliases.add("config");
        this.requiredArgs.add("setting");
        this.requiredArgs.add("value");
        this.errorOnToManyArgs = false;
        this.permission = Permission.CONFIG.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        String success;
        block40: {
            String fieldName;
            String field;
            if (properFieldNames.isEmpty()) {
                Field[] fields = Conf.class.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    properFieldNames.put(fields[i].getName().toLowerCase(), fields[i].getName());
                }
            }
            if ((field = this.argAsString(0).toLowerCase()).startsWith("\"") && field.endsWith("\"")) {
                field = field.substring(1, field.length() - 1);
            }
            if ((fieldName = properFieldNames.get(field)) == null || fieldName.isEmpty()) {
                this.msg(TL.COMMAND_CONFIG_NOEXIST, field);
                return;
            }
            String value = (String)this.args.get(1);
            for (int i = 2; i < this.args.size(); ++i) {
                value = value + ' ' + (String)this.args.get(i);
            }
            try {
                Field target = Conf.class.getField(fieldName);
                if (target.getType() == Boolean.TYPE) {
                    boolean targetValue = this.strAsBool(value);
                    target.setBoolean(null, targetValue);
                    success = targetValue ? "\"" + fieldName + TL.COMMAND_CONFIG_SET_TRUE.toString() : "\"" + fieldName + TL.COMMAND_CONFIG_SET_FALSE.toString();
                    break block40;
                }
                if (target.getType() == Integer.TYPE) {
                    try {
                        int intVal = Integer.parseInt(value);
                        target.setInt(null, intVal);
                        success = "\"" + fieldName + TL.COMMAND_CONFIG_OPTIONSET.toString() + intVal + ".";
                        break block40;
                    }
                    catch (NumberFormatException ex) {
                        this.sendMessage(TL.COMMAND_CONFIG_INTREQUIRED.format(fieldName));
                        return;
                    }
                }
                if (target.getType() == Long.TYPE) {
                    try {
                        long longVal = Long.parseLong(value);
                        target.setLong(null, longVal);
                        success = "\"" + fieldName + TL.COMMAND_CONFIG_OPTIONSET.toString() + longVal + ".";
                        break block40;
                    }
                    catch (NumberFormatException ex) {
                        this.sendMessage(TL.COMMAND_CONFIG_LONGREQUIRED.format(fieldName));
                        return;
                    }
                }
                if (target.getType() == Double.TYPE) {
                    try {
                        double doubleVal = Double.parseDouble(value);
                        target.setDouble(null, doubleVal);
                        success = "\"" + fieldName + TL.COMMAND_CONFIG_OPTIONSET.toString() + doubleVal + ".";
                        break block40;
                    }
                    catch (NumberFormatException ex) {
                        this.sendMessage(TL.COMMAND_CONFIG_DOUBLEREQUIRED.format(fieldName));
                        return;
                    }
                }
                if (target.getType() == Float.TYPE) {
                    try {
                        float floatVal = Float.parseFloat(value);
                        target.setFloat(null, floatVal);
                        success = "\"" + fieldName + TL.COMMAND_CONFIG_OPTIONSET.toString() + floatVal + ".";
                        break block40;
                    }
                    catch (NumberFormatException ex) {
                        this.sendMessage(TL.COMMAND_CONFIG_FLOATREQUIRED.format(fieldName));
                        return;
                    }
                }
                if (target.getType() == String.class) {
                    target.set(null, value);
                    success = "\"" + fieldName + TL.COMMAND_CONFIG_OPTIONSET.toString() + value + "\".";
                    break block40;
                }
                if (target.getType() == ChatColor.class) {
                    ChatColor newColor = null;
                    try {
                        newColor = ChatColor.valueOf((String)value.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (newColor == null) {
                        this.sendMessage(TL.COMMAND_CONFIG_INVALID_COLOUR.format(fieldName, value.toUpperCase()));
                        return;
                    }
                    target.set(null, newColor);
                    success = "\"" + fieldName + TL.COMMAND_CONFIG_COLOURSET.toString() + value.toUpperCase() + "\".";
                    break block40;
                }
                if (target.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType targSet = (ParameterizedType)target.getGenericType();
                    Type innerType = targSet.getActualTypeArguments()[0];
                    if (targSet.getRawType() != Set.class) {
                        this.sendMessage(TL.COMMAND_CONFIG_INVALID_COLLECTION.format(fieldName));
                        return;
                    }
                    if (innerType == Material.class) {
                        Material newMat = null;
                        try {
                            newMat = Material.valueOf((String)value.toUpperCase());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (newMat == null) {
                            this.sendMessage(TL.COMMAND_CONFIG_INVALID_MATERIAL.format(fieldName, value.toUpperCase()));
                            return;
                        }
                        Set matSet = (Set)target.get(null);
                        if (matSet.contains(newMat)) {
                            matSet.remove(newMat);
                            target.set(null, matSet);
                            success = TL.COMMAND_CONFIG_MATERIAL_REMOVED.format(fieldName, value.toUpperCase());
                        } else {
                            matSet.add(newMat);
                            target.set(null, matSet);
                            success = TL.COMMAND_CONFIG_MATERIAL_ADDED.format(fieldName, value.toUpperCase());
                        }
                        break block40;
                    }
                    if (innerType == String.class) {
                        Set stringSet = (Set)target.get(null);
                        if (stringSet.contains(value)) {
                            stringSet.remove(value);
                            target.set(null, stringSet);
                            success = TL.COMMAND_CONFIG_SET_REMOVED.format(fieldName, value);
                        } else {
                            stringSet.add(value);
                            target.set(null, stringSet);
                            success = TL.COMMAND_CONFIG_SET_ADDED.format(fieldName, value);
                        }
                        break block40;
                    }
                    this.sendMessage(TL.COMMAND_CONFIG_INVALID_TYPESET.format(fieldName));
                    return;
                }
                this.sendMessage(TL.COMMAND_CONFIG_ERROR_TYPE.format(fieldName, target.getClass().getName()));
                return;
            }
            catch (NoSuchFieldException ex) {
                this.sendMessage(TL.COMMAND_CONFIG_ERROR_MATCHING.format(fieldName));
                return;
            }
            catch (IllegalAccessException ex) {
                this.sendMessage(TL.COMMAND_CONFIG_ERROR_SETTING.format(fieldName, value));
                return;
            }
        }
        if (!success.isEmpty()) {
            if (this.sender instanceof Player) {
                this.sendMessage(success);
                P.p.log(success + TL.COMMAND_CONFIG_LOG.format((Player)this.sender));
            } else {
                P.p.log(success);
            }
        }
        Conf.save();
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_CONFIG_DESCRIPTION;
    }
}

