/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FPlayerJoinEvent;
import com.massivecraft.factions.event.FactionCreateEvent;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdCreate
extends FCommand {
    public CmdCreate() {
        this.aliases.add("create");
        this.requiredArgs.add("faction tag");
        this.permission = Permission.CREATE.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        String tag = this.argAsString(0);
        if (this.fme.hasFaction()) {
            this.msg(TL.COMMAND_CREATE_MUSTLEAVE, new Object[0]);
            return;
        }
        if (Factions.getInstance().isTagTaken(tag)) {
            this.msg(TL.COMMAND_CREATE_INUSE, new Object[0]);
            return;
        }
        ArrayList<String> tagValidationErrors = MiscUtil.validateTag(tag);
        if (tagValidationErrors.size() > 0) {
            this.sendMessage(tagValidationErrors);
            return;
        }
        if (!this.canAffordCommand(Conf.econCostCreate, TL.COMMAND_CREATE_TOCREATE.toString())) {
            return;
        }
        FactionCreateEvent createEvent = new FactionCreateEvent(this.me, tag);
        Bukkit.getServer().getPluginManager().callEvent((Event)createEvent);
        if (createEvent.isCancelled()) {
            return;
        }
        if (!this.payForCommand(Conf.econCostCreate, TL.COMMAND_CREATE_TOCREATE, TL.COMMAND_CREATE_FORCREATE)) {
            return;
        }
        Faction faction = Factions.getInstance().createFaction();
        if (faction == null) {
            this.msg(TL.COMMAND_CREATE_ERROR, new Object[0]);
            return;
        }
        faction.setTag(tag);
        FPlayerJoinEvent joinEvent = new FPlayerJoinEvent(FPlayers.getInstance().getByPlayer(this.me), faction, FPlayerJoinEvent.PlayerJoinReason.CREATE);
        Bukkit.getServer().getPluginManager().callEvent((Event)joinEvent);
        this.fme.setRole(Role.ADMIN);
        this.fme.setFaction(faction);
        for (FPlayer follower : FPlayers.getInstance().getOnlinePlayers()) {
            follower.msg(TL.COMMAND_CREATE_CREATED, this.fme.describeTo(follower, true), faction.getTag(follower));
        }
        this.msg(TL.COMMAND_CREATE_YOUSHOULD, ((P)this.p).cmdBase.cmdDescription.getUseageTemplate());
        if (Conf.logFactionCreate) {
            P.p.log(this.fme.getName() + TL.COMMAND_CREATE_CREATEDLOG.toString() + tag);
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_CREATE_DESCRIPTION;
    }
}

