/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FPlayerLeaveEvent;
import com.massivecraft.factions.event.FactionDisbandEvent;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.scoreboards.FTeamWrapper;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdDisband
extends FCommand {
    public CmdDisband() {
        this.aliases.add("disband");
        this.optionalArgs.put("faction tag", "yours");
        this.permission = Permission.DISBAND.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        boolean isMyFaction;
        Faction faction = this.argAsFaction(0, this.fme == null ? null : this.myFaction);
        if (faction == null) {
            return;
        }
        boolean bl = this.fme == null ? false : (isMyFaction = faction == this.myFaction);
        if (isMyFaction ? !this.assertMinRole(Role.ADMIN) : !Permission.DISBAND_ANY.has(this.sender, true)) {
            return;
        }
        if (!faction.isNormal()) {
            this.msg(TL.COMMAND_DISBAND_IMMUTABLE.toString(), new Object[0]);
            return;
        }
        if (faction.isPermanent()) {
            this.msg(TL.COMMAND_DISBAND_MARKEDPERMANENT.toString(), new Object[0]);
            return;
        }
        FactionDisbandEvent disbandEvent = new FactionDisbandEvent(this.me, faction.getId());
        Bukkit.getServer().getPluginManager().callEvent((Event)disbandEvent);
        if (disbandEvent.isCancelled()) {
            return;
        }
        for (FPlayer fplayer : faction.getFPlayers()) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new FPlayerLeaveEvent(fplayer, faction, FPlayerLeaveEvent.PlayerLeaveReason.DISBAND));
        }
        for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
            String who;
            String string = who = this.senderIsConsole ? TL.GENERIC_SERVERADMIN.toString() : this.fme.describeTo(fplayer);
            if (fplayer.getFaction() == faction) {
                fplayer.msg(TL.COMMAND_DISBAND_BROADCAST_YOURS, who);
                continue;
            }
            fplayer.msg(TL.COMMAND_DISBAND_BROADCAST_NOTYOURS, who, faction.getTag(fplayer));
        }
        if (Conf.logFactionDisband) {
            P.p.log("The faction " + faction.getTag() + " (" + faction.getId() + ") was disbanded by " + (this.senderIsConsole ? "console command" : this.fme.getName()) + ".");
        }
        if (Econ.shouldBeUsed() && !this.senderIsConsole) {
            double amount = Econ.getBalance(faction.getAccountId());
            Econ.transferMoney(this.fme, faction, this.fme, amount, false);
            if (amount > 0.0) {
                String amountString = Econ.moneyString(amount);
                this.msg(TL.COMMAND_DISBAND_HOLDINGS, amountString);
                P.p.log(this.fme.getName() + " has been given bank holdings of " + amountString + " from disbanding " + faction.getTag() + ".");
            }
        }
        Factions.getInstance().removeFaction(faction.getId());
        FTeamWrapper.applyUpdates(faction);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_DISBAND_DESCRIPTION;
    }
}

