/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.integration.Essentials;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.WarmUpUtil;
import com.massivecraft.factions.zcore.util.SmokeUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CmdHome
extends FCommand {
    public CmdHome() {
        this.aliases.add("home");
        this.permission = Permission.HOME.node;
        this.disableOnLock = false;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = true;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        if (!Conf.homesEnabled) {
            this.fme.msg(TL.COMMAND_HOME_DISABLED, new Object[0]);
            return;
        }
        if (!Conf.homesTeleportCommandEnabled) {
            this.fme.msg(TL.COMMAND_HOME_TELEPORTDISABLED, new Object[0]);
            return;
        }
        if (!this.myFaction.hasHome()) {
            this.fme.msg(TL.COMMAND_HOME_NOHOME.toString() + (this.fme.getRole().value < Role.MODERATOR.value ? TL.GENERIC_ASKYOURLEADER.toString() : TL.GENERIC_YOUSHOULD.toString()), new Object[0]);
            this.fme.sendMessage(((P)this.p).cmdBase.cmdSethome.getUseageTemplate());
            return;
        }
        if (!Conf.homesTeleportAllowedFromEnemyTerritory && this.fme.isInEnemyTerritory()) {
            this.fme.msg(TL.COMMAND_HOME_INENEMY, new Object[0]);
            return;
        }
        if (!Conf.homesTeleportAllowedFromDifferentWorld && this.me.getWorld().getUID() != this.myFaction.getHome().getWorld().getUID()) {
            this.fme.msg(TL.COMMAND_HOME_WRONGWORLD, new Object[0]);
            return;
        }
        Faction faction = Board.getInstance().getFactionAt(new FLocation(this.me.getLocation()));
        final Location loc = this.me.getLocation().clone();
        if (Conf.homesTeleportAllowedEnemyDistance > 0.0 && !faction.isSafeZone() && (!this.fme.isInOwnTerritory() || this.fme.isInOwnTerritory() && !Conf.homesTeleportIgnoreEnemiesIfInOwnTerritory)) {
            World w = loc.getWorld();
            double x = loc.getX();
            double y = loc.getY();
            double z = loc.getZ();
            for (Player p : this.me.getServer().getOnlinePlayers()) {
                FPlayer fp;
                if (p == null || !p.isOnline() || p.isDead() || p == this.me || p.getWorld() != w || this.fme.getRelationTo(fp = FPlayers.getInstance().getByPlayer(p)) != Relation.ENEMY || fp.isVanished()) continue;
                Location l = p.getLocation();
                double dx = Math.abs(x - l.getX());
                double dy = Math.abs(y - l.getY());
                double dz = Math.abs(z - l.getZ());
                double max = Conf.homesTeleportAllowedEnemyDistance;
                if (dx > max || dy > max || dz > max) continue;
                this.fme.msg(TL.COMMAND_HOME_ENEMYNEAR, String.valueOf(Conf.homesTeleportAllowedEnemyDistance));
                return;
            }
        }
        if (Essentials.handleTeleport(this.me, this.myFaction.getHome())) {
            return;
        }
        if (!this.payForCommand(Conf.econCostHome, TL.COMMAND_HOME_TOTELEPORT.toString(), TL.COMMAND_HOME_FORTELEPORT.toString())) {
            return;
        }
        this.doWarmUp(WarmUpUtil.Warmup.HOME, TL.WARMUPS_NOTIFY_TELEPORT, "Home", new Runnable(){

            @Override
            public void run() {
                if (Conf.homesTeleportCommandSmokeEffectEnabled) {
                    ArrayList<Location> smokeLocations = new ArrayList<Location>();
                    smokeLocations.add(loc);
                    smokeLocations.add(loc.add(0.0, 1.0, 0.0));
                    smokeLocations.add(CmdHome.this.myFaction.getHome());
                    smokeLocations.add(CmdHome.this.myFaction.getHome().clone().add(0.0, 1.0, 0.0));
                    SmokeUtil.spawnCloudRandom(smokeLocations, Conf.homesTeleportCommandSmokeEffectThickness);
                }
                CmdHome.this.me.teleport(CmdHome.this.myFaction.getHome());
            }
        }, ((P)this.p).getConfig().getLong("warmups.f-home", 0L));
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_HOME_DESCRIPTION;
    }
}

