/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FPlayerJoinEvent;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdJoin
extends FCommand {
    public CmdJoin() {
        this.aliases.add("join");
        this.requiredArgs.add("faction name");
        this.optionalArgs.put("player", "you");
        this.permission = Permission.JOIN.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        boolean samePlayer;
        Faction faction = this.argAsFaction(0);
        if (faction == null) {
            return;
        }
        FPlayer fplayer = this.argAsBestFPlayerMatch(1, this.fme, false);
        boolean bl = samePlayer = fplayer == this.fme;
        if (!samePlayer && !Permission.JOIN_OTHERS.has(this.sender, false)) {
            this.msg(TL.COMMAND_JOIN_CANNOTFORCE, new Object[0]);
            return;
        }
        if (!faction.isNormal()) {
            this.msg(TL.COMMAND_JOIN_SYSTEMFACTION, new Object[0]);
            return;
        }
        if (faction == fplayer.getFaction()) {
            this.msg(TL.COMMAND_JOIN_ALREADYMEMBER, fplayer.describeTo(this.fme, true), samePlayer ? "are" : "is", faction.getTag(this.fme));
            return;
        }
        if (Conf.factionMemberLimit > 0 && faction.getFPlayers().size() >= Conf.factionMemberLimit) {
            this.msg(TL.COMMAND_JOIN_ATLIMIT, faction.getTag(this.fme), Conf.factionMemberLimit, fplayer.describeTo(this.fme, false));
            return;
        }
        if (fplayer.hasFaction()) {
            this.msg(TL.COMMAND_JOIN_INOTHERFACTION, fplayer.describeTo(this.fme, true), samePlayer ? "your" : "their");
            return;
        }
        if (!Conf.canLeaveWithNegativePower && fplayer.getPower() < 0.0) {
            this.msg(TL.COMMAND_JOIN_NEGATIVEPOWER, fplayer.describeTo(this.fme, true));
            return;
        }
        if (!(faction.getOpen() || faction.isInvited(fplayer) || this.fme.isAdminBypassing() || Permission.JOIN_ANY.has(this.sender, false))) {
            this.msg(TL.COMMAND_JOIN_REQUIRESINVITATION, new Object[0]);
            if (samePlayer) {
                faction.msg(TL.COMMAND_JOIN_ATTEMPTEDJOIN, fplayer.describeTo(faction, true));
            }
            return;
        }
        if (samePlayer && !this.canAffordCommand(Conf.econCostJoin, TL.COMMAND_JOIN_TOJOIN.toString())) {
            return;
        }
        FPlayerJoinEvent joinEvent = new FPlayerJoinEvent(FPlayers.getInstance().getByPlayer(this.me), faction, FPlayerJoinEvent.PlayerJoinReason.COMMAND);
        Bukkit.getServer().getPluginManager().callEvent((Event)joinEvent);
        if (joinEvent.isCancelled()) {
            return;
        }
        if (samePlayer && !this.payForCommand(Conf.econCostJoin, TL.COMMAND_JOIN_TOJOIN.toString(), TL.COMMAND_JOIN_FORJOIN.toString())) {
            return;
        }
        this.fme.msg(TL.COMMAND_JOIN_SUCCESS, fplayer.describeTo(this.fme, true), faction.getTag(this.fme));
        if (!samePlayer) {
            fplayer.msg(TL.COMMAND_JOIN_MOVED, this.fme.describeTo(fplayer, true), faction.getTag(fplayer));
        }
        faction.msg(TL.COMMAND_JOIN_JOINED, fplayer.describeTo(faction, true));
        fplayer.resetFactionData();
        fplayer.setFaction(faction);
        faction.deinvite(fplayer);
        if (Conf.logFactionJoin) {
            if (samePlayer) {
                P.p.log(TL.COMMAND_JOIN_JOINEDLOG.toString(), fplayer.getName(), faction.getTag());
            } else {
                P.p.log(TL.COMMAND_JOIN_MOVEDLOG.toString(), this.fme.getName(), fplayer.getName(), faction.getTag());
            }
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_JOIN_DESCRIPTION;
    }
}

