/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import com.massivecraft.factions.zcore.util.TagUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CmdList
extends FCommand {
    private String[] defaults = new String[3];

    public CmdList() {
        this.aliases.add("list");
        this.aliases.add("ls");
        this.defaults[0] = "&e&m----------&r&e[ &2Faction List &9{pagenumber}&e/&9{pagecount} &e]&m----------";
        this.defaults[1] = "<i>Factionless<i> {factionless} online";
        this.defaults[2] = "<a>{faction} <i>{online} / {members} online, <a>Land / Power / Maxpower: <i>{chunks}/{power}/{maxPower}";
        this.optionalArgs.put("page", "1");
        this.permission = Permission.LIST.node;
        this.disableOnLock = false;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        if (!this.payForCommand(Conf.econCostList, "to list the factions", "for listing the factions")) {
            return;
        }
        ArrayList<Faction> factionList = Factions.getInstance().getAllFactions();
        factionList.remove(Factions.getInstance().getNone());
        factionList.remove(Factions.getInstance().getSafeZone());
        factionList.remove(Factions.getInstance().getWarZone());
        Collections.sort(factionList, new Comparator<Faction>(){

            @Override
            public int compare(Faction f1, Faction f2) {
                int f2Size;
                int f1Size = f1.getFPlayers().size();
                if (f1Size < (f2Size = f2.getFPlayers().size())) {
                    return 1;
                }
                if (f1Size > f2Size) {
                    return -1;
                }
                return 0;
            }
        });
        Collections.sort(factionList, new Comparator<Faction>(){

            @Override
            public int compare(Faction f1, Faction f2) {
                int f2Size;
                int f1Size = f1.getFPlayersWhereOnline(true).size();
                if (f1Size < (f2Size = f2.getFPlayersWhereOnline(true).size())) {
                    return 1;
                }
                if (f1Size > f2Size) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<String> lines = new ArrayList<String>();
        factionList.add(0, Factions.getInstance().getNone());
        int pageheight = 9;
        int pagenumber = this.argAsInt(0, 1);
        int pagecount = factionList.size() / 9 + 1;
        if (pagenumber > pagecount) {
            pagenumber = pagecount;
        } else if (pagenumber < 1) {
            pagenumber = 1;
        }
        int start = (pagenumber - 1) * 9;
        int end = start + 9;
        if (end > factionList.size()) {
            end = factionList.size();
        }
        String header = ((P)this.p).getConfig().getString("list.header", this.defaults[0]);
        header = header.replace("{pagenumber}", String.valueOf(pagenumber)).replace("{pagecount}", String.valueOf(pagecount));
        lines.add(((P)this.p).txt.parse(header));
        for (Faction faction : factionList.subList(start, end)) {
            if (faction.isNone()) {
                lines.add(((P)this.p).txt.parse(TagUtil.parsePlain(faction, ((P)this.p).getConfig().getString("list.factionless", this.defaults[1]))));
                continue;
            }
            lines.add(((P)this.p).txt.parse(TagUtil.parsePlain(faction, this.fme, ((P)this.p).getConfig().getString("list.entry", this.defaults[2]))));
        }
        this.sendMessage(lines);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_LIST_DESCRIPTION;
    }
}

