/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.util.TL;

public class CmdOwner
extends FCommand {
    public CmdOwner() {
        this.aliases.add("owner");
        this.optionalArgs.put("player name", "you");
        this.permission = Permission.OWNER.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        FPlayer target;
        boolean hasBypass = this.fme.isAdminBypassing();
        if (!hasBypass && !this.assertHasFaction()) {
            return;
        }
        if (!Conf.ownedAreasEnabled) {
            this.fme.msg(TL.COMMAND_OWNER_DISABLED, new Object[0]);
            return;
        }
        if (!hasBypass && Conf.ownedAreasLimitPerFaction > 0 && this.myFaction.getCountOfClaimsWithOwners() >= Conf.ownedAreasLimitPerFaction) {
            this.fme.msg(TL.COMMAND_OWNER_LIMIT, Conf.ownedAreasLimitPerFaction);
            return;
        }
        if (!hasBypass && !this.assertMinRole(Conf.ownedAreasModeratorsCanSet ? Role.MODERATOR : Role.ADMIN)) {
            return;
        }
        FLocation flocation = new FLocation(this.fme);
        Faction factionHere = Board.getInstance().getFactionAt(flocation);
        if (factionHere != this.myFaction) {
            if (!factionHere.isNormal()) {
                this.fme.msg(TL.COMMAND_OWNER_NOTCLAIMED, new Object[0]);
                return;
            }
            if (!hasBypass) {
                this.fme.msg(TL.COMMAND_OWNER_WRONGFACTION, new Object[0]);
                return;
            }
        }
        if ((target = this.argAsBestFPlayerMatch(0, this.fme)) == null) {
            return;
        }
        String playerName = target.getName();
        if (target.getFaction() != this.myFaction) {
            this.fme.msg(TL.COMMAND_OWNER_NOTMEMBER, playerName);
            return;
        }
        if (this.args.isEmpty() && this.myFaction.doesLocationHaveOwnersSet(flocation)) {
            this.myFaction.clearClaimOwnership(flocation);
            this.fme.msg(TL.COMMAND_OWNER_CLEARED, new Object[0]);
            return;
        }
        if (this.myFaction.isPlayerInOwnerList(target, flocation)) {
            this.myFaction.removePlayerAsOwner(target, flocation);
            this.fme.msg(TL.COMMAND_OWNER_REMOVED, playerName);
            return;
        }
        if (!this.payForCommand(Conf.econCostOwner, TL.COMMAND_OWNER_TOSET, TL.COMMAND_OWNER_FORSET)) {
            return;
        }
        this.myFaction.setPlayerAsOwner(target, flocation);
        this.fme.msg(TL.COMMAND_OWNER_ADDED, playerName);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_OWNER_DESCRIPTION;
    }
}

