/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;

public class CmdOwnerList
extends FCommand {
    public CmdOwnerList() {
        this.aliases.add("ownerlist");
        this.permission = Permission.OWNERLIST.node;
        this.disableOnLock = false;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        String owners;
        boolean hasBypass = this.fme.isAdminBypassing();
        if (!hasBypass && !this.assertHasFaction()) {
            return;
        }
        if (!Conf.ownedAreasEnabled) {
            this.fme.msg(TL.COMMAND_OWNERLIST_DISABLED, new Object[0]);
            return;
        }
        FLocation flocation = new FLocation(this.fme);
        if (Board.getInstance().getFactionAt(flocation) != this.myFaction) {
            if (!hasBypass) {
                this.fme.msg(TL.COMMAND_OWNERLIST_WRONGFACTION, new Object[0]);
                return;
            }
            this.myFaction = Board.getInstance().getFactionAt(flocation);
            if (!this.myFaction.isNormal()) {
                this.fme.msg(TL.COMMAND_OWNERLIST_NOTCLAIMED, new Object[0]);
                return;
            }
        }
        if ((owners = this.myFaction.getOwnerListString(flocation)) == null || owners.isEmpty()) {
            this.fme.msg(TL.COMMAND_OWNERLIST_NONE, new Object[0]);
            return;
        }
        this.fme.msg(TL.COMMAND_OWNERLIST_OWNERS, owners);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_OWNERLIST_DESCRIPTION;
    }
}

