/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;

public class CmdPermanent
extends FCommand {
    public CmdPermanent() {
        this.aliases.add("permanent");
        this.requiredArgs.add("faction tag");
        this.permission = Permission.SET_PERMANENT.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        String change;
        Faction faction = this.argAsFaction(0);
        if (faction == null) {
            return;
        }
        if (faction.isPermanent()) {
            change = TL.COMMAND_PERMANENT_REVOKE.toString();
            faction.setPermanent(false);
        } else {
            change = TL.COMMAND_PERMANENT_GRANT.toString();
            faction.setPermanent(true);
        }
        P.p.log((this.fme == null ? "A server admin" : this.fme.getName()) + " " + change + " the faction \"" + faction.getTag() + "\".");
        for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
            String blame;
            String string = blame = this.fme == null ? TL.GENERIC_SERVERADMIN.toString() : this.fme.describeTo(fplayer, true);
            if (fplayer.getFaction() == faction) {
                fplayer.msg(TL.COMMAND_PERMANENT_YOURS, blame, change);
                continue;
            }
            fplayer.msg(TL.COMMAND_PERMANENT_OTHER, blame, change, faction.getTag(fplayer));
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_PERMANENT_DESCRIPTION;
    }
}

