/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;

public class CmdPermanentPower
extends FCommand {
    public CmdPermanentPower() {
        this.aliases.add("permanentpower");
        this.requiredArgs.add("faction");
        this.optionalArgs.put("power", "reset");
        this.permission = Permission.SET_PERMANENTPOWER.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        Faction targetFaction = this.argAsFaction(0);
        if (targetFaction == null) {
            return;
        }
        Integer targetPower = this.argAsInt(1);
        targetFaction.setPermanentPower(targetPower);
        String change = TL.COMMAND_PERMANENTPOWER_REVOKE.toString();
        if (targetFaction.hasPermanentPower()) {
            change = TL.COMMAND_PERMANENTPOWER_GRANT.toString();
        }
        this.msg(TL.COMMAND_PERMANENTPOWER_SUCCESS, change, targetFaction.describeTo(this.fme));
        for (FPlayer fplayer : targetFaction.getFPlayersWhereOnline(true)) {
            if (fplayer == this.fme) continue;
            String blame = this.fme == null ? TL.GENERIC_SERVERADMIN.toString() : this.fme.describeTo(fplayer, true);
            fplayer.msg(TL.COMMAND_PERMANENTPOWER_FACTION, blame, change);
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_PERMANENTPOWER_DESCRIPTION;
    }
}

