/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.shade.mkremins.fanciful.FancyMessage;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import com.massivecraft.factions.zcore.util.TagReplacer;
import com.massivecraft.factions.zcore.util.TagUtil;
import java.util.ArrayList;
import java.util.List;

public class CmdShow
extends FCommand {
    List<String> defaults = new ArrayList<String>();

    public CmdShow() {
        this.aliases.add("show");
        this.aliases.add("who");
        this.defaults.add("{header}");
        this.defaults.add("<a>Description: <i>{description}");
        this.defaults.add("<a>Joining: <i>{joining}    {peaceful}");
        this.defaults.add("<a>Land / Power / Maxpower: <i> {chunks} / {power} / {maxPower}");
        this.defaults.add("<a>Founded: <i>{create-date}");
        this.defaults.add("<a>This faction is permanent, remaining even with no members.");
        this.defaults.add("<a>Land value: <i>{land-value} {land-refund}");
        this.defaults.add("<a>Balance: <i>{balance}");
        this.defaults.add("<a>Allies(<i>{allies}<a>/<i>{max-allies}<a>): {allies-list}");
        this.defaults.add("<a>Online: (<i>{online}<a>/<i>{members}<a>): {online-list}");
        this.defaults.add("<a>Offline: (<i>{offline}<a>/<i>{members}<a>): {offline-list}");
        this.optionalArgs.put("faction tag", "yours");
        this.permission = Permission.SHOW.node;
        this.disableOnLock = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        Faction faction = this.myFaction;
        if (this.argIsSet(0)) {
            faction = this.argAsFaction(0);
        }
        if (faction == null) {
            return;
        }
        if (!this.payForCommand(Conf.econCostShow, TL.COMMAND_SHOW_TOSHOW, TL.COMMAND_SHOW_FORSHOW)) {
            return;
        }
        List<String> show = P.p.getConfig().getStringList("show");
        if (show == null || show.isEmpty()) {
            show = this.defaults;
        }
        if (!faction.isNormal()) {
            String tag = faction.getTag(this.fme);
            String header = show.get(0);
            if (TagReplacer.HEADER.contains(header)) {
                this.msg(((P)this.p).txt.titleize(tag), new Object[0]);
            } else {
                this.msg(((P)this.p).txt.parse(TagReplacer.FACTION.replace(header, tag)), new Object[0]);
            }
            return;
        }
        for (String raw : show) {
            String parsed = TagUtil.parsePlain(faction, this.fme, raw);
            if (TagUtil.hasFancy(parsed)) {
                List<FancyMessage> fancy = TagUtil.parseFancy(faction, this.fme, parsed);
                if (fancy == null) continue;
                this.sendFancyMessage(fancy);
                continue;
            }
            if (parsed.contains("{notFrozen}") || parsed.contains("{notPermanent}")) continue;
            if (parsed.contains("{ig}")) {
                parsed = parsed.substring(0, parsed.indexOf("{ig}")) + TL.COMMAND_SHOW_NOHOME.toString();
            }
            this.msg(((P)this.p).txt.parse(parsed), new Object[0]);
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_SHOW_COMMANDDESCRIPTION;
    }
}

