/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.integration.Essentials;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.util.SpiralTask;
import com.massivecraft.factions.zcore.util.TL;
import java.util.Random;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CmdStuck
extends FCommand {
    private static final Random random = new Random();

    public CmdStuck() {
        this.aliases.add("stuck");
        this.aliases.add("halp!");
        this.permission = Permission.STUCK.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        final Player player = this.fme.getPlayer();
        final Location sentAt = player.getLocation();
        final FLocation chunk = this.fme.getLastStoodAt();
        long delay = P.p.getConfig().getLong("hcf.stuck.delay", 30L);
        final int radius = P.p.getConfig().getInt("hcf.stuck.radius", 10);
        if (P.p.getStuckMap().containsKey(player.getUniqueId())) {
            long wait = P.p.getTimers().get(player.getUniqueId()) - System.currentTimeMillis();
            String time = DurationFormatUtils.formatDuration((long)wait, (String)TL.COMMAND_STUCK_TIMEFORMAT.toString(), (boolean)true);
            this.msg(TL.COMMAND_STUCK_EXISTS, time);
        } else {
            if (!this.payForCommand(Conf.econCostStuck, TL.COMMAND_STUCK_TOSTUCK.format(this.fme.getName()), TL.COMMAND_STUCK_FORSTUCK.format(this.fme.getName()))) {
                return;
            }
            int id = Bukkit.getScheduler().runTaskLater((Plugin)P.p, new BukkitRunnable(){

                public void run() {
                    if (!P.p.getStuckMap().containsKey(player.getUniqueId())) {
                        return;
                    }
                    final World world = chunk.getWorld();
                    if (world.getUID() != player.getWorld().getUID() || sentAt.distance(player.getLocation()) > (double)radius) {
                        CmdStuck.this.msg(TL.COMMAND_STUCK_OUTSIDE.format(radius), new Object[0]);
                        P.p.getTimers().remove(player.getUniqueId());
                        P.p.getStuckMap().remove(player.getUniqueId());
                        return;
                    }
                    final Board board = Board.getInstance();
                    new SpiralTask(new FLocation(CmdStuck.this.me), radius * 2){

                        @Override
                        public boolean work() {
                            FLocation chunk = this.currentFLocation();
                            Faction faction = board.getFactionAt(chunk);
                            if (faction.isNone()) {
                                int cx = FLocation.chunkToBlock((int)chunk.getX());
                                int cz = FLocation.chunkToBlock((int)chunk.getZ());
                                int y = world.getHighestBlockYAt(cx, cz);
                                Location tp = new Location(world, (double)cx, (double)y, (double)cz);
                                CmdStuck.this.msg(TL.COMMAND_STUCK_TELEPORT, tp.getBlockX(), tp.getBlockY(), tp.getBlockZ());
                                P.p.getTimers().remove(player.getUniqueId());
                                P.p.getStuckMap().remove(player.getUniqueId());
                                if (!Essentials.handleTeleport(player, tp)) {
                                    player.teleport(tp);
                                    P.p.debug("/f stuck used regular teleport, not essentials!");
                                }
                                this.stop();
                                return false;
                            }
                            return true;
                        }
                    };
                }
            }, delay * 20L).getTaskId();
            P.p.getTimers().put(player.getUniqueId(), System.currentTimeMillis() + delay * 1000L);
            long wait = P.p.getTimers().get(player.getUniqueId()) - System.currentTimeMillis();
            String time = DurationFormatUtils.formatDuration((long)wait, (String)TL.COMMAND_STUCK_TIMEFORMAT.toString(), (boolean)true);
            this.msg(TL.COMMAND_STUCK_START, time);
            P.p.getStuckMap().put(player.getUniqueId(), id);
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_STUCK_DESCRIPTION;
    }
}

