/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FactionRenameEvent;
import com.massivecraft.factions.scoreboards.FTeamWrapper;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdTag
extends FCommand {
    public CmdTag() {
        this.aliases.add("tag");
        this.requiredArgs.add("faction tag");
        this.permission = Permission.TAG.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = true;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        String tag = this.argAsString(0);
        if (Factions.getInstance().isTagTaken(tag) && !MiscUtil.getComparisonString(tag).equals(this.myFaction.getComparisonTag())) {
            this.msg(TL.COMMAND_TAG_TAKEN, new Object[0]);
            return;
        }
        ArrayList<String> errors = MiscUtil.validateTag(tag);
        if (errors.size() > 0) {
            this.sendMessage(errors);
            return;
        }
        if (!this.canAffordCommand(Conf.econCostTag, TL.COMMAND_TAG_TOCHANGE.toString())) {
            return;
        }
        FactionRenameEvent renameEvent = new FactionRenameEvent(this.fme, tag);
        Bukkit.getServer().getPluginManager().callEvent((Event)renameEvent);
        if (renameEvent.isCancelled()) {
            return;
        }
        if (!this.payForCommand(Conf.econCostTag, TL.COMMAND_TAG_TOCHANGE, TL.COMMAND_TAG_FORCHANGE)) {
            return;
        }
        String oldtag = this.myFaction.getTag();
        this.myFaction.setTag(tag);
        for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
            if (fplayer.getFactionId().equals(this.myFaction.getId())) {
                fplayer.msg(TL.COMMAND_TAG_FACTION, this.fme.describeTo(this.myFaction, true), this.myFaction.getTag(this.myFaction));
                continue;
            }
            Faction faction = fplayer.getFaction();
            fplayer.msg(TL.COMMAND_TAG_CHANGED, this.fme.getColorTo(faction) + oldtag, this.myFaction.getTag(faction));
        }
        FTeamWrapper.updatePrefixes(this.myFaction);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_TAG_DESCRIPTION;
    }
}

