/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.bukkit.entity.Player;

public class CmdTop
extends FCommand {
    public CmdTop() {
        this.aliases.add("top");
        this.aliases.add("t");
        this.requiredArgs.add("criteria");
        this.optionalArgs.put("page", "1");
        this.permission = Permission.TOP.node;
        this.disableOnLock = false;
        this.senderMustBePlayer = false;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        ArrayList<Faction> factionList = Factions.getInstance().getAllFactions();
        factionList.remove(Factions.getInstance().getNone());
        factionList.remove(Factions.getInstance().getSafeZone());
        factionList.remove(Factions.getInstance().getWarZone());
        String criteria = this.argAsString(0);
        if (criteria.equalsIgnoreCase("members")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    int f2Size;
                    int f1Size = f1.getFPlayers().size();
                    if (f1Size < (f2Size = f2.getFPlayers().size())) {
                        return 1;
                    }
                    if (f1Size > f2Size) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (criteria.equalsIgnoreCase("start")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    long f2start;
                    long f1start = f1.getFoundedDate();
                    if (f1start > (f2start = f2.getFoundedDate())) {
                        return 1;
                    }
                    if (f1start < f2start) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (criteria.equalsIgnoreCase("power")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    int f2Size;
                    int f1Size = f1.getPowerRounded();
                    if (f1Size < (f2Size = f2.getPowerRounded())) {
                        return 1;
                    }
                    if (f1Size > f2Size) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (criteria.equalsIgnoreCase("land")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    int f2Size;
                    int f1Size = f1.getLandRounded();
                    if (f1Size < (f2Size = f2.getLandRounded())) {
                        return 1;
                    }
                    if (f1Size > f2Size) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (criteria.equalsIgnoreCase("online")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    int f2Size;
                    int f1Size = f1.getFPlayersWhereOnline(true).size();
                    if (f1Size < (f2Size = f2.getFPlayersWhereOnline(true).size())) {
                        return 1;
                    }
                    if (f1Size > f2Size) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (criteria.equalsIgnoreCase("money") || criteria.equalsIgnoreCase("balance") || criteria.equalsIgnoreCase("bal")) {
            Collections.sort(factionList, new Comparator<Faction>(){

                @Override
                public int compare(Faction f1, Faction f2) {
                    double f1Size = Econ.getBalance(f1.getAccountId());
                    for (FPlayer fp : f1.getFPlayers()) {
                        f1Size += Econ.getBalance(fp.getAccountId());
                    }
                    double f2Size = Econ.getBalance(f2.getAccountId());
                    for (FPlayer fp : f2.getFPlayers()) {
                        f2Size += Econ.getBalance(fp.getAccountId());
                    }
                    if (f1Size < f2Size) {
                        return 1;
                    }
                    if (f1Size > f2Size) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else {
            this.msg(TL.COMMAND_TOP_INVALID, criteria);
        }
        ArrayList<String> lines = new ArrayList<String>();
        factionList.add(0, Factions.getInstance().getNone());
        int pageheight = 9;
        int pagenumber = this.argAsInt(1, 1);
        int pagecount = factionList.size() / 9 + 1;
        if (pagenumber > pagecount) {
            pagenumber = pagecount;
        } else if (pagenumber < 1) {
            pagenumber = 1;
        }
        int start = (pagenumber - 1) * 9;
        int end = start + 9;
        if (end > factionList.size()) {
            end = factionList.size();
        }
        lines.add(TL.COMMAND_TOP_TOP.format(criteria.toUpperCase(), pagenumber, pagecount));
        int rank = 1;
        for (Faction faction : factionList.subList(start, end)) {
            String fac = this.sender instanceof Player ? faction.getRelationTo(this.fme).getColor() + faction.getTag() : faction.getTag();
            lines.add(TL.COMMAND_TOP_LINE.format(rank, fac, this.getValue(faction, criteria)));
            ++rank;
        }
        this.sendMessage(lines);
    }

    private String getValue(Faction faction, String criteria) {
        if (criteria.equalsIgnoreCase("online")) {
            return String.valueOf(faction.getFPlayersWhereOnline(true).size());
        }
        if (criteria.equalsIgnoreCase("start")) {
            return TL.sdf.format(faction.getFoundedDate());
        }
        if (criteria.equalsIgnoreCase("members")) {
            return String.valueOf(faction.getFPlayers().size());
        }
        if (criteria.equalsIgnoreCase("land")) {
            return String.valueOf(faction.getLandRounded());
        }
        if (criteria.equalsIgnoreCase("start")) {
            return this.sdf.format(faction.getFoundedDate());
        }
        if (criteria.equalsIgnoreCase("power")) {
            return String.valueOf(faction.getPowerRounded());
        }
        double balance = Econ.getBalance(faction.getAccountId());
        for (FPlayer fp : faction.getFPlayers()) {
            balance += Econ.getBalance(fp.getAccountId());
        }
        return String.valueOf(balance);
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_TOP_DESCRIPTION;
    }
}

