/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.LandUnclaimEvent;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CmdUnclaim
extends FCommand {
    public CmdUnclaim() {
        this.aliases.add("unclaim");
        this.aliases.add("declaim");
        this.permission = Permission.UNCLAIM.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = false;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        FLocation flocation = new FLocation(this.fme);
        Faction otherFaction = Board.getInstance().getFactionAt(flocation);
        if (otherFaction.isSafeZone()) {
            if (Permission.MANAGE_SAFE_ZONE.has(this.sender)) {
                Board.getInstance().removeAt(flocation);
                this.msg(TL.COMMAND_UNCLAIM_SAFEZONE_SUCCESS, new Object[0]);
                if (Conf.logLandUnclaims) {
                    P.p.log(TL.COMMAND_UNCLAIM_LOG.format(this.fme.getName(), flocation.getCoordString(), otherFaction.getTag()));
                }
            } else {
                this.msg(TL.COMMAND_UNCLAIM_SAFEZONE_NOPERM, new Object[0]);
            }
            return;
        }
        if (otherFaction.isWarZone()) {
            if (Permission.MANAGE_WAR_ZONE.has(this.sender)) {
                Board.getInstance().removeAt(flocation);
                this.msg(TL.COMMAND_UNCLAIM_WARZONE_SUCCESS, new Object[0]);
                if (Conf.logLandUnclaims) {
                    P.p.log(TL.COMMAND_UNCLAIM_LOG.format(this.fme.getName(), flocation.getCoordString(), otherFaction.getTag()));
                }
            } else {
                this.msg(TL.COMMAND_UNCLAIM_WARZONE_NOPERM, new Object[0]);
            }
            return;
        }
        if (this.fme.isAdminBypassing()) {
            Board.getInstance().removeAt(flocation);
            otherFaction.msg(TL.COMMAND_UNCLAIM_UNCLAIMED, this.fme.describeTo(otherFaction, true));
            this.msg(TL.COMMAND_UNCLAIM_UNCLAIMS, new Object[0]);
            if (Conf.logLandUnclaims) {
                P.p.log(TL.COMMAND_UNCLAIM_LOG.format(this.fme.getName(), flocation.getCoordString(), otherFaction.getTag()));
            }
            return;
        }
        if (!this.assertHasFaction()) {
            return;
        }
        if (!this.assertMinRole(Role.MODERATOR)) {
            return;
        }
        if (this.myFaction != otherFaction) {
            this.msg(TL.COMMAND_UNCLAIM_WRONGFACTION, new Object[0]);
            return;
        }
        LandUnclaimEvent unclaimEvent = new LandUnclaimEvent(flocation, otherFaction, this.fme);
        Bukkit.getServer().getPluginManager().callEvent((Event)unclaimEvent);
        if (unclaimEvent.isCancelled()) {
            return;
        }
        if (Econ.shouldBeUsed()) {
            double refund = Econ.calculateClaimRefund(this.myFaction.getLandRounded());
            if (Conf.bankEnabled && Conf.bankFactionPaysLandCosts ? !Econ.modifyMoney(this.myFaction, refund, TL.COMMAND_UNCLAIM_TOUNCLAIM.toString(), TL.COMMAND_UNCLAIM_FORUNCLAIM.toString()) : !Econ.modifyMoney(this.fme, refund, TL.COMMAND_UNCLAIM_TOUNCLAIM.toString(), TL.COMMAND_UNCLAIM_FORUNCLAIM.toString())) {
                return;
            }
        }
        Board.getInstance().removeAt(flocation);
        this.myFaction.msg(TL.COMMAND_UNCLAIM_FACTIONUNCLAIMED, this.fme.describeTo(this.myFaction, true));
        if (Conf.logLandUnclaims) {
            P.p.log(TL.COMMAND_UNCLAIM_LOG.format(this.fme.getName(), flocation.getCoordString(), otherFaction.getTag()));
        }
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_UNCLAIM_DESCRIPTION;
    }
}

