/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.WarmUpUtil;
import com.massivecraft.factions.zcore.MCommand;
import com.massivecraft.factions.zcore.util.TL;
import java.text.SimpleDateFormat;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class FCommand
extends MCommand<P> {
    public SimpleDateFormat sdf = new SimpleDateFormat(TL.DATE_FORMAT.toString());
    public boolean disableOnLock = true;
    public FPlayer fme;
    public Faction myFaction;
    public boolean senderMustBeMember = false;
    public boolean senderMustBeModerator = false;
    public boolean senderMustBeAdmin = false;
    public boolean isMoneyCommand = false;

    public FCommand() {
        super(P.p);
    }

    @Override
    public void execute(CommandSender sender, List<String> args, List<MCommand<?>> commandChain) {
        if (sender instanceof Player) {
            this.fme = FPlayers.getInstance().getByPlayer((Player)sender);
            this.myFaction = this.fme.getFaction();
        } else {
            this.fme = null;
            this.myFaction = null;
        }
        super.execute(sender, args, commandChain);
    }

    @Override
    public boolean isEnabled() {
        if (((P)this.p).getLocked() && this.disableOnLock) {
            this.msg("<b>Factions was locked by an admin. Please try again later.", new Object[0]);
            return false;
        }
        if (this.isMoneyCommand && !Conf.econEnabled) {
            this.msg("<b>Faction economy features are disabled on this server.", new Object[0]);
            return false;
        }
        if (this.isMoneyCommand && !Conf.bankEnabled) {
            this.msg("<b>The faction bank system is disabled on this server.", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean validSenderType(CommandSender sender, boolean informSenderIfNot) {
        boolean superValid = super.validSenderType(sender, informSenderIfNot);
        if (!superValid) {
            return false;
        }
        if (!(this.senderMustBeMember || this.senderMustBeModerator || this.senderMustBeAdmin)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        if (!this.fme.hasFaction()) {
            sender.sendMessage(((P)this.p).txt.parse("<b>You are not member of any faction."));
            return false;
        }
        if (this.senderMustBeModerator && !this.fme.getRole().isAtLeast(Role.MODERATOR)) {
            sender.sendMessage(((P)this.p).txt.parse("<b>Only faction moderators can %s.", this.getHelpShort()));
            return false;
        }
        if (this.senderMustBeAdmin && !this.fme.getRole().isAtLeast(Role.ADMIN)) {
            sender.sendMessage(((P)this.p).txt.parse("<b>Only faction admins can %s.", this.getHelpShort()));
            return false;
        }
        return true;
    }

    public boolean assertHasFaction() {
        if (this.me == null) {
            return true;
        }
        if (!this.fme.hasFaction()) {
            this.sendMessage("You are not member of any faction.");
            return false;
        }
        return true;
    }

    public boolean assertMinRole(Role role) {
        if (this.me == null) {
            return true;
        }
        if (this.fme.getRole().value < role.value) {
            this.msg("<b>You <h>must be " + (Object)((Object)role) + "<b> to " + this.getHelpShort() + ".", new Object[0]);
            return false;
        }
        return true;
    }

    public FPlayer strAsFPlayer(String name, FPlayer def, boolean msg) {
        FPlayer ret = def;
        if (name != null) {
            for (FPlayer fplayer : FPlayers.getInstance().getAllFPlayers()) {
                if (!fplayer.getName().equalsIgnoreCase(name)) continue;
                ret = fplayer;
                break;
            }
        }
        if (msg && ret == null) {
            this.msg("<b>No player \"<p>%s<b>\" could be found.", name);
        }
        return ret;
    }

    public FPlayer argAsFPlayer(int idx, FPlayer def, boolean msg) {
        return this.strAsFPlayer(this.argAsString(idx), def, msg);
    }

    public FPlayer argAsFPlayer(int idx, FPlayer def) {
        return this.argAsFPlayer(idx, def, true);
    }

    public FPlayer argAsFPlayer(int idx) {
        return this.argAsFPlayer(idx, null);
    }

    public FPlayer strAsBestFPlayerMatch(String name, FPlayer def, boolean msg) {
        return this.strAsFPlayer(name, def, msg);
    }

    public FPlayer argAsBestFPlayerMatch(int idx, FPlayer def, boolean msg) {
        return this.strAsBestFPlayerMatch(this.argAsString(idx), def, msg);
    }

    public FPlayer argAsBestFPlayerMatch(int idx, FPlayer def) {
        return this.argAsBestFPlayerMatch(idx, def, true);
    }

    public FPlayer argAsBestFPlayerMatch(int idx) {
        return this.argAsBestFPlayerMatch(idx, null);
    }

    public Faction strAsFaction(String name, Faction def, boolean msg) {
        Faction ret = def;
        if (name != null) {
            FPlayer fplayer;
            Faction faction = Factions.getInstance().getByTag(name);
            if (faction == null) {
                if (name.equalsIgnoreCase("warzone")) {
                    faction = Factions.getInstance().getWarZone();
                } else if (name.equalsIgnoreCase("safezone")) {
                    faction = Factions.getInstance().getSafeZone();
                }
            }
            if (faction == null) {
                faction = Factions.getInstance().getBestTagMatch(name);
            }
            if (faction == null && (fplayer = this.strAsFPlayer(name, null, false)) != null) {
                faction = fplayer.getFaction();
            }
            if (faction != null) {
                ret = faction;
            }
        }
        if (msg && ret == null) {
            this.msg("<b>The faction or player \"<p>%s<b>\" could not be found.", name);
        }
        return ret;
    }

    public Faction argAsFaction(int idx, Faction def, boolean msg) {
        return this.strAsFaction(this.argAsString(idx), def, msg);
    }

    public Faction argAsFaction(int idx, Faction def) {
        return this.argAsFaction(idx, def, true);
    }

    public Faction argAsFaction(int idx) {
        return this.argAsFaction(idx, null);
    }

    public boolean canIAdministerYou(FPlayer i, FPlayer you) {
        if (!i.getFaction().equals(you.getFaction())) {
            i.sendMessage(((P)this.p).txt.parse("%s <b>is not in the same faction as you.", you.describeTo(i, true)));
            return false;
        }
        if (i.getRole().value > you.getRole().value || i.getRole().equals((Object)Role.ADMIN)) {
            return true;
        }
        if (you.getRole().equals((Object)Role.ADMIN)) {
            i.sendMessage(((P)this.p).txt.parse("<b>Only the faction admin can do that."));
        } else if (i.getRole().equals((Object)Role.MODERATOR)) {
            if (i == you) {
                return true;
            }
            i.sendMessage(((P)this.p).txt.parse("<b>Moderators can't control each other..."));
        } else {
            i.sendMessage(((P)this.p).txt.parse("<b>You must be a faction moderator to do that."));
        }
        return false;
    }

    public boolean payForCommand(double cost, String toDoThis, String forDoingThis) {
        if (!Econ.shouldBeUsed() || this.fme == null || cost == 0.0 || this.fme.isAdminBypassing()) {
            return true;
        }
        if (Conf.bankEnabled && Conf.bankFactionPaysCosts && this.fme.hasFaction()) {
            return Econ.modifyMoney(this.myFaction, -cost, toDoThis, forDoingThis);
        }
        return Econ.modifyMoney(this.fme, -cost, toDoThis, forDoingThis);
    }

    public boolean payForCommand(double cost, TL toDoThis, TL forDoingThis) {
        return this.payForCommand(cost, toDoThis.toString(), forDoingThis.toString());
    }

    public boolean canAffordCommand(double cost, String toDoThis) {
        if (!Econ.shouldBeUsed() || this.fme == null || cost == 0.0 || this.fme.isAdminBypassing()) {
            return true;
        }
        if (Conf.bankEnabled && Conf.bankFactionPaysCosts && this.fme.hasFaction()) {
            return Econ.hasAtLeast(this.myFaction, cost, toDoThis);
        }
        return Econ.hasAtLeast(this.fme, cost, toDoThis);
    }

    public void doWarmUp(WarmUpUtil.Warmup warmup, TL translationKey, String action, Runnable runnable, long delay) {
        this.doWarmUp(this.fme, warmup, translationKey, action, runnable, delay);
    }

    public void doWarmUp(FPlayer player, WarmUpUtil.Warmup warmup, TL translationKey, String action, Runnable runnable, long delay) {
        WarmUpUtil.process(player, warmup, translationKey, action, runnable, delay);
    }
}

