/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.cmd;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.cmd.FCommand;
import com.massivecraft.factions.event.FactionRelationEvent;
import com.massivecraft.factions.event.FactionRelationWishEvent;
import com.massivecraft.factions.scoreboards.FTeamWrapper;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public abstract class FRelationCommand
extends FCommand {
    public Relation targetRelation;

    public FRelationCommand() {
        this.requiredArgs.add("faction tag");
        this.permission = Permission.RELATION.node;
        this.disableOnLock = true;
        this.senderMustBePlayer = true;
        this.senderMustBeMember = false;
        this.senderMustBeModerator = true;
        this.senderMustBeAdmin = false;
    }

    @Override
    public void perform() {
        Faction them = this.argAsFaction(0);
        if (them == null) {
            return;
        }
        if (!them.isNormal()) {
            this.msg(TL.COMMAND_RELATIONS_ALLTHENOPE, new Object[0]);
            return;
        }
        if (them == this.myFaction) {
            this.msg(TL.COMMAND_RELATIONS_MORENOPE, new Object[0]);
            return;
        }
        if (this.myFaction.getRelationWish(them) == this.targetRelation) {
            this.msg(TL.COMMAND_RELATIONS_ALREADYINRELATIONSHIP, them.getTag());
            return;
        }
        if (this.hasMaxRelations(them, this.targetRelation)) {
            return;
        }
        Relation oldRelation = this.myFaction.getRelationTo(them, true);
        FactionRelationWishEvent wishEvent = new FactionRelationWishEvent(this.fme, this.myFaction, them, oldRelation, this.targetRelation);
        Bukkit.getPluginManager().callEvent((Event)wishEvent);
        if (wishEvent.isCancelled()) {
            return;
        }
        if (!this.payForCommand(this.targetRelation.getRelationCost(), TL.COMMAND_RELATIONS_TOMARRY, TL.COMMAND_RELATIONS_FORMARRY)) {
            return;
        }
        this.myFaction.setRelationWish(them, this.targetRelation);
        Relation currentRelation = this.myFaction.getRelationTo(them, true);
        ChatColor currentRelationColor = currentRelation.getColor();
        if (this.targetRelation.value == currentRelation.value) {
            FactionRelationEvent relationEvent = new FactionRelationEvent(this.myFaction, them, oldRelation, currentRelation);
            Bukkit.getServer().getPluginManager().callEvent((Event)relationEvent);
            them.msg(TL.COMMAND_RELATIONS_MUTUAL, currentRelationColor + this.targetRelation.getTranslation(), currentRelationColor + this.myFaction.getTag());
            this.myFaction.msg(TL.COMMAND_RELATIONS_MUTUAL, currentRelationColor + this.targetRelation.getTranslation(), currentRelationColor + them.getTag());
        } else {
            them.msg(TL.COMMAND_RELATIONS_PROPOSAL_1, currentRelationColor + this.myFaction.getTag(), this.targetRelation.getColor() + this.targetRelation.getTranslation());
            them.msg(TL.COMMAND_RELATIONS_PROPOSAL_2, new Object[]{Conf.baseCommandAliases.get(0), this.targetRelation, this.myFaction.getTag()});
            this.myFaction.msg(TL.COMMAND_RELATIONS_PROPOSAL_SENT, currentRelationColor + them.getTag(), "" + this.targetRelation.getColor() + (Object)((Object)this.targetRelation));
        }
        if (!this.targetRelation.isNeutral() && them.isPeaceful()) {
            them.msg(TL.COMMAND_RELATIONS_PEACEFUL, new Object[0]);
            this.myFaction.msg(TL.COMMAND_RELATIONS_PEACEFULOTHER, new Object[0]);
        }
        if (!this.targetRelation.isNeutral() && this.myFaction.isPeaceful()) {
            them.msg(TL.COMMAND_RELATIONS_PEACEFULOTHER, new Object[0]);
            this.myFaction.msg(TL.COMMAND_RELATIONS_PEACEFUL, new Object[0]);
        }
        FTeamWrapper.updatePrefixes(this.myFaction);
        FTeamWrapper.updatePrefixes(them);
    }

    private boolean hasMaxRelations(Faction them, Relation targetRelation) {
        int max = P.p.getConfig().getInt("max-relations." + targetRelation.toString(), -1);
        if (P.p.getConfig().getBoolean("max-relations.enabled", false) && max != -1) {
            if (this.myFaction.getRelationCount(targetRelation) >= max) {
                this.msg(TL.COMMAND_RELATIONS_EXCEEDS_ME, max, targetRelation.getPluralTranslation());
                return true;
            }
            if (them.getRelationCount(targetRelation) > max) {
                this.msg(TL.COMMAND_RELATIONS_EXCEEDS_THEY, max, targetRelation.getPluralTranslation());
                return true;
            }
        }
        return false;
    }

    @Override
    public TL getUsageTranslation() {
        return TL.COMMAND_RELATIONS_DESCRIPTION;
    }
}

