/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.integration;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.iface.EconomyParticipator;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.RelationUtil;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Econ {
    private static Economy econ = null;
    private static final DecimalFormat format = new DecimalFormat("#,###");

    public static void setup() {
        if (Econ.isSetup()) {
            return;
        }
        String integrationFail = "Economy integration is " + (Conf.econEnabled ? "enabled, but" : "disabled, and") + " the plugin \"Vault\" ";
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            P.p.log(integrationFail + "is not installed.");
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            P.p.log(integrationFail + "is not hooked into an economy plugin.");
            return;
        }
        econ = (Economy)rsp.getProvider();
        P.p.log("Economy integration through Vault plugin successful.");
        if (!Conf.econEnabled) {
            P.p.log("NOTE: Economy is disabled. You can enable it with the command: f config econEnabled true");
        }
        P.p.cmdBase.cmdHelp.updateHelp();
    }

    public static boolean shouldBeUsed() {
        return Conf.econEnabled && econ != null && econ.isEnabled();
    }

    public static boolean isSetup() {
        return econ != null;
    }

    public static void modifyUniverseMoney(double delta) {
        if (!Econ.shouldBeUsed()) {
            return;
        }
        if (Conf.econUniverseAccount == null) {
            return;
        }
        if (Conf.econUniverseAccount.length() == 0) {
            return;
        }
        if (!econ.hasAccount(Conf.econUniverseAccount)) {
            return;
        }
        Econ.modifyBalance(Conf.econUniverseAccount, delta);
    }

    public static void sendBalanceInfo(FPlayer to, EconomyParticipator about) {
        if (!Econ.shouldBeUsed()) {
            P.p.log(Level.WARNING, (Object)"Vault does not appear to be hooked into an economy plugin.");
            return;
        }
        to.msg("<a>%s's<i> balance is <h>%s<i>.", about.describeTo(to, true), Econ.moneyString(econ.getBalance(about.getAccountId())));
    }

    public static boolean canIControllYou(EconomyParticipator i, EconomyParticipator you) {
        Faction fI = RelationUtil.getFaction(i);
        Faction fYou = RelationUtil.getFaction(you);
        if (fI == null) {
            return true;
        }
        if (i instanceof FPlayer && ((FPlayer)i).isAdminBypassing()) {
            return true;
        }
        if (i instanceof FPlayer && Permission.MONEY_WITHDRAW_ANY.has((CommandSender)((FPlayer)i).getPlayer())) {
            return true;
        }
        if (i == you) {
            return true;
        }
        if (i == fI && fI == fYou) {
            return true;
        }
        if (you instanceof Faction && fI == fYou && (Conf.bankMembersCanWithdraw || ((FPlayer)i).getRole().value >= Role.MODERATOR.value)) {
            return true;
        }
        i.msg("<h>%s<i> lacks permission to control <h>%s's<i> money.", i.describeTo(i, true), you.describeTo(i));
        return false;
    }

    public static boolean transferMoney(EconomyParticipator invoker, EconomyParticipator from, EconomyParticipator to, double amount) {
        return Econ.transferMoney(invoker, from, to, amount, true);
    }

    public static boolean transferMoney(EconomyParticipator invoker, EconomyParticipator from, EconomyParticipator to, double amount, boolean notify) {
        OfflinePlayer toAcc;
        OfflinePlayer fromAcc;
        if (!Econ.shouldBeUsed()) {
            return false;
        }
        if (amount < 0.0) {
            amount *= -1.0;
            EconomyParticipator temp = from;
            from = to;
            to = temp;
        }
        if (!Econ.canIControllYou(invoker, from)) {
            return false;
        }
        if (Econ.isUUID(from.getAccountId())) {
            fromAcc = Bukkit.getOfflinePlayer((UUID)UUID.fromString(from.getAccountId()));
            if (fromAcc.getName() == null) {
                return false;
            }
        } else {
            fromAcc = Bukkit.getOfflinePlayer((String)from.getAccountId());
        }
        if (Econ.isUUID(to.getAccountId())) {
            toAcc = Bukkit.getOfflinePlayer((UUID)UUID.fromString(to.getAccountId()));
            if (toAcc.getName() == null) {
                return false;
            }
        } else {
            toAcc = Bukkit.getOfflinePlayer((String)to.getAccountId());
        }
        if (!econ.has(fromAcc, amount)) {
            if (invoker != null && notify) {
                invoker.msg("<h>%s<b> can't afford to transfer <h>%s<b> to %s<b>.", from.describeTo(invoker, true), Econ.moneyString(amount), to.describeTo(invoker));
            }
            return false;
        }
        EconomyResponse erw = econ.withdrawPlayer(fromAcc, amount);
        if (erw.transactionSuccess()) {
            EconomyResponse erd = econ.depositPlayer(toAcc, amount);
            if (erd.transactionSuccess()) {
                if (notify) {
                    Econ.sendTransferInfo(invoker, from, to, amount);
                }
                return true;
            }
            econ.depositPlayer(fromAcc, amount);
        }
        if (notify) {
            invoker.msg("Unable to transfer %s<b> to <h>%s<b> from <h>%s<b>.", Econ.moneyString(amount), to.describeTo(invoker), from.describeTo(invoker, true));
        }
        return false;
    }

    public static Set<FPlayer> getFplayers(EconomyParticipator ep) {
        HashSet<FPlayer> fplayers = new HashSet<FPlayer>();
        if (ep != null) {
            if (ep instanceof FPlayer) {
                fplayers.add((FPlayer)ep);
            } else if (ep instanceof Faction) {
                fplayers.addAll(((Faction)ep).getFPlayers());
            }
        }
        return fplayers;
    }

    public static void sendTransferInfo(EconomyParticipator invoker, EconomyParticipator from, EconomyParticipator to, double amount) {
        HashSet<FPlayer> recipients = new HashSet<FPlayer>();
        recipients.addAll(Econ.getFplayers(invoker));
        recipients.addAll(Econ.getFplayers(from));
        recipients.addAll(Econ.getFplayers(to));
        if (invoker == null) {
            for (FPlayer recipient : recipients) {
                recipient.msg("<h>%s<i> was transferred from <h>%s<i> to <h>%s<i>.", Econ.moneyString(amount), from.describeTo(recipient), to.describeTo(recipient));
            }
        } else if (invoker == from) {
            for (FPlayer recipient : recipients) {
                recipient.msg("<h>%s<i> <h>gave %s<i> to <h>%s<i>.", from.describeTo(recipient, true), Econ.moneyString(amount), to.describeTo(recipient));
            }
        } else if (invoker == to) {
            for (FPlayer recipient : recipients) {
                recipient.msg("<h>%s<i> <h>took %s<i> from <h>%s<i>.", to.describeTo(recipient, true), Econ.moneyString(amount), from.describeTo(recipient));
            }
        } else {
            for (FPlayer recipient : recipients) {
                recipient.msg("<h>%s<i> transferred <h>%s<i> from <h>%s<i> to <h>%s<i>.", invoker.describeTo(recipient, true), Econ.moneyString(amount), from.describeTo(recipient), to.describeTo(recipient));
            }
        }
    }

    public static boolean hasAtLeast(EconomyParticipator ep, double delta, String toDoThis) {
        OfflinePlayer offline;
        if (!Econ.shouldBeUsed()) {
            return true;
        }
        boolean affordable = false;
        double currentBalance = Econ.isUUID(ep.getAccountId()) ? ((offline = Bukkit.getOfflinePlayer((UUID)UUID.fromString(ep.getAccountId()))).getName() != null ? econ.getBalance(Bukkit.getOfflinePlayer((UUID)UUID.fromString(ep.getAccountId()))) : 0.0) : econ.getBalance(ep.getAccountId());
        if (currentBalance >= delta) {
            affordable = true;
        }
        if (!affordable) {
            if (toDoThis != null && !toDoThis.isEmpty()) {
                ep.msg("<h>%s<i> can't afford <h>%s<i> %s.", ep.describeTo(ep, true), Econ.moneyString(delta), toDoThis);
            }
            return false;
        }
        return true;
    }

    public static boolean modifyMoney(EconomyParticipator ep, double delta, String toDoThis, String forDoingThis) {
        OfflinePlayer acc;
        if (!Econ.shouldBeUsed()) {
            return false;
        }
        if (Econ.isUUID(ep.getAccountId())) {
            acc = Bukkit.getOfflinePlayer((UUID)UUID.fromString(ep.getAccountId()));
            if (acc.getName() == null) {
                return false;
            }
        } else {
            acc = Bukkit.getOfflinePlayer((String)ep.getAccountId());
        }
        String You = ep.describeTo(ep, true);
        if (delta == 0.0) {
            return true;
        }
        if (delta > 0.0) {
            EconomyResponse er = econ.depositPlayer(acc, delta);
            if (er.transactionSuccess()) {
                Econ.modifyUniverseMoney(-delta);
                if (forDoingThis != null && !forDoingThis.isEmpty()) {
                    ep.msg("<h>%s<i> gained <h>%s<i> %s.", You, Econ.moneyString(delta), forDoingThis);
                }
                return true;
            }
            if (forDoingThis != null && !forDoingThis.isEmpty()) {
                ep.msg("<h>%s<i> would have gained <h>%s<i> %s, but the deposit failed.", You, Econ.moneyString(delta), forDoingThis);
            }
            return false;
        }
        if (econ.has(acc, -delta) && econ.withdrawPlayer(acc, -delta).transactionSuccess()) {
            Econ.modifyUniverseMoney(-delta);
            if (forDoingThis != null && !forDoingThis.isEmpty()) {
                ep.msg("<h>%s<i> lost <h>%s<i> %s.", You, Econ.moneyString(-delta), forDoingThis);
            }
            return true;
        }
        if (toDoThis != null && !toDoThis.isEmpty()) {
            ep.msg("<h>%s<i> can't afford <h>%s<i> %s.", You, Econ.moneyString(-delta), toDoThis);
        }
        return false;
    }

    public static String moneyString(double amount) {
        return econ.format(amount);
    }

    public static double calculateClaimCost(int ownedLand, boolean takingFromAnotherFaction) {
        if (!Econ.shouldBeUsed()) {
            return 0.0;
        }
        return Conf.econCostClaimWilderness + Conf.econCostClaimWilderness * Conf.econClaimAdditionalMultiplier * (double)ownedLand - (takingFromAnotherFaction ? Conf.econCostClaimFromFactionBonus : 0.0);
    }

    public static double calculateClaimRefund(int ownedLand) {
        return Econ.calculateClaimCost(ownedLand - 1, false) * Conf.econClaimRefundMultiplier;
    }

    public static double calculateTotalLandValue(int ownedLand) {
        double amount = 0.0;
        for (int x = 0; x < ownedLand; ++x) {
            amount += Econ.calculateClaimCost(x, false);
        }
        return amount;
    }

    public static double calculateTotalLandRefund(int ownedLand) {
        return Econ.calculateTotalLandValue(ownedLand) * Conf.econClaimRefundMultiplier;
    }

    public static boolean hasAccount(String name) {
        return econ.hasAccount(name);
    }

    public static double getBalance(String account) {
        return econ.getBalance(account);
    }

    public static String getFriendlyBalance(UUID uuid) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offline.getName() == null) {
            return "0";
        }
        return format.format(econ.getBalance(offline));
    }

    public static String getFriendlyBalance(FPlayer player) {
        return Econ.getFriendlyBalance(UUID.fromString(player.getId()));
    }

    public static boolean setBalance(String account, double amount) {
        double current = econ.getBalance(account);
        if (current > amount) {
            return econ.withdrawPlayer(account, current - amount).transactionSuccess();
        }
        return econ.depositPlayer(account, amount - current).transactionSuccess();
    }

    public static boolean modifyBalance(String account, double amount) {
        if (amount < 0.0) {
            return econ.withdrawPlayer(account, -amount).transactionSuccess();
        }
        return econ.depositPlayer(account, amount).transactionSuccess();
    }

    public static boolean deposit(String account, double amount) {
        return econ.depositPlayer(account, amount).transactionSuccess();
    }

    public static boolean withdraw(String account, double amount) {
        return econ.withdrawPlayer(account, amount).transactionSuccess();
    }

    public static boolean isUUID(String uuid) {
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }
}

