/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.integration;

import com.massivecraft.factions.P;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Worldguard {
    private static WorldGuardPlugin wg;
    private static boolean enabled;

    public static void init(Plugin plugin) {
        Plugin wgplug = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        if (wgplug == null || !(wgplug instanceof WorldGuardPlugin)) {
            enabled = false;
            wg = null;
            P.p.log("Could not hook to WorldGuard. WorldGuard checks are disabled.");
        } else {
            wg = (WorldGuardPlugin)wgplug;
            enabled = true;
            P.p.log("Successfully hooked to WorldGuard.");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isPVP(Player player) {
        if (!enabled) {
            return true;
        }
        Location loc = player.getLocation();
        World world = loc.getWorld();
        Vector pt = BukkitUtil.toVector((Location)loc);
        RegionManager regionManager = wg.getRegionManager(world);
        ApplicableRegionSet set = regionManager.getApplicableRegions(pt);
        return set.allows(DefaultFlag.PVP);
    }

    public static boolean playerCanBuild(Player player, Location loc) {
        if (!enabled) {
            return false;
        }
        World world = loc.getWorld();
        Vector pt = BukkitUtil.toVector((Location)loc);
        if (wg.getRegionManager(world).getApplicableRegions(pt).size() > 0) {
            return wg.canBuild(player, loc);
        }
        return false;
    }

    public static boolean checkForRegionsInChunk(Location loc) {
        if (!enabled) {
            return false;
        }
        World world = loc.getWorld();
        Chunk chunk = world.getChunkAt(loc);
        int minChunkX = chunk.getX() << 4;
        int minChunkZ = chunk.getZ() << 4;
        int maxChunkX = minChunkX + 15;
        int maxChunkZ = minChunkZ + 15;
        int worldHeight = world.getMaxHeight();
        BlockVector minChunk = new BlockVector(minChunkX, 0, minChunkZ);
        BlockVector maxChunk = new BlockVector(maxChunkX, worldHeight, maxChunkZ);
        RegionManager regionManager = wg.getRegionManager(world);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("wgfactionoverlapcheck", minChunk, maxChunk);
        Map allregions = regionManager.getRegions();
        ArrayList allregionslist = new ArrayList(allregions.values());
        boolean foundregions = false;
        try {
            List overlaps = region.getIntersectingRegions(allregionslist);
            foundregions = overlaps != null && !overlaps.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return foundregions;
    }

    static {
        enabled = false;
    }
}

