/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.integration.dynmap;

import com.massivecraft.factions.Conf;

public class DynmapStyle {
    public String lineColor = null;
    public Double lineOpacity = null;
    public Integer lineWeight = null;
    public String fillColor = null;
    public Double fillOpacity = null;
    public String homeMarker = null;
    public Boolean boost = null;

    public int getLineColor() {
        return DynmapStyle.getColor(DynmapStyle.coalesce(this.lineColor, Conf.dynmapDefaultStyle.lineColor, "#00FF00"));
    }

    public DynmapStyle setStrokeColor(String strokeColor) {
        this.lineColor = strokeColor;
        return this;
    }

    public double getLineOpacity() {
        return DynmapStyle.coalesce(this.lineOpacity, Conf.dynmapDefaultStyle.lineOpacity, 0.8);
    }

    public DynmapStyle setLineOpacity(Double strokeOpacity) {
        this.lineOpacity = strokeOpacity;
        return this;
    }

    public int getLineWeight() {
        return DynmapStyle.coalesce(this.lineWeight, Conf.dynmapDefaultStyle.lineWeight, 3);
    }

    public DynmapStyle setLineWeight(Integer strokeWeight) {
        this.lineWeight = strokeWeight;
        return this;
    }

    public int getFillColor() {
        return DynmapStyle.getColor(DynmapStyle.coalesce(this.fillColor, Conf.dynmapDefaultStyle.fillColor, "#00FF00"));
    }

    public DynmapStyle setFillColor(String fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public double getFillOpacity() {
        return DynmapStyle.coalesce(this.fillOpacity, Conf.dynmapDefaultStyle.fillOpacity, 0.35);
    }

    public DynmapStyle setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
        return this;
    }

    public String getHomeMarker() {
        return DynmapStyle.coalesce(this.homeMarker, Conf.dynmapDefaultStyle.homeMarker, "greenflag");
    }

    public DynmapStyle setHomeMarker(String homeMarker) {
        this.homeMarker = homeMarker;
        return this;
    }

    public boolean getBoost() {
        return DynmapStyle.coalesce(this.boost, Conf.dynmapDefaultStyle.boost, false);
    }

    public DynmapStyle setBoost(Boolean boost) {
        this.boost = boost;
        return this;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... items) {
        for (T item : items) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static int getColor(String string) {
        int ret = 65280;
        try {
            ret = Integer.parseInt(string.substring(1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }
}

