/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.integration.dynmap;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.integration.dynmap.DynmapStyle;
import com.massivecraft.factions.integration.dynmap.TempAreaMarker;
import com.massivecraft.factions.integration.dynmap.TempMarker;
import com.massivecraft.factions.integration.dynmap.TempMarkerSet;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.persist.MemoryBoard;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PlayerSet;
import org.dynmap.utils.TileFlags;

public class EngineDynmap {
    public static final int BLOCKS_PER_CHUNK = 16;
    public static final String DYNMAP_INTEGRATION = "\u00a7dDynmap Integration: \u00a7e";
    public static final String FACTIONS = "factions";
    public static final String FACTIONS_ = "factions_";
    public static final String FACTIONS_MARKERSET = "factions_markerset";
    public static final String FACTIONS_HOME = "factions_home";
    public static final String FACTIONS_HOME_ = "factions_home_";
    public static final String FACTIONS_PLAYERSET = "factions_playerset";
    public static final String FACTIONS_PLAYERSET_ = "factions_playerset_";
    private static EngineDynmap i = new EngineDynmap();
    public DynmapAPI dynmapApi;
    public MarkerAPI markerApi;
    public MarkerSet markerset;

    public static EngineDynmap getInstance() {
        return i;
    }

    private EngineDynmap() {
    }

    public void init() {
        Plugin dynmap = Bukkit.getServer().getPluginManager().getPlugin("dynmap");
        if (dynmap == null || !dynmap.isEnabled()) {
            return;
        }
        if (!Conf.dynmapUse) {
            if (this.markerset != null) {
                this.markerset.deleteMarkerSet();
                this.markerset = null;
            }
            return;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)P.p, new Runnable(){

            @Override
            public void run() {
                Map<String, TempMarker> homes = EngineDynmap.this.createHomes();
                Map<String, TempAreaMarker> areas = EngineDynmap.this.createAreas();
                Map<String, Set<String>> playerSets = EngineDynmap.this.createPlayersets();
                if (!EngineDynmap.this.updateCore()) {
                    return;
                }
                if (!EngineDynmap.this.updateLayer(EngineDynmap.this.createLayer())) {
                    return;
                }
                EngineDynmap.this.updateHomes(homes);
                EngineDynmap.this.updateAreas(areas);
                EngineDynmap.this.updatePlayersets(playerSets);
            }
        }, 100L, 100L);
    }

    public boolean updateCore() {
        this.dynmapApi = (DynmapAPI)Bukkit.getPluginManager().getPlugin("dynmap");
        if (this.dynmapApi == null) {
            EngineDynmap.severe("Could not retrieve the DynmapAPI.");
            return false;
        }
        this.markerApi = this.dynmapApi.getMarkerAPI();
        if (this.markerApi == null) {
            EngineDynmap.severe("Could not retrieve the MarkerAPI.");
            return false;
        }
        return true;
    }

    public TempMarkerSet createLayer() {
        TempMarkerSet ret = new TempMarkerSet();
        ret.label = Conf.dynmapLayerName;
        ret.minimumZoom = Conf.dynmapLayerMinimumZoom;
        ret.priority = Conf.dynmapLayerPriority;
        ret.hideByDefault = !Conf.dynmapLayerVisible;
        return ret;
    }

    public boolean updateLayer(TempMarkerSet temp) {
        this.markerset = this.markerApi.getMarkerSet(FACTIONS_MARKERSET);
        if (this.markerset == null) {
            this.markerset = temp.create(this.markerApi, FACTIONS_MARKERSET);
            if (this.markerset == null) {
                EngineDynmap.severe("Could not create the Faction Markerset/Layer");
                return false;
            }
        } else {
            temp.update(this.markerset);
        }
        return true;
    }

    public Map<String, TempMarker> createHomes() {
        HashMap<String, TempMarker> ret = new HashMap<String, TempMarker>();
        for (Faction faction : Factions.getInstance().getAllFactions()) {
            Location ps = faction.getHome();
            if (ps == null) continue;
            DynmapStyle style = this.getStyle(faction);
            String markerId = FACTIONS_HOME_ + faction.getId();
            TempMarker temp = new TempMarker();
            temp.label = ChatColor.stripColor((String)faction.getTag());
            temp.world = ps.getWorld().toString();
            temp.x = ps.getX();
            temp.y = ps.getY();
            temp.z = ps.getZ();
            temp.iconName = style.getHomeMarker();
            temp.description = this.getDescription(faction);
            ret.put(markerId, temp);
        }
        return ret;
    }

    public void updateHomes(Map<String, TempMarker> homes) {
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        for (Marker marker : this.markerset.getMarkers()) {
            markers.put(marker.getMarkerID(), marker);
        }
        for (Map.Entry entry : homes.entrySet()) {
            String markerId = (String)entry.getKey();
            TempMarker temp = (TempMarker)entry.getValue();
            Marker marker = (Marker)markers.remove(markerId);
            if (marker == null) {
                marker = temp.create(this.markerApi, this.markerset, markerId);
                if (marker != null) continue;
                EngineDynmap.severe("Could not get/create the home marker " + markerId);
                continue;
            }
            temp.update(this.markerApi, marker);
        }
        for (Marker marker : markers.values()) {
            marker.deleteMarker();
        }
    }

    public Map<String, TempAreaMarker> createAreas() {
        Map<String, Map<Faction, Set<FLocation>>> worldFactionChunks = this.createWorldFactionChunks();
        return this.createAreas(worldFactionChunks);
    }

    public Map<String, Map<Faction, Set<FLocation>>> createWorldFactionChunks() {
        HashMap<String, Map<Faction, Set<FLocation>>> worldFactionChunks = new HashMap<String, Map<Faction, Set<FLocation>>>();
        MemoryBoard board = (MemoryBoard)Board.getInstance();
        for (Map.Entry<FLocation, String> entry : board.flocationIds.entrySet()) {
            HashSet<FLocation> factionTerritory;
            String world = entry.getKey().getWorldName();
            Faction chunkOwner = Factions.getInstance().getFactionById(entry.getValue());
            HashMap<Faction, HashSet<FLocation>> factionChunks = (HashMap<Faction, HashSet<FLocation>>)worldFactionChunks.get(world);
            if (factionChunks == null) {
                factionChunks = new HashMap<Faction, HashSet<FLocation>>();
                worldFactionChunks.put(world, factionChunks);
            }
            if ((factionTerritory = (HashSet<FLocation>)factionChunks.get(chunkOwner)) == null) {
                factionTerritory = new HashSet<FLocation>();
                factionChunks.put(chunkOwner, factionTerritory);
            }
            factionTerritory.add(entry.getKey());
        }
        return worldFactionChunks;
    }

    public Map<String, TempAreaMarker> createAreas(Map<String, Map<Faction, Set<FLocation>>> worldFactionChunks) {
        HashMap<String, TempAreaMarker> ret = new HashMap<String, TempAreaMarker>();
        for (Map.Entry<String, Map<Faction, Set<FLocation>>> entry : worldFactionChunks.entrySet()) {
            String world = entry.getKey();
            Map<Faction, Set<FLocation>> factionChunks = entry.getValue();
            for (Map.Entry<Faction, Set<FLocation>> entry1 : factionChunks.entrySet()) {
                Faction faction = entry1.getKey();
                Set<FLocation> chunks = entry1.getValue();
                Map<String, TempAreaMarker> worldFactionMarkers = this.createAreas(world, faction, chunks);
                ret.putAll(worldFactionMarkers);
            }
        }
        return ret;
    }

    public Map<String, TempAreaMarker> createAreas(String world, Faction faction, Set<FLocation> chunks) {
        HashMap<String, TempAreaMarker> ret = new HashMap<String, TempAreaMarker>();
        if (!this.isVisible(faction, world)) {
            return ret;
        }
        if (chunks.isEmpty()) {
            return ret;
        }
        int markerIndex = 0;
        String description = this.getDescription(faction);
        DynmapStyle style = this.getStyle(faction);
        TileFlags allChunkFlags = new TileFlags();
        LinkedList<FLocation> allChunks = new LinkedList<FLocation>();
        for (FLocation chunk : chunks) {
            allChunkFlags.setFlag((int)chunk.getX(), (int)chunk.getZ(), true);
            allChunks.addLast(chunk);
        }
        while (allChunks != null) {
            TileFlags ourChunkFlags = null;
            LinkedList<FLocation> ourChunks = null;
            LinkedList<FLocation> newChunks = null;
            int minimumX = Integer.MAX_VALUE;
            int minimumZ = Integer.MAX_VALUE;
            for (FLocation chunk : allChunks) {
                int chunkX = (int)chunk.getX();
                int chunkZ = (int)chunk.getZ();
                if (ourChunkFlags == null && allChunkFlags.getFlag(chunkX, chunkZ)) {
                    ourChunkFlags = new TileFlags();
                    ourChunks = new LinkedList<FLocation>();
                    this.floodFillTarget(allChunkFlags, ourChunkFlags, chunkX, chunkZ);
                    ourChunks.add(chunk);
                    minimumX = chunkX;
                    minimumZ = chunkZ;
                    continue;
                }
                if (ourChunkFlags != null && ourChunkFlags.getFlag(chunkX, chunkZ)) {
                    ourChunks.add(chunk);
                    if (chunkX < minimumX) {
                        minimumX = chunkX;
                        minimumZ = chunkZ;
                        continue;
                    }
                    if (chunkX != minimumX || chunkZ >= minimumZ) continue;
                    minimumZ = chunkZ;
                    continue;
                }
                if (newChunks == null) {
                    newChunks = new LinkedList<FLocation>();
                }
                newChunks.add(chunk);
            }
            allChunks = newChunks;
            if (ourChunkFlags == null) continue;
            int initialX = minimumX;
            int initialZ = minimumZ;
            int currentX = minimumX;
            int currentZ = minimumZ;
            Direction direction = Direction.XPLUS;
            ArrayList<int[]> linelist = new ArrayList<int[]>();
            linelist.add(new int[]{initialX, initialZ});
            while (currentX != initialX || currentZ != initialZ || direction != Direction.ZMINUS) {
                switch (direction) {
                    case XPLUS: {
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ)) {
                            linelist.add(new int[]{currentX + 1, currentZ});
                            direction = Direction.ZPLUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ - 1)) {
                            ++currentX;
                            break;
                        }
                        linelist.add(new int[]{currentX + 1, currentZ--});
                        direction = Direction.ZMINUS;
                        ++currentX;
                        break;
                    }
                    case ZPLUS: {
                        if (!ourChunkFlags.getFlag(currentX, currentZ + 1)) {
                            linelist.add(new int[]{currentX + 1, currentZ + 1});
                            direction = Direction.XMINUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ + 1)) {
                            ++currentZ;
                            break;
                        }
                        linelist.add(new int[]{currentX + 1, currentZ + 1});
                        direction = Direction.XPLUS;
                        ++currentX;
                        ++currentZ;
                        break;
                    }
                    case XMINUS: {
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ)) {
                            linelist.add(new int[]{currentX, currentZ + 1});
                            direction = Direction.ZMINUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ + 1)) {
                            --currentX;
                            break;
                        }
                        linelist.add(new int[]{currentX--, currentZ + 1});
                        direction = Direction.ZPLUS;
                        ++currentZ;
                        break;
                    }
                    case ZMINUS: {
                        if (!ourChunkFlags.getFlag(currentX, currentZ - 1)) {
                            linelist.add(new int[]{currentX, currentZ});
                            direction = Direction.XPLUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ - 1)) {
                            --currentZ;
                            break;
                        }
                        linelist.add(new int[]{currentX--, currentZ--});
                        direction = Direction.XMINUS;
                    }
                }
            }
            int sz = linelist.size();
            double[] x = new double[sz];
            double[] z = new double[sz];
            for (int i = 0; i < sz; ++i) {
                int[] line = (int[])linelist.get(i);
                x[i] = (double)line[0] * 16.0;
                z[i] = (double)line[1] * 16.0;
            }
            String markerId = FACTIONS_ + world + "__" + faction.getId() + "__" + markerIndex;
            TempAreaMarker temp = new TempAreaMarker();
            temp.label = faction.getTag();
            temp.world = world;
            temp.x = x;
            temp.z = z;
            temp.description = description;
            temp.lineColor = style.getLineColor();
            temp.lineOpacity = style.getLineOpacity();
            temp.lineWeight = style.getLineWeight();
            temp.fillColor = style.getFillColor();
            temp.fillOpacity = style.getFillOpacity();
            temp.boost = style.getBoost();
            ret.put(markerId, temp);
            ++markerIndex;
        }
        return ret;
    }

    public void updateAreas(Map<String, TempAreaMarker> areas) {
        HashMap<String, AreaMarker> markers = new HashMap<String, AreaMarker>();
        for (AreaMarker areaMarker : this.markerset.getAreaMarkers()) {
            markers.put(areaMarker.getMarkerID(), areaMarker);
        }
        for (Map.Entry entry : areas.entrySet()) {
            String markerId = (String)entry.getKey();
            TempAreaMarker temp = (TempAreaMarker)entry.getValue();
            AreaMarker marker = (AreaMarker)markers.remove(markerId);
            if (marker == null) {
                marker = temp.create(this.markerset, markerId);
                if (marker != null) continue;
                EngineDynmap.severe("Could not get/create the area marker " + markerId);
                continue;
            }
            temp.update(marker);
        }
        for (AreaMarker areaMarker : markers.values()) {
            areaMarker.deleteMarker();
        }
    }

    public String createPlayersetId(Faction faction) {
        if (faction == null) {
            return null;
        }
        if (faction.isNone()) {
            return null;
        }
        String factionId = faction.getId();
        if (factionId == null) {
            return null;
        }
        return FACTIONS_PLAYERSET_ + factionId;
    }

    public Set<String> createPlayerset(Faction faction) {
        if (faction == null) {
            return null;
        }
        if (faction.isNone()) {
            return null;
        }
        HashSet<String> ret = new HashSet<String>();
        for (FPlayer fplayer : faction.getFPlayers()) {
            ret.add(fplayer.getId());
            ret.add(fplayer.getName());
        }
        return ret;
    }

    public Map<String, Set<String>> createPlayersets() {
        if (!Conf.dynmapVisibilityByFaction) {
            return null;
        }
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (Faction faction : Factions.getInstance().getAllFactions()) {
            Set<String> playerIds;
            String playersetId = this.createPlayersetId(faction);
            if (playersetId == null || (playerIds = this.createPlayerset(faction)) == null) continue;
            ret.put(playersetId, playerIds);
        }
        return ret;
    }

    public void updatePlayersets(Map<String, Set<String>> playersets) {
        if (playersets == null) {
            return;
        }
        for (PlayerSet playerSet : this.markerApi.getPlayerSets()) {
            if (!playerSet.getSetID().startsWith(FACTIONS_PLAYERSET_) || playersets.containsKey(playerSet.getSetID())) continue;
            playerSet.deleteSet();
        }
        for (Map.Entry entry : playersets.entrySet()) {
            String setId = (String)entry.getKey();
            Set playerIds = (Set)entry.getValue();
            PlayerSet set = this.markerApi.getPlayerSet(setId);
            if (set == null) {
                set = this.markerApi.createPlayerSet(setId, true, playerIds, false);
            }
            if (set == null) {
                EngineDynmap.severe("Could not get/create the player set " + setId);
                continue;
            }
            set.setPlayers(playerIds);
        }
    }

    private String getDescription(Faction faction) {
        String ret = "<div class=\"regioninfo\">" + Conf.dynmapDescription + "</div>";
        String name = faction.getTag();
        name = ChatColor.stripColor((String)name);
        name = EngineDynmap.escapeHtml(name);
        ret = ret.replace("%name%", name);
        String description = faction.getDescription();
        description = ChatColor.stripColor((String)description);
        description = EngineDynmap.escapeHtml(description);
        ret = ret.replace("%description%", description);
        String money = "unavailable";
        if (Conf.bankEnabled && Conf.dynmapDescriptionMoney) {
            money = String.format("%.2f", Econ.getBalance(faction.getAccountId()));
        }
        ret = ret.replace("%money%", money);
        Set<FPlayer> playersList = faction.getFPlayers();
        String playersCount = String.valueOf(playersList.size());
        String players = EngineDynmap.getHtmlPlayerString(playersList);
        FPlayer playersLeaderObject = faction.getFPlayerAdmin();
        String playersLeader = EngineDynmap.getHtmlPlayerName(playersLeaderObject);
        ArrayList<FPlayer> playersAdminsList = faction.getFPlayersWhereRole(Role.ADMIN);
        String playersAdminsCount = String.valueOf(playersAdminsList.size());
        String playersAdmins = EngineDynmap.getHtmlPlayerString(playersAdminsList);
        ArrayList<FPlayer> playersModeratorsList = faction.getFPlayersWhereRole(Role.MODERATOR);
        String playersModeratorsCount = String.valueOf(playersModeratorsList.size());
        String playersModerators = EngineDynmap.getHtmlPlayerString(playersModeratorsList);
        ArrayList<FPlayer> playersNormalsList = faction.getFPlayersWhereRole(Role.NORMAL);
        String playersNormalsCount = String.valueOf(playersNormalsList.size());
        String playersNormals = EngineDynmap.getHtmlPlayerString(playersNormalsList);
        ret = ret.replace("%players%", players);
        ret = ret.replace("%players.count%", playersCount);
        ret = ret.replace("%players.leader%", playersLeader);
        ret = ret.replace("%players.admins%", playersAdmins);
        ret = ret.replace("%players.admins.count%", playersAdminsCount);
        ret = ret.replace("%players.moderators%", playersModerators);
        ret = ret.replace("%players.moderators.count%", playersModeratorsCount);
        ret = ret.replace("%players.normals%", playersNormals);
        ret = ret.replace("%players.normals.count%", playersNormalsCount);
        return ret;
    }

    public static String getHtmlPlayerString(Collection<FPlayer> playersOfficersList) {
        String ret = "";
        for (FPlayer fplayer : playersOfficersList) {
            if (ret.length() > 0) {
                ret = ret + ", ";
            }
            ret = ret + EngineDynmap.getHtmlPlayerName(fplayer);
        }
        return ret;
    }

    public static String getHtmlPlayerName(FPlayer fplayer) {
        if (fplayer == null) {
            return "none";
        }
        return EngineDynmap.escapeHtml(fplayer.getName());
    }

    public static String escapeHtml(String string) {
        StringBuilder out = new StringBuilder(Math.max(16, string.length()));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private boolean isVisible(Faction faction, String world) {
        if (faction == null) {
            return false;
        }
        String factionId = faction.getId();
        if (factionId == null) {
            return false;
        }
        String factionName = faction.getTag();
        if (factionName == null) {
            return false;
        }
        Set<String> visible = Conf.dynmapVisibleFactions;
        Set<String> hidden = Conf.dynmapHiddenFactions;
        if (!(visible.isEmpty() || visible.contains(factionId) || visible.contains(factionName) || visible.contains("world:" + world))) {
            return false;
        }
        return !hidden.contains(factionId) && !hidden.contains(factionName) && !hidden.contains("world:" + world);
    }

    public DynmapStyle getStyle(Faction faction) {
        DynmapStyle ret = Conf.dynmapFactionStyles.get(faction.getId());
        if (ret != null) {
            return ret;
        }
        ret = Conf.dynmapFactionStyles.get(faction.getTag());
        if (ret != null) {
            return ret;
        }
        return Conf.dynmapDefaultStyle;
    }

    public static void info(String msg) {
        String message = DYNMAP_INTEGRATION + msg;
        System.out.println(message);
    }

    public static void severe(String msg) {
        String message = DYNMAP_INTEGRATION + ChatColor.RED.toString() + msg;
        System.out.println(message);
    }

    private int floodFillTarget(TileFlags source, TileFlags destination, int x, int y) {
        int cnt = 0;
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{x, y});
        while (!stack.isEmpty()) {
            int[] nxt = (int[])stack.pop();
            x = nxt[0];
            if (!source.getFlag(x, y = nxt[1])) continue;
            source.setFlag(x, y, false);
            destination.setFlag(x, y, true);
            ++cnt;
            if (source.getFlag(x + 1, y)) {
                stack.push(new int[]{x + 1, y});
            }
            if (source.getFlag(x - 1, y)) {
                stack.push(new int[]{x - 1, y});
            }
            if (source.getFlag(x, y + 1)) {
                stack.push(new int[]{x, y + 1});
            }
            if (!source.getFlag(x, y - 1)) continue;
            stack.push(new int[]{x, y - 1});
        }
        return cnt;
    }

    static enum Direction {
        XPLUS,
        ZPLUS,
        XMINUS,
        ZMINUS;

    }
}

