/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.integration.dynmap;

import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerSet;

public class TempAreaMarker {
    public String label;
    public String world;
    public double[] x;
    public double[] z;
    public String description;
    public int lineColor;
    public double lineOpacity;
    public int lineWeight;
    public int fillColor;
    public double fillOpacity;
    public boolean boost;

    public AreaMarker create(MarkerSet markerset, String markerId) {
        AreaMarker ret = markerset.createAreaMarker(markerId, this.label, false, this.world, this.x, this.z, false);
        if (ret == null) {
            return null;
        }
        ret.setDescription(this.description);
        ret.setLineStyle(this.lineWeight, this.lineOpacity, this.lineColor);
        ret.setFillStyle(this.fillOpacity, this.fillColor);
        ret.setBoostFlag(this.boost);
        return ret;
    }

    public void update(AreaMarker marker) {
        if (!TempAreaMarker.equals(marker, this.x, this.z)) {
            marker.setCornerLocations(this.x, this.z);
        }
        if (!marker.getLabel().equals(this.label)) {
            marker.setLabel(this.label);
        }
        if (!marker.getDescription().equals(this.description)) {
            marker.setDescription(this.description);
        }
        if (marker.getLineWeight() != this.lineWeight || marker.getLineOpacity() != this.lineOpacity || marker.getLineColor() != this.lineColor) {
            marker.setLineStyle(this.lineWeight, this.lineOpacity, this.lineColor);
        }
        if (marker.getFillOpacity() != this.fillOpacity || marker.getFillColor() != this.fillColor) {
            marker.setFillStyle(this.fillOpacity, this.fillColor);
        }
        if (marker.getBoostFlag() != this.boost) {
            marker.setBoostFlag(this.boost);
        }
    }

    public static boolean equals(AreaMarker marker, double[] x, double[] z) {
        int length = marker.getCornerCount();
        if (x.length != length) {
            return false;
        }
        if (z.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (marker.getCornerX(i) != x[i]) {
                return false;
            }
            if (marker.getCornerZ(i) == z[i]) continue;
            return false;
        }
        return true;
    }
}

