/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.listeners;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.integration.Worldguard;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Relation;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class FactionsBlockListener
implements Listener {
    public P p;

    public FactionsBlockListener(P p) {
        this.p = p;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.canBuild()) {
            return;
        }
        if (event.getBlockPlaced().getType() == Material.FIRE) {
            return;
        }
        if (!FactionsBlockListener.playerCanBuildDestroyBlock(event.getPlayer(), event.getBlock().getLocation(), "build", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (!Conf.handleExploitLiquidFlow) {
            return;
        }
        if (event.getBlock().isLiquid() && event.getToBlock().isEmpty()) {
            Faction to;
            Faction from = Board.getInstance().getFactionAt(new FLocation(event.getBlock()));
            if (from == (to = Board.getInstance().getFactionAt(new FLocation(event.getToBlock())))) {
                return;
            }
            if (to.isNormal()) {
                if (from.isNormal() && from.getRelationTo(to).isAlly()) {
                    return;
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!FactionsBlockListener.playerCanBuildDestroyBlock(event.getPlayer(), event.getBlock().getLocation(), "destroy", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        if (event.getInstaBreak() && !FactionsBlockListener.playerCanBuildDestroyBlock(event.getPlayer(), event.getBlock().getLocation(), "destroy", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (!Conf.pistonProtectionThroughDenyBuild) {
            return;
        }
        Faction pistonFaction = Board.getInstance().getFactionAt(new FLocation(event.getBlock()));
        Block targetBlock = event.getBlock().getRelative(event.getDirection(), event.getLength() + 1);
        if ((targetBlock.isEmpty() || targetBlock.isLiquid()) && !this.canPistonMoveBlock(pistonFaction, targetBlock.getLocation())) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky() || !Conf.pistonProtectionThroughDenyBuild) {
            return;
        }
        Location targetLoc = event.getRetractLocation();
        Faction otherFaction = Board.getInstance().getFactionAt(new FLocation(targetLoc));
        if (otherFaction.isNormal() && P.p.getConfig().getBoolean("disable-pistons-in-territory", false)) {
            event.setCancelled(true);
            return;
        }
        if (targetLoc.getBlock().isEmpty() || targetLoc.getBlock().isLiquid()) {
            return;
        }
        Faction pistonFaction = Board.getInstance().getFactionAt(new FLocation(event.getBlock()));
        if (!this.canPistonMoveBlock(pistonFaction, targetLoc)) {
            event.setCancelled(true);
            return;
        }
    }

    private boolean canPistonMoveBlock(Faction pistonFaction, Location target) {
        Faction otherFaction = Board.getInstance().getFactionAt(new FLocation(target));
        if (pistonFaction == otherFaction) {
            return true;
        }
        if (otherFaction.isNone()) {
            return !Conf.wildernessDenyBuild || Conf.worldsNoWildernessProtection.contains(target.getWorld().getName());
        }
        if (otherFaction.isSafeZone()) {
            return !Conf.safeZoneDenyBuild;
        }
        if (otherFaction.isWarZone()) {
            return !Conf.warZoneDenyBuild;
        }
        Relation rel = pistonFaction.getRelationTo(otherFaction);
        return !rel.confDenyBuild(otherFaction.hasPlayersOnline());
    }

    public static boolean playerCanBuildDestroyBlock(Player player, Location location, String action, boolean justCheck) {
        String name = player.getName();
        if (Conf.playersWhoBypassAllProtection.contains(name)) {
            return true;
        }
        FPlayer me = FPlayers.getInstance().getById(player.getUniqueId().toString());
        if (me.isAdminBypassing()) {
            return true;
        }
        FLocation loc = new FLocation(location);
        Faction otherFaction = Board.getInstance().getFactionAt(loc);
        if (otherFaction.isNone()) {
            if (Conf.worldGuardBuildPriority && Worldguard.playerCanBuild(player, location)) {
                return true;
            }
            if (!Conf.wildernessDenyBuild || Conf.worldsNoWildernessProtection.contains(location.getWorld().getName())) {
                return true;
            }
            if (!justCheck) {
                me.msg("<b>You can't " + action + " in the wilderness.", new Object[0]);
            }
            return false;
        }
        if (otherFaction.isSafeZone()) {
            if (Conf.worldGuardBuildPriority && Worldguard.playerCanBuild(player, location)) {
                return true;
            }
            if (!Conf.safeZoneDenyBuild || Permission.MANAGE_SAFE_ZONE.has((CommandSender)player)) {
                return true;
            }
            if (!justCheck) {
                me.msg("<b>You can't " + action + " in a safe zone.", new Object[0]);
            }
            return false;
        }
        if (otherFaction.isWarZone()) {
            if (Conf.worldGuardBuildPriority && Worldguard.playerCanBuild(player, location)) {
                return true;
            }
            if (!Conf.warZoneDenyBuild || Permission.MANAGE_WAR_ZONE.has((CommandSender)player)) {
                return true;
            }
            if (!justCheck) {
                me.msg("<b>You can't " + action + " in a war zone.", new Object[0]);
            }
            return false;
        }
        if (P.p.getConfig().getBoolean("hcf.raidable", false) && otherFaction.getLandRounded() >= otherFaction.getPowerRounded()) {
            return true;
        }
        Faction myFaction = me.getFaction();
        Relation rel = myFaction.getRelationTo(otherFaction);
        boolean online = otherFaction.hasPlayersOnline();
        boolean pain = !justCheck && rel.confPainBuild(online);
        boolean deny = rel.confDenyBuild(online);
        if (pain) {
            player.damage((double)Conf.actionDeniedPainAmount);
            if (!deny) {
                me.msg("<b>It is painful to try to " + action + " in the territory of " + otherFaction.getTag(myFaction), new Object[0]);
            }
        }
        if (deny) {
            if (!justCheck) {
                me.msg("<b>You can't " + action + " in the territory of " + otherFaction.getTag(myFaction), new Object[0]);
            }
            return false;
        }
        if (Conf.ownedAreasEnabled && (Conf.ownedAreaDenyBuild || Conf.ownedAreaPainBuild) && !otherFaction.playerHasOwnershipRights(me, loc)) {
            if (!pain && Conf.ownedAreaPainBuild && !justCheck) {
                player.damage((double)Conf.actionDeniedPainAmount);
                if (!Conf.ownedAreaDenyBuild) {
                    me.msg("<b>It is painful to try to " + action + " in this territory, it is owned by: " + otherFaction.getOwnerListString(loc), new Object[0]);
                }
            }
            if (Conf.ownedAreaDenyBuild) {
                if (!justCheck) {
                    me.msg("<b>You can't " + action + " in this territory, it is owned by: " + otherFaction.getOwnerListString(loc), new Object[0]);
                }
                return false;
            }
        }
        return true;
    }
}

