/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.listeners;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.struct.ChatMode;
import com.massivecraft.factions.struct.Relation;
import java.util.UnknownFormatConversionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class FactionsChatListener
implements Listener {
    public P p;

    public FactionsChatListener(P p) {
        this.p = p;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerEarlyChat(AsyncPlayerChatEvent event) {
        Player talkingPlayer = event.getPlayer();
        String msg = event.getMessage();
        FPlayer me = FPlayers.getInstance().getByPlayer(talkingPlayer);
        ChatMode chat = me.getChatMode();
        if (chat == ChatMode.FACTION) {
            Faction myFaction = me.getFaction();
            String message = String.format(Conf.factionChatFormat, me.describeTo(myFaction), msg);
            myFaction.sendMessage(message);
            Bukkit.getLogger().log(Level.INFO, ChatColor.stripColor((String)("FactionChat " + myFaction.getTag() + ": " + message)));
            for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
                if (!fplayer.isSpyingChat() || fplayer.getFaction() == myFaction || me == fplayer) continue;
                fplayer.sendMessage("[FCspy] " + myFaction.getTag() + ": " + message);
            }
            event.setCancelled(true);
        } else if (chat == ChatMode.ALLIANCE) {
            Faction myFaction = me.getFaction();
            String message = String.format(Conf.allianceChatFormat, ChatColor.stripColor((String)me.getNameAndTag()), msg);
            myFaction.sendMessage(message);
            for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
                if (myFaction.getRelationTo(fplayer) == Relation.ALLY && !fplayer.isIgnoreAllianceChat()) {
                    fplayer.sendMessage(message);
                    continue;
                }
                if (!fplayer.isSpyingChat() || me == fplayer) continue;
                fplayer.sendMessage("[ACspy]: " + message);
            }
            Bukkit.getLogger().log(Level.INFO, ChatColor.stripColor((String)("AllianceChat: " + message)));
            event.setCancelled(true);
        } else if (chat == ChatMode.TRUCE) {
            Faction myFaction = me.getFaction();
            String message = String.format(Conf.truceChatFormat, ChatColor.stripColor((String)me.getNameAndTag()), msg);
            myFaction.sendMessage(message);
            for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
                if (myFaction.getRelationTo(fplayer) == Relation.TRUCE) {
                    fplayer.sendMessage(message);
                    continue;
                }
                if (!fplayer.isSpyingChat() || fplayer == me) continue;
                fplayer.sendMessage("[TCspy]: " + message);
            }
            Bukkit.getLogger().log(Level.INFO, ChatColor.stripColor((String)("TruceChat: " + message)));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        int InsertIndex;
        if (!Conf.chatTagEnabled || Conf.chatTagHandledByAnotherPlugin) {
            return;
        }
        Player talkingPlayer = event.getPlayer();
        String msg = event.getMessage();
        String eventFormat = event.getFormat();
        FPlayer me = FPlayers.getInstance().getByPlayer(talkingPlayer);
        if (!Conf.chatTagReplaceString.isEmpty() && eventFormat.contains(Conf.chatTagReplaceString)) {
            if (eventFormat.contains("[FACTION_TITLE]")) {
                eventFormat = eventFormat.replace("[FACTION_TITLE]", me.getTitle());
            }
            InsertIndex = eventFormat.indexOf(Conf.chatTagReplaceString);
            eventFormat = eventFormat.replace(Conf.chatTagReplaceString, "");
            Conf.chatTagPadAfter = false;
            Conf.chatTagPadBefore = false;
        } else if (!Conf.chatTagInsertAfterString.isEmpty() && eventFormat.contains(Conf.chatTagInsertAfterString)) {
            InsertIndex = eventFormat.indexOf(Conf.chatTagInsertAfterString) + Conf.chatTagInsertAfterString.length();
        } else if (!Conf.chatTagInsertBeforeString.isEmpty() && eventFormat.contains(Conf.chatTagInsertBeforeString)) {
            InsertIndex = eventFormat.indexOf(Conf.chatTagInsertBeforeString);
        } else {
            InsertIndex = Conf.chatTagInsertIndex;
            if (InsertIndex > eventFormat.length()) {
                return;
            }
        }
        String formatStart = eventFormat.substring(0, InsertIndex) + (Conf.chatTagPadBefore && !me.getChatTag().isEmpty() ? " " : "");
        String formatEnd = (Conf.chatTagPadAfter && !me.getChatTag().isEmpty() ? " " : "") + eventFormat.substring(InsertIndex);
        String nonColoredMsgFormat = formatStart + me.getChatTag().trim() + formatEnd;
        if (Conf.chatTagRelationColored) {
            event.setCancelled(true);
            for (Player listeningPlayer : event.getRecipients()) {
                FPlayer you = FPlayers.getInstance().getByPlayer(listeningPlayer);
                String yourFormat = formatStart + me.getChatTag(you).trim() + formatEnd;
                try {
                    listeningPlayer.sendMessage(String.format(yourFormat, talkingPlayer.getDisplayName(), msg));
                }
                catch (UnknownFormatConversionException ex) {
                    Conf.chatTagInsertIndex = 0;
                    P.p.log(Level.SEVERE, (Object)"Critical error in chat message formatting!");
                    P.p.log(Level.SEVERE, (Object)"NOTE: This has been automatically fixed right now by setting chatTagInsertIndex to 0.");
                    P.p.log(Level.SEVERE, (Object)"For a more proper fix, please read this regarding chat configuration: http://massivecraft.com/plugins/factions/config#Chat_configuration");
                    return;
                }
            }
            String nonColoredMsg = ChatColor.stripColor((String)String.format(nonColoredMsgFormat, talkingPlayer.getDisplayName(), msg));
            Bukkit.getLogger().log(Level.INFO, nonColoredMsg);
        } else {
            event.setFormat(nonColoredMsgFormat);
        }
    }
}

