/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.listeners;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.event.PowerLossEvent;
import com.massivecraft.factions.listeners.FactionsBlockListener;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TravelAgent;
import org.bukkit.block.Block;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class FactionsEntityListener
implements Listener {
    public P p;
    private static final Set<PotionEffectType> badPotionEffects = new LinkedHashSet<PotionEffectType>(Arrays.asList(PotionEffectType.BLINDNESS, PotionEffectType.CONFUSION, PotionEffectType.HARM, PotionEffectType.HUNGER, PotionEffectType.POISON, PotionEffectType.SLOW, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.WITHER));

    public FactionsEntityListener(P p) {
        this.p = p;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDeath(EntityDeathEvent event) {
        String msg;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        FPlayer fplayer = FPlayers.getInstance().getByPlayer(player);
        Faction faction = Board.getInstance().getFactionAt(new FLocation(player.getLocation()));
        PowerLossEvent powerLossEvent = new PowerLossEvent(faction, fplayer);
        if (faction.isWarZone()) {
            if (!Conf.warZonePowerLoss) {
                powerLossEvent.setMessage(TL.PLAYER_POWER_NOLOSS_WARZONE.toString());
                powerLossEvent.setCancelled(true);
            }
            if (Conf.worldsNoPowerLoss.contains(player.getWorld().getName())) {
                powerLossEvent.setMessage(TL.PLAYER_POWER_LOSS_WARZONE.toString());
            }
        } else if (faction.isNone() && !Conf.wildernessPowerLoss && !Conf.worldsNoWildernessProtection.contains(player.getWorld().getName())) {
            powerLossEvent.setMessage(TL.PLAYER_POWER_NOLOSS_WILDERNESS.toString());
            powerLossEvent.setCancelled(true);
        } else if (Conf.worldsNoPowerLoss.contains(player.getWorld().getName())) {
            powerLossEvent.setMessage(TL.PLAYER_POWER_NOLOSS_WORLD.toString());
            powerLossEvent.setCancelled(true);
        } else if (Conf.peacefulMembersDisablePowerLoss && fplayer.hasFaction() && fplayer.getFaction().isPeaceful()) {
            powerLossEvent.setMessage(TL.PLAYER_POWER_NOLOSS_PEACEFUL.toString());
            powerLossEvent.setCancelled(true);
        } else {
            powerLossEvent.setMessage(TL.PLAYER_POWER_NOW.toString());
        }
        Bukkit.getPluginManager().callEvent((Event)powerLossEvent);
        if (!powerLossEvent.isCancelled()) {
            fplayer.onDeath();
        }
        if ((msg = powerLossEvent.getMessage()) != null && !msg.isEmpty()) {
            fplayer.msg(msg, fplayer.getPowerRounded(), fplayer.getPowerMaxRounded());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent sub = (EntityDamageByEntityEvent)event;
            if (!this.canDamagerHurtDamagee(sub, true)) {
                event.setCancelled(true);
            }
            Entity damagee = sub.getEntity();
            Entity damager = sub.getDamager();
            if (damagee != null && damagee instanceof Player) {
                this.cancelFStuckTeleport((Player)damagee);
            }
            if (damager instanceof Player) {
                this.cancelFStuckTeleport((Player)damager);
            }
        } else if (Conf.safeZonePreventAllDamageToPlayers && this.isPlayerInSafeZone(event.getEntity())) {
            event.setCancelled(true);
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FPlayer me = FPlayers.getInstance().getByPlayer(player);
            this.cancelFStuckTeleport(player);
            if (me.isWarmingUp()) {
                me.clearWarmup();
                me.msg(TL.WARMUPS_CANCELLED, new Object[0]);
            }
        }
    }

    public void cancelFStuckTeleport(Player player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (P.p.getStuckMap().containsKey(uuid)) {
            FPlayers.getInstance().getByPlayer(player).msg(TL.COMMAND_STUCK_CANCELLED, new Object[0]);
            P.p.getStuckMap().remove(uuid);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity boomer;
        Location loc;
        block16: {
            block17: {
                boolean online;
                Faction faction;
                block14: {
                    block15: {
                        block12: {
                            block13: {
                                loc = event.getLocation();
                                boomer = event.getEntity();
                                faction = Board.getInstance().getFactionAt(new FLocation(loc));
                                if (faction.noExplosionsInTerritory()) {
                                    event.setCancelled(true);
                                    return;
                                }
                                online = faction.hasPlayersOnline();
                                if (!(boomer instanceof Creeper)) break block12;
                                if (faction.isNone() && Conf.wildernessBlockCreepers && !Conf.worldsNoWildernessProtection.contains(loc.getWorld().getName()) || faction.isNormal() && (!online ? Conf.territoryBlockCreepersWhenOffline : Conf.territoryBlockCreepers)) break block13;
                                if ((!faction.isWarZone() || !Conf.warZoneBlockCreepers) && !faction.isSafeZone()) break block12;
                            }
                            event.setCancelled(true);
                            return;
                        }
                        if (!(boomer instanceof Fireball) && !(boomer instanceof WitherSkull) && !(boomer instanceof Wither)) break block14;
                        if (faction.isNone() && Conf.wildernessBlockFireballs && !Conf.worldsNoWildernessProtection.contains(loc.getWorld().getName()) || faction.isNormal() && (!online ? Conf.territoryBlockFireballsWhenOffline : Conf.territoryBlockFireballs)) break block15;
                        if ((!faction.isWarZone() || !Conf.warZoneBlockFireballs) && !faction.isSafeZone()) break block14;
                    }
                    event.setCancelled(true);
                    return;
                }
                if (!(boomer instanceof TNTPrimed) && !(boomer instanceof ExplosiveMinecart)) break block16;
                if (faction.isNone() && Conf.wildernessBlockTNT && !Conf.worldsNoWildernessProtection.contains(loc.getWorld().getName()) || faction.isNormal() && (!online ? Conf.territoryBlockTNTWhenOffline : Conf.territoryBlockTNT)) break block17;
                if ((!faction.isWarZone() || !Conf.warZoneBlockTNT) && (!faction.isSafeZone() || !Conf.safeZoneBlockTNT)) break block16;
            }
            event.setCancelled(true);
            return;
        }
        if (!(boomer instanceof TNTPrimed)) {
            if (!(boomer instanceof ExplosiveMinecart)) return;
        }
        if (!Conf.handleExploitTNTWaterlog) return;
        Block center = loc.getBlock();
        if (!center.isLiquid()) return;
        ArrayList<Block> targets = new ArrayList<Block>();
        targets.add(center.getRelative(0, 0, 1));
        targets.add(center.getRelative(0, 0, -1));
        targets.add(center.getRelative(0, 1, 0));
        targets.add(center.getRelative(0, -1, 0));
        targets.add(center.getRelative(1, 0, 0));
        targets.add(center.getRelative(-1, 0, 0));
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            Block target = (Block)iterator.next();
            int id = target.getTypeId();
            if (id == 0 || id >= 7 && id <= 11 || id == 49 || id == 90 || id == 116 || id == 119 || id == 120 || id == 130) continue;
            target.breakNaturally();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent event) {
        EntityDamageByEntityEvent sub = new EntityDamageByEntityEvent(event.getCombuster(), event.getEntity(), EntityDamageEvent.DamageCause.FIRE, 0);
        if (!this.canDamagerHurtDamagee(sub, false)) {
            event.setCancelled(true);
        }
        sub = null;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        boolean badjuju = false;
        for (PotionEffect effect : event.getPotion().getEffects()) {
            if (!badPotionEffects.contains(effect.getType())) continue;
            badjuju = true;
            break;
        }
        if (!badjuju) {
            return;
        }
        ProjectileSource thrower = event.getPotion().getShooter();
        if (!(thrower instanceof Entity)) {
            return;
        }
        if (thrower instanceof Player) {
            Player player = (Player)thrower;
            FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
            if (badjuju && fPlayer.getFaction().isPeaceful()) {
                event.setCancelled(true);
                return;
            }
        }
        for (LivingEntity target : event.getAffectedEntities()) {
            EntityDamageByEntityEvent sub = new EntityDamageByEntityEvent((Entity)thrower, (Entity)target, EntityDamageEvent.DamageCause.CUSTOM, 0);
            if (!this.canDamagerHurtDamagee(sub, true)) {
                event.setIntensity(target, 0.0);
            }
            sub = null;
        }
    }

    public boolean isPlayerInSafeZone(Entity damagee) {
        if (!(damagee instanceof Player)) {
            return false;
        }
        return Board.getInstance().getFactionAt(new FLocation(damagee.getLocation())).isSafeZone();
    }

    public boolean canDamagerHurtDamagee(EntityDamageByEntityEvent sub) {
        return this.canDamagerHurtDamagee(sub, true);
    }

    public boolean canDamagerHurtDamagee(EntityDamageByEntityEvent sub, boolean notify) {
        FPlayer attacker;
        Entity damager = sub.getDamager();
        Entity damagee = sub.getEntity();
        double damage = sub.getDamage();
        if (!(damagee instanceof Player)) {
            return true;
        }
        FPlayer defender = FPlayers.getInstance().getByPlayer((Player)damagee);
        if (defender == null || defender.getPlayer() == null) {
            return true;
        }
        Location defenderLoc = defender.getPlayer().getLocation();
        Faction defLocFaction = Board.getInstance().getFactionAt(new FLocation(defenderLoc));
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            if (!(projectile.getShooter() instanceof Entity)) {
                return true;
            }
            damager = (Entity)projectile.getShooter();
        }
        if (damager == damagee) {
            return true;
        }
        if (defLocFaction.noPvPInTerritory()) {
            if (damager instanceof Player) {
                if (notify) {
                    attacker = FPlayers.getInstance().getByPlayer((Player)damager);
                    attacker.msg(TL.PLAYER_CANTHURT, defLocFaction.isSafeZone() ? TL.REGION_SAFEZONE.toString() : TL.REGION_PEACEFUL.toString());
                }
                return false;
            }
            return !defLocFaction.noMonstersInTerritory();
        }
        if (!(damager instanceof Player)) {
            return true;
        }
        attacker = FPlayers.getInstance().getByPlayer((Player)damager);
        if (attacker == null || attacker.getPlayer() == null) {
            return true;
        }
        if (Conf.playersWhoBypassAllProtection.contains(attacker.getName())) {
            return true;
        }
        if (attacker.hasLoginPvpDisabled()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_LOGIN, Conf.noPVPDamageToOthersForXSecondsAfterLogin);
            }
            return false;
        }
        Faction locFaction = Board.getInstance().getFactionAt(new FLocation(attacker));
        if (locFaction.noPvPInTerritory()) {
            if (notify) {
                attacker.msg(TL.PLAYER_CANTHURT, locFaction.isSafeZone() ? TL.REGION_SAFEZONE.toString() : TL.REGION_PEACEFUL.toString());
            }
            return false;
        }
        if (locFaction.isWarZone() && Conf.warZoneFriendlyFire) {
            return true;
        }
        if (Conf.worldsIgnorePvP.contains(defenderLoc.getWorld().getName())) {
            return true;
        }
        Faction defendFaction = defender.getFaction();
        Faction attackFaction = attacker.getFaction();
        if (attackFaction.isNone() && Conf.disablePVPForFactionlessPlayers) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_REQUIREFACTION, new Object[0]);
            }
            return false;
        }
        if (defendFaction.isNone()) {
            if (defLocFaction == attackFaction && Conf.enablePVPAgainstFactionlessInAttackersLand) {
                return true;
            }
            if (Conf.disablePVPForFactionlessPlayers) {
                if (notify) {
                    attacker.msg(TL.PLAYER_PVP_FACTIONLESS, new Object[0]);
                }
                return false;
            }
        }
        if (defendFaction.isPeaceful()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_PEACEFUL, new Object[0]);
            }
            return false;
        }
        if (attackFaction.isPeaceful()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_PEACEFUL, new Object[0]);
            }
            return false;
        }
        Relation relation = defendFaction.getRelationTo(attackFaction);
        if (Conf.disablePVPBetweenNeutralFactions && relation.isNeutral()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_NEUTRAL, new Object[0]);
            }
            return false;
        }
        if (!defender.hasFaction()) {
            return true;
        }
        if (relation.isMember() || relation.isAlly()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_CANTHURT, defender.describeTo(attacker));
            }
            return false;
        }
        boolean ownTerritory = defender.isInOwnTerritory();
        if (ownTerritory && relation.isNeutral()) {
            if (notify) {
                attacker.msg(TL.PLAYER_PVP_NEUTRALFAIL, defender.describeTo(attacker));
                defender.msg(TL.PLAYER_PVP_TRIED, attacker.describeTo(defender, true));
            }
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getLocation() == null) {
            return;
        }
        if (Conf.safeZoneNerfedCreatureTypes.contains(event.getEntityType()) && Board.getInstance().getFactionAt(new FLocation(event.getLocation())).noMonstersInTerritory()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        if (!Conf.safeZoneNerfedCreatureTypes.contains(MiscUtil.creatureTypeFromEntity(event.getEntity()))) {
            return;
        }
        if (Board.getInstance().getFactionAt(new FLocation(target.getLocation())).noMonstersInTerritory()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPaintingBreak(HangingBreakEvent event) {
        block7: {
            block8: {
                if (event.getCause() != HangingBreakEvent.RemoveCause.EXPLOSION) break block7;
                Location loc = event.getEntity().getLocation();
                Faction faction = Board.getInstance().getFactionAt(new FLocation(loc));
                if (faction.noExplosionsInTerritory()) {
                    event.setCancelled(true);
                    return;
                }
                boolean online = faction.hasPlayersOnline();
                if (faction.isNone() && !Conf.worldsNoWildernessProtection.contains(loc.getWorld().getName()) && (Conf.wildernessBlockCreepers || Conf.wildernessBlockFireballs || Conf.wildernessBlockTNT) || faction.isNormal() && (!online ? Conf.territoryBlockCreepersWhenOffline || Conf.territoryBlockFireballsWhenOffline || Conf.territoryBlockTNTWhenOffline : Conf.territoryBlockCreepers || Conf.territoryBlockFireballs || Conf.territoryBlockTNT)) break block8;
                if ((!faction.isWarZone() || !Conf.warZoneBlockCreepers && !Conf.warZoneBlockFireballs && !Conf.warZoneBlockTNT) && !faction.isSafeZone()) break block7;
            }
            event.setCancelled(true);
        }
        if (!(event instanceof HangingBreakByEntityEvent)) {
            return;
        }
        Entity breaker = ((HangingBreakByEntityEvent)event).getRemover();
        if (!(breaker instanceof Player)) {
            return;
        }
        if (!FactionsBlockListener.playerCanBuildDestroyBlock((Player)breaker, event.getEntity().getLocation(), "remove paintings", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPaintingPlace(HangingPlaceEvent event) {
        if (!FactionsBlockListener.playerCanBuildDestroyBlock(event.getPlayer(), event.getBlock().getLocation(), "place paintings", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        block7: {
            block8: {
                Location loc;
                Entity entity;
                block6: {
                    entity = event.getEntity();
                    if (!(entity instanceof Enderman) && !(entity instanceof Wither)) {
                        return;
                    }
                    loc = event.getBlock().getLocation();
                    if (!(entity instanceof Enderman)) break block6;
                    if (this.stopEndermanBlockManipulation(loc)) {
                        event.setCancelled(true);
                    }
                    break block7;
                }
                if (!(entity instanceof Wither)) break block7;
                Faction faction = Board.getInstance().getFactionAt(new FLocation(loc));
                if (faction.isNone() && Conf.wildernessBlockFireballs && !Conf.worldsNoWildernessProtection.contains(loc.getWorld().getName()) || faction.isNormal() && (!faction.hasPlayersOnline() ? Conf.territoryBlockFireballsWhenOffline : Conf.territoryBlockFireballs)) break block8;
                if ((!faction.isWarZone() || !Conf.warZoneBlockFireballs) && !faction.isSafeZone()) break block7;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTravel(PlayerPortalEvent event) {
        if (!P.p.getConfig().getBoolean("portals.limit", false)) {
            return;
        }
        TravelAgent agent = event.getPortalTravelAgent();
        if (event.useTravelAgent() && agent.getCanCreatePortal() && agent.findPortal(event.getTo()) == null) {
            FLocation loc = new FLocation(event.getTo());
            Faction faction = Board.getInstance().getFactionAt(loc);
            if (faction.isNone()) {
                return;
            }
            if (!faction.isNormal() && !event.getPlayer().isOp()) {
                event.setCancelled(true);
                return;
            }
            FPlayer fp = FPlayers.getInstance().getByPlayer(event.getPlayer());
            String mininumRelation = P.p.getConfig().getString("portals.minimum-relation", "MEMBER");
            if (!fp.getFaction().getRelationTo(faction).isAtLeast(Relation.fromString(mininumRelation))) {
                event.setCancelled(true);
            }
        }
    }

    private boolean stopEndermanBlockManipulation(Location loc) {
        if (loc == null) {
            return false;
        }
        if (Conf.wildernessDenyEndermanBlocks && Conf.territoryDenyEndermanBlocks && Conf.territoryDenyEndermanBlocksWhenOffline && Conf.safeZoneDenyEndermanBlocks && Conf.warZoneDenyEndermanBlocks) {
            return true;
        }
        FLocation fLoc = new FLocation(loc);
        Faction claimFaction = Board.getInstance().getFactionAt(fLoc);
        if (claimFaction.isNone()) {
            return Conf.wildernessDenyEndermanBlocks;
        }
        if (claimFaction.isNormal()) {
            return claimFaction.hasPlayersOnline() ? Conf.territoryDenyEndermanBlocks : Conf.territoryDenyEndermanBlocksWhenOffline;
        }
        if (claimFaction.isSafeZone()) {
            return Conf.safeZoneDenyEndermanBlocks;
        }
        if (claimFaction.isWarZone()) {
            return Conf.warZoneDenyEndermanBlocks;
        }
        return false;
    }
}

