/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.scoreboards;

import com.google.common.base.Splitter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class BufferedObjective {
    private static final Method addEntryMethod;
    private static final int MAX_LINE_LENGTH;
    private final Scoreboard scoreboard;
    private final String baseName;
    private Objective current;
    private List<Team> currentTeams = new ArrayList<Team>();
    private String title;
    private DisplaySlot displaySlot;
    private int objPtr;
    private int teamPtr;
    private boolean requiresUpdate = false;
    private final Map<Integer, String> contents = new HashMap<Integer, String>();

    public BufferedObjective(Scoreboard scoreboard) {
        this.scoreboard = scoreboard;
        this.baseName = this.createBaseName();
        this.current = scoreboard.registerNewObjective(this.getNextObjectiveName(), "dummy");
    }

    private String createBaseName() {
        Random random = new Random();
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 14) {
            builder.append(Integer.toHexString(random.nextInt()));
        }
        return builder.toString().substring(0, 14);
    }

    public void setTitle(String title) {
        if (this.title == null || !this.title.equals(title)) {
            this.title = title;
            this.requiresUpdate = true;
        }
    }

    public void setDisplaySlot(DisplaySlot slot) {
        this.displaySlot = slot;
        this.current.setDisplaySlot(slot);
    }

    public void setAllLines(List<String> lines) {
        if (lines.size() != this.contents.size()) {
            this.contents.clear();
        }
        for (int i = 0; i < lines.size(); ++i) {
            this.setLine(lines.size() - i, lines.get(i));
        }
    }

    public void setLine(int lineNumber, String content) {
        if (content.length() > MAX_LINE_LENGTH) {
            content = content.substring(0, MAX_LINE_LENGTH);
        }
        content = ChatColor.translateAlternateColorCodes((char)'&', (String)content);
        if (this.contents.get(lineNumber) == null || !this.contents.get(lineNumber).equals(content)) {
            this.contents.put(lineNumber, content);
            this.requiresUpdate = true;
        }
    }

    public void hide() {
        if (this.displaySlot != null) {
            this.scoreboard.clearSlot(this.displaySlot);
        }
    }

    public void flip() {
        if (!this.requiresUpdate) {
            return;
        }
        this.requiresUpdate = false;
        Objective buffer = this.scoreboard.registerNewObjective(this.getNextObjectiveName(), "dummy");
        buffer.setDisplayName(this.title);
        ArrayList<Team> bufferTeams = new ArrayList<Team>();
        for (Map.Entry<Integer, String> entry : this.contents.entrySet()) {
            if (entry.getValue().length() > 16) {
                Team team = this.scoreboard.registerNewTeam(this.getNextTeamName());
                bufferTeams.add(team);
                Iterator split = Splitter.fixedLength((int)16).split((CharSequence)entry.getValue()).iterator();
                team.setPrefix((String)split.next());
                String name = (String)split.next();
                if (split.hasNext()) {
                    team.setSuffix((String)split.next());
                }
                try {
                    addEntryMethod.invoke((Object)team, name);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                buffer.getScore(name).setScore(entry.getKey().intValue());
                continue;
            }
            buffer.getScore(entry.getValue()).setScore(entry.getKey().intValue());
        }
        if (this.displaySlot != null) {
            buffer.setDisplaySlot(this.displaySlot);
        }
        this.current.unregister();
        Iterator<Team> it = this.currentTeams.iterator();
        while (it.hasNext()) {
            it.next().unregister();
            it.remove();
        }
        this.current = buffer;
        this.currentTeams = bufferTeams;
    }

    private String getNextObjectiveName() {
        return this.baseName + "_" + this.objPtr++ % 2;
    }

    private String getNextTeamName() {
        return this.baseName.substring(0, 10) + "_" + this.teamPtr++ % 999999;
    }

    static {
        Method addEntryMethodLookup = null;
        try {
            addEntryMethodLookup = Team.class.getMethod("addEntry", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        addEntryMethod = addEntryMethodLookup;
        MAX_LINE_LENGTH = addEntryMethod != null ? 48 : 16;
    }
}

