/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.scoreboards;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.P;
import com.massivecraft.factions.scoreboards.BufferedObjective;
import com.massivecraft.factions.scoreboards.FSidebarProvider;
import com.massivecraft.factions.scoreboards.FTeamWrapper;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Scoreboard;

public class FScoreboard {
    private static final Map<FPlayer, FScoreboard> fscoreboards = new HashMap<FPlayer, FScoreboard>();
    private final Scoreboard scoreboard;
    private final FPlayer fplayer;
    private final BufferedObjective bufferedObjective;
    private FSidebarProvider defaultProvider;
    private FSidebarProvider temporaryProvider;
    private boolean removed = false;

    public static boolean isSupportedByServer() {
        return Bukkit.getScoreboardManager() != null;
    }

    public static void init(FPlayer fplayer) {
        FScoreboard fboard = new FScoreboard(fplayer);
        fscoreboards.put(fplayer, fboard);
        if (fplayer.hasFaction()) {
            FTeamWrapper.applyUpdates(fplayer.getFaction());
        }
        FTeamWrapper.track(fboard);
    }

    public static void remove(FPlayer fplayer) {
        FScoreboard fboard = fscoreboards.remove(fplayer);
        if (fboard != null) {
            fboard.removed = true;
            FTeamWrapper.untrack(fboard);
        }
    }

    public static FScoreboard get(FPlayer fplayer) {
        return fscoreboards.get(fplayer);
    }

    public static FScoreboard get(Player player) {
        return fscoreboards.get(FPlayers.getInstance().getByPlayer(player));
    }

    private FScoreboard(FPlayer fplayer) {
        this.fplayer = fplayer;
        if (FScoreboard.isSupportedByServer()) {
            this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            this.bufferedObjective = new BufferedObjective(this.scoreboard);
            fplayer.getPlayer().setScoreboard(this.scoreboard);
        } else {
            this.scoreboard = null;
            this.bufferedObjective = null;
        }
    }

    protected FPlayer getFPlayer() {
        return this.fplayer;
    }

    protected Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void setSidebarVisibility(boolean visible) {
        if (!FScoreboard.isSupportedByServer()) {
            return;
        }
        this.bufferedObjective.setDisplaySlot((DisplaySlot)(visible ? DisplaySlot.SIDEBAR : null));
    }

    public void setDefaultSidebar(final FSidebarProvider provider, int updateInterval) {
        if (!FScoreboard.isSupportedByServer()) {
            return;
        }
        this.defaultProvider = provider;
        if (this.temporaryProvider == null) {
            this.updateObjective();
        }
        new BukkitRunnable(){

            public void run() {
                if (FScoreboard.this.removed || provider != FScoreboard.this.defaultProvider) {
                    this.cancel();
                    return;
                }
                if (FScoreboard.this.temporaryProvider == null) {
                    FScoreboard.this.updateObjective();
                }
            }
        }.runTaskTimer((Plugin)P.p, (long)updateInterval, (long)updateInterval);
    }

    public void setTemporarySidebar(final FSidebarProvider provider) {
        if (!FScoreboard.isSupportedByServer()) {
            return;
        }
        this.temporaryProvider = provider;
        this.updateObjective();
        new BukkitRunnable(){

            public void run() {
                if (FScoreboard.this.removed) {
                    return;
                }
                if (FScoreboard.this.temporaryProvider == provider) {
                    FScoreboard.this.temporaryProvider = null;
                    FScoreboard.this.updateObjective();
                }
            }
        }.runTaskLater((Plugin)P.p, (long)(P.p.getConfig().getInt("scoreboard.expiration", 7) * 20));
    }

    private void updateObjective() {
        FSidebarProvider provider;
        FSidebarProvider fSidebarProvider = provider = this.temporaryProvider != null ? this.temporaryProvider : this.defaultProvider;
        if (provider == null) {
            this.bufferedObjective.hide();
        } else {
            this.bufferedObjective.setTitle(provider.getTitle(this.fplayer));
            this.bufferedObjective.setAllLines(provider.getLines(this.fplayer));
            this.bufferedObjective.flip();
        }
    }
}

