/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.struct;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.zcore.util.TL;
import org.bukkit.ChatColor;

public enum Relation {
    MEMBER(4, "member"),
    ALLY(3, "ally"),
    TRUCE(2, "truce"),
    NEUTRAL(1, "neutral"),
    ENEMY(0, "enemy");

    public final int value;
    public final String nicename;

    private Relation(int value, String nicename) {
        this.value = value;
        this.nicename = nicename;
    }

    public String toString() {
        return this.nicename;
    }

    public static Relation fromString(String s) {
        if (s.equalsIgnoreCase("member")) {
            return MEMBER;
        }
        if (s.equalsIgnoreCase("ally")) {
            return ALLY;
        }
        if (s.equalsIgnoreCase("truce")) {
            return TRUCE;
        }
        if (s.equalsIgnoreCase("enemy")) {
            return ENEMY;
        }
        return NEUTRAL;
    }

    public String getTranslation() {
        try {
            return TL.valueOf("RELATION_" + this.name() + "_SINGULAR").toString();
        }
        catch (IllegalArgumentException e) {
            return this.toString();
        }
    }

    public String getPluralTranslation() {
        for (TL t : TL.values()) {
            if (!t.name().equalsIgnoreCase("RELATION_" + this.name() + "_PLURAL")) continue;
            return t.toString();
        }
        return this.toString();
    }

    public boolean isMember() {
        return this == MEMBER;
    }

    public boolean isAlly() {
        return this == ALLY;
    }

    public boolean isTruce() {
        return this == TRUCE;
    }

    public boolean isNeutral() {
        return this == NEUTRAL;
    }

    public boolean isEnemy() {
        return this == ENEMY;
    }

    public boolean isAtLeast(Relation relation) {
        return this.value >= relation.value;
    }

    public boolean isAtMost(Relation relation) {
        return this.value <= relation.value;
    }

    public ChatColor getColor() {
        if (this == MEMBER) {
            return Conf.colorMember;
        }
        if (this == ALLY) {
            return Conf.colorAlly;
        }
        if (this == NEUTRAL) {
            return Conf.colorNeutral;
        }
        if (this == TRUCE) {
            return Conf.colorTruce;
        }
        return Conf.colorEnemy;
    }

    public boolean confDenyBuild(boolean online) {
        if (this.isMember()) {
            return false;
        }
        if (online) {
            if (this.isEnemy()) {
                return Conf.territoryEnemyDenyBuild;
            }
            if (this.isAlly()) {
                return Conf.territoryAllyDenyBuild;
            }
            if (this.isTruce()) {
                return Conf.territoryTruceDenyBuild;
            }
            return Conf.territoryDenyBuild;
        }
        if (this.isEnemy()) {
            return Conf.territoryEnemyDenyBuildWhenOffline;
        }
        if (this.isAlly()) {
            return Conf.territoryAllyDenyBuildWhenOffline;
        }
        if (this.isTruce()) {
            return Conf.territoryTruceDenyBuildWhenOffline;
        }
        return Conf.territoryDenyBuildWhenOffline;
    }

    public boolean confPainBuild(boolean online) {
        if (this.isMember()) {
            return false;
        }
        if (online) {
            if (this.isEnemy()) {
                return Conf.territoryEnemyPainBuild;
            }
            if (this.isAlly()) {
                return Conf.territoryAllyPainBuild;
            }
            if (this.isTruce()) {
                return Conf.territoryTrucePainBuild;
            }
            return Conf.territoryPainBuild;
        }
        if (this.isEnemy()) {
            return Conf.territoryEnemyPainBuildWhenOffline;
        }
        if (this.isAlly()) {
            return Conf.territoryAllyPainBuildWhenOffline;
        }
        if (this.isTruce()) {
            return Conf.territoryTrucePainBuildWhenOffline;
        }
        return Conf.territoryPainBuildWhenOffline;
    }

    public boolean confDenyUseage() {
        if (this.isMember()) {
            return false;
        }
        if (this.isEnemy()) {
            return Conf.territoryEnemyDenyUseage;
        }
        if (this.isAlly()) {
            return Conf.territoryAllyDenyUseage;
        }
        if (this.isTruce()) {
            return Conf.territoryTruceDenyUseage;
        }
        return Conf.territoryDenyUseage;
    }

    public double getRelationCost() {
        if (this.isEnemy()) {
            return Conf.econCostEnemy;
        }
        if (this.isAlly()) {
            return Conf.econCostAlly;
        }
        if (this.isTruce()) {
            return Conf.econCostTruce;
        }
        return Conf.econCostNeutral;
    }
}

