/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.util;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.struct.Role;
import java.util.ArrayList;
import java.util.ListIterator;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoLeaveProcessTask
extends BukkitRunnable {
    private transient boolean readyToGo = false;
    private transient boolean finished = false;
    private transient ListIterator<FPlayer> iterator;
    private transient double toleranceMillis;

    public AutoLeaveProcessTask() {
        ArrayList fplayers = (ArrayList)FPlayers.getInstance().getAllFPlayers();
        this.iterator = fplayers.listIterator();
        this.toleranceMillis = Conf.autoLeaveAfterDaysOfInactivity * 24.0 * 60.0 * 60.0 * 1000.0;
        this.readyToGo = true;
        this.finished = false;
    }

    public void run() {
        if (Conf.autoLeaveAfterDaysOfInactivity <= 0.0 || (double)Conf.autoLeaveRoutineMaxMillisecondsPerTick <= 0.0) {
            this.stop();
            return;
        }
        if (!this.readyToGo) {
            return;
        }
        this.readyToGo = false;
        long loopStartTime = System.currentTimeMillis();
        while (this.iterator.hasNext()) {
            Faction faction;
            long now = System.currentTimeMillis();
            if (now > loopStartTime + (long)Conf.autoLeaveRoutineMaxMillisecondsPerTick) {
                this.readyToGo = true;
                return;
            }
            FPlayer fplayer = this.iterator.next();
            if (!fplayer.isOffline() || !((double)(now - fplayer.getLastLoginTime()) > this.toleranceMillis)) continue;
            if (Conf.logFactionLeave || Conf.logFactionKick) {
                P.p.log("Player " + fplayer.getName() + " was auto-removed due to inactivity.");
            }
            if (fplayer.getRole() == Role.ADMIN && (faction = fplayer.getFaction()) != null) {
                fplayer.getFaction().promoteNewLeader();
            }
            fplayer.leave(false);
            this.iterator.remove();
            if (!Conf.autoLeaveDeleteFPlayerData) continue;
            fplayer.remove();
        }
        this.stop();
    }

    public void stop() {
        this.readyToGo = false;
        this.finished = true;
        this.cancel();
    }

    public boolean isFinished() {
        return this.finished;
    }
}

