/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.util;

import com.massivecraft.factions.shade.com.google.gson.Gson;
import com.massivecraft.factions.shade.com.google.gson.TypeAdapter;
import com.massivecraft.factions.shade.com.google.gson.TypeAdapterFactory;
import com.massivecraft.factions.shade.com.google.gson.annotations.SerializedName;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.shade.com.google.gson.stream.JsonReader;
import com.massivecraft.factions.shade.com.google.gson.stream.JsonToken;
import com.massivecraft.factions.shade.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();
    public static final TypeAdapterFactory ENUM_FACTORY = EnumTypeAdapter.newEnumTypeHierarchyFactory();

    public EnumTypeAdapter(Class<T> classOfT) {
        try {
            for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                String name = constant.name();
                SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name = annotation.value();
                }
                this.nameToConstant.put(name, constant);
                this.constantToName.put(constant, name);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return (T)((Enum)this.nameToConstant.get(in.nextString()));
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        out.value(value == null ? null : this.constantToName.get(value));
    }

    public static <TT> TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                    return null;
                }
                if (!rawType.isEnum()) {
                    rawType = rawType.getSuperclass();
                }
                return new EnumTypeAdapter<T>(rawType);
            }
        };
    }
}

