/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.util;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.P;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MiscUtil {
    public static HashSet<String> substanceChars = new HashSet<String>(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"));

    public static EntityType creatureTypeFromEntity(Entity entity) {
        if (!(entity instanceof Creature)) {
            return null;
        }
        String name = entity.getClass().getSimpleName();
        name = name.substring(5);
        return EntityType.fromName((String)name);
    }

    public static long[] range(long start, long end) {
        long[] values = new long[(int)Math.abs(end - start) + 1];
        if (end < start) {
            long oldstart = start;
            start = end;
            end = oldstart;
        }
        for (long i = start; i <= end; ++i) {
            values[(int)(i - start)] = i;
        }
        return values;
    }

    public static String getComparisonString(String str) {
        String ret = "";
        str = ChatColor.stripColor((String)str);
        str = str.toLowerCase();
        for (char c : str.toCharArray()) {
            if (!substanceChars.contains(String.valueOf(c))) continue;
            ret = ret + c;
        }
        return ret.toLowerCase();
    }

    public static ArrayList<String> validateTag(String str) {
        ArrayList<String> errors = new ArrayList<String>();
        if (MiscUtil.getComparisonString(str).length() < Conf.factionTagLengthMin) {
            errors.add(P.p.txt.parse(TL.GENERIC_FACTIONTAG_TOOSHORT.toString(), Conf.factionTagLengthMin));
        }
        if (str.length() > Conf.factionTagLengthMax) {
            errors.add(P.p.txt.parse(TL.GENERIC_FACTIONTAG_TOOLONG.toString(), Conf.factionTagLengthMax));
        }
        for (char c : str.toCharArray()) {
            if (substanceChars.contains(String.valueOf(c))) continue;
            errors.add(P.p.txt.parse(TL.GENERIC_FACTIONTAG_ALPHANUMERIC.toString(), Character.valueOf(c)));
        }
        return errors;
    }

    public static Iterable<FPlayer> rankOrder(Iterable<FPlayer> players) {
        ArrayList<FPlayer> admins = new ArrayList<FPlayer>();
        ArrayList<FPlayer> moderators = new ArrayList<FPlayer>();
        ArrayList<FPlayer> normal = new ArrayList<FPlayer>();
        for (FPlayer player : players) {
            switch (player.getRole()) {
                case ADMIN: {
                    admins.add(player);
                    break;
                }
                case MODERATOR: {
                    moderators.add(player);
                    break;
                }
                case NORMAL: {
                    normal.add(player);
                }
            }
        }
        ArrayList<FPlayer> ret = new ArrayList<FPlayer>();
        ret.addAll(admins);
        ret.addAll(moderators);
        ret.addAll(normal);
        return ret;
    }
}

