/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VisualizeUtil {
    protected static Map<UUID, Set<Location>> playerLocations = new HashMap<UUID, Set<Location>>();

    public static Set<Location> getPlayerLocations(Player player) {
        return VisualizeUtil.getPlayerLocations(player.getUniqueId());
    }

    public static Set<Location> getPlayerLocations(UUID uuid) {
        Set<Location> ret = playerLocations.get(uuid);
        if (ret == null) {
            ret = new HashSet<Location>();
            playerLocations.put(uuid, ret);
        }
        return ret;
    }

    public static void addLocation(Player player, Location location, int typeId, byte data) {
        VisualizeUtil.getPlayerLocations(player).add(location);
        player.sendBlockChange(location, typeId, data);
    }

    public static void addLocation(Player player, Location location, int typeId) {
        VisualizeUtil.getPlayerLocations(player).add(location);
        player.sendBlockChange(location, typeId, (byte)0);
    }

    public static void addLocations(Player player, Map<Location, Integer> locationMaterialIds) {
        Set<Location> ploc = VisualizeUtil.getPlayerLocations(player);
        for (Map.Entry<Location, Integer> entry : locationMaterialIds.entrySet()) {
            ploc.add(entry.getKey());
            player.sendBlockChange(entry.getKey(), entry.getValue().intValue(), (byte)0);
        }
    }

    public static void addLocations(Player player, Collection<Location> locations, int typeId) {
        Set<Location> ploc = VisualizeUtil.getPlayerLocations(player);
        for (Location location : locations) {
            ploc.add(location);
            player.sendBlockChange(location, typeId, (byte)0);
        }
    }

    public static void addBlocks(Player player, Collection<Block> blocks, int typeId) {
        Set<Location> ploc = VisualizeUtil.getPlayerLocations(player);
        for (Block block : blocks) {
            Location location = block.getLocation();
            ploc.add(location);
            player.sendBlockChange(location, typeId, (byte)0);
        }
    }

    public static void clear(Player player) {
        Set<Location> locations = VisualizeUtil.getPlayerLocations(player);
        if (locations == null) {
            return;
        }
        for (Location location : locations) {
            Block block = location.getWorld().getBlockAt(location);
            player.sendBlockChange(location, block.getTypeId(), block.getData());
        }
        locations.clear();
    }
}

