/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.P;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.shade.mkremins.fanciful.FancyMessage;
import com.massivecraft.factions.zcore.CommandVisibility;
import com.massivecraft.factions.zcore.MPlugin;
import com.massivecraft.factions.zcore.util.TL;
import com.massivecraft.factions.zcore.util.TextUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class MCommand<T extends MPlugin> {
    public T p;
    public List<MCommand<?>> subCommands;
    public List<String> aliases;
    public boolean allowNoSlashAccess;
    public List<String> requiredArgs;
    public LinkedHashMap<String, String> optionalArgs;
    public boolean errorOnToManyArgs = true;
    private String helpShort;
    public List<String> helpLong;
    public CommandVisibility visibility;
    public boolean senderMustBePlayer;
    public String permission;
    public CommandSender sender;
    public Player me;
    public boolean senderIsConsole;
    public List<String> args;
    public List<MCommand<?>> commandChain = new ArrayList();

    public void addSubCommand(MCommand<?> subCommand) {
        subCommand.commandChain.addAll(this.commandChain);
        subCommand.commandChain.add(this);
        this.subCommands.add(subCommand);
    }

    public void setHelpShort(String val) {
        this.helpShort = val;
    }

    public String getHelpShort() {
        if (this.helpShort == null) {
            return this.getUsageTranslation().toString();
        }
        return this.helpShort;
    }

    public abstract TL getUsageTranslation();

    public MCommand(T p) {
        this.p = p;
        this.permission = null;
        this.allowNoSlashAccess = false;
        this.subCommands = new ArrayList();
        this.aliases = new ArrayList<String>();
        this.requiredArgs = new ArrayList<String>();
        this.optionalArgs = new LinkedHashMap();
        this.helpShort = null;
        this.helpLong = new ArrayList<String>();
        this.visibility = CommandVisibility.VISIBLE;
    }

    public void execute(CommandSender sender, List<String> args, List<MCommand<?>> commandChain) {
        this.sender = sender;
        if (sender instanceof Player) {
            this.me = (Player)sender;
            this.senderIsConsole = false;
        } else {
            this.me = null;
            this.senderIsConsole = true;
        }
        this.args = args;
        this.commandChain = commandChain;
        if (args.size() > 0) {
            for (MCommand<?> subCommand : this.subCommands) {
                if (!subCommand.aliases.contains(args.get(0))) continue;
                args.remove(0);
                commandChain.add(this);
                subCommand.execute(sender, args, commandChain);
                return;
            }
        }
        if (!this.validCall(this.sender, this.args)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.perform();
    }

    public void execute(CommandSender sender, List<String> args) {
        this.execute(sender, args, new ArrayList());
    }

    public abstract void perform();

    public boolean validCall(CommandSender sender, List<String> args) {
        return this.validSenderType(sender, true) && this.validSenderPermissions(sender, true) && this.validArgs(args, sender);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean validSenderType(CommandSender sender, boolean informSenderIfNot) {
        if (this.senderMustBePlayer && !(sender instanceof Player)) {
            if (informSenderIfNot) {
                this.msg(TL.GENERIC_PLAYERONLY, new Object[0]);
            }
            return false;
        }
        return true;
    }

    public boolean validSenderPermissions(CommandSender sender, boolean informSenderIfNot) {
        return this.permission == null || ((MPlugin)((Object)this.p)).perm.has(sender, this.permission, informSenderIfNot);
    }

    public boolean validArgs(List<String> args, CommandSender sender) {
        if (args.size() < this.requiredArgs.size()) {
            if (sender != null) {
                this.msg(TL.GENERIC_ARGS_TOOFEW, new Object[0]);
                sender.sendMessage(this.getUseageTemplate());
            }
            return false;
        }
        if (args.size() > this.requiredArgs.size() + this.optionalArgs.size() && this.errorOnToManyArgs) {
            if (sender != null) {
                List<String> theToMany = args.subList(this.requiredArgs.size() + this.optionalArgs.size(), args.size());
                this.msg(TL.GENERIC_ARGS_TOOMANY, TextUtil.implode(theToMany, " "));
                sender.sendMessage(this.getUseageTemplate());
            }
            return false;
        }
        return true;
    }

    public boolean validArgs(List<String> args) {
        return this.validArgs(args, null);
    }

    public String getUseageTemplate(List<MCommand<?>> commandChain, boolean addShortHelp) {
        StringBuilder ret = new StringBuilder();
        ret.append(((MPlugin)((Object)this.p)).txt.parseTags("<c>"));
        ret.append('/');
        for (MCommand<?> mc : commandChain) {
            ret.append(TextUtil.implode(mc.aliases, ","));
            ret.append(' ');
        }
        ret.append(TextUtil.implode(this.aliases, ","));
        ArrayList<String> args = new ArrayList<String>();
        for (String string : this.requiredArgs) {
            args.add("<" + string + ">");
        }
        for (Map.Entry entry : this.optionalArgs.entrySet()) {
            String val = (String)entry.getValue();
            val = val == null ? "" : "=" + val;
            args.add("[" + (String)entry.getKey() + val + "]");
        }
        if (args.size() > 0) {
            ret.append(((MPlugin)((Object)this.p)).txt.parseTags("<p> "));
            ret.append(TextUtil.implode(args, " "));
        }
        if (addShortHelp) {
            ret.append(((MPlugin)((Object)this.p)).txt.parseTags(" <i>"));
            ret.append(this.getHelpShort());
        }
        return ret.toString();
    }

    public String getUseageTemplate(boolean addShortHelp) {
        return this.getUseageTemplate(this.commandChain, addShortHelp);
    }

    public String getUseageTemplate() {
        return this.getUseageTemplate(false);
    }

    public void msg(String str, Object ... args) {
        this.sender.sendMessage(((MPlugin)((Object)this.p)).txt.parse(str, args));
    }

    public void msg(TL translation, Object ... args) {
        this.sender.sendMessage(((MPlugin)((Object)this.p)).txt.parse(translation.toString(), args));
    }

    public void sendMessage(String msg) {
        this.sender.sendMessage(msg);
    }

    public void sendMessage(List<String> msgs) {
        for (String msg : msgs) {
            this.sendMessage(msg);
        }
    }

    public void sendFancyMessage(FancyMessage message) {
        message.send(this.sender);
    }

    public void sendFancyMessage(List<FancyMessage> messages) {
        for (FancyMessage m : messages) {
            this.sendFancyMessage(m);
        }
    }

    public List<String> getToolTips(FPlayer player) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : this.p.getConfig().getStringList("tooltips.show")) {
            lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.replaceFPlayerTags(s, player)));
        }
        return lines;
    }

    public List<String> getToolTips(Faction faction) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : this.p.getConfig().getStringList("tooltips.list")) {
            lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.replaceFactionTags(s, faction)));
        }
        return lines;
    }

    public String replaceFPlayerTags(String s, FPlayer player) {
        if (s.contains("{balance}")) {
            String balance = Econ.isSetup() ? Econ.getFriendlyBalance(player) : "no balance";
            s = s.replace("{balance}", balance);
        }
        if (s.contains("{lastSeen}")) {
            String humanized = DurationFormatUtils.formatDurationWords((long)(System.currentTimeMillis() - player.getLastLoginTime()), (boolean)true, (boolean)true) + " ago";
            String lastSeen = player.isOnline() ? ChatColor.GREEN + "Online" : (System.currentTimeMillis() - player.getLastLoginTime() < 432000000L ? ChatColor.YELLOW + humanized : ChatColor.RED + humanized);
            s = s.replace("{lastSeen}", lastSeen);
        }
        if (s.contains("{power}")) {
            String power = player.getPowerRounded() + "/" + player.getPowerMaxRounded();
            s = s.replace("{power}", power);
        }
        if (s.contains("{group}")) {
            String group = P.p.getPrimaryGroup(Bukkit.getOfflinePlayer((UUID)UUID.fromString(player.getId())));
            s = s.replace("{group}", group);
        }
        return s;
    }

    public String replaceFactionTags(String s, Faction faction) {
        if (s.contains("{power}")) {
            s = s.replace("{power}", String.valueOf(faction.getPowerRounded()));
        }
        if (s.contains("{maxPower}")) {
            s = s.replace("{maxPower}", String.valueOf(faction.getPowerMaxRounded()));
        }
        if (s.contains("{leader}")) {
            FPlayer fLeader = faction.getFPlayerAdmin();
            String leader = fLeader == null ? "Server" : fLeader.getName().substring(0, fLeader.getName().length() > 14 ? 13 : fLeader.getName().length());
            s = s.replace("{leader}", leader);
        }
        if (s.contains("{chunks}")) {
            s = s.replace("{chunks}", String.valueOf(faction.getLandRounded()));
        }
        if (s.contains("{members}")) {
            s = s.replace("{members}", String.valueOf(faction.getSize()));
        }
        if (s.contains("{online}")) {
            s = s.replace("{online}", String.valueOf(faction.getOnlinePlayers().size()));
        }
        return s;
    }

    public boolean argIsSet(int idx) {
        return this.args.size() >= idx + 1;
    }

    public String argAsString(int idx, String def) {
        if (this.args.size() < idx + 1) {
            return def;
        }
        return this.args.get(idx);
    }

    public String argAsString(int idx) {
        return this.argAsString(idx, null);
    }

    public Integer strAsInt(String str, Integer def) {
        if (str == null) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Integer argAsInt(int idx, Integer def) {
        return this.strAsInt(this.argAsString(idx), def);
    }

    public Integer argAsInt(int idx) {
        return this.argAsInt(idx, null);
    }

    public Double strAsDouble(String str, Double def) {
        if (str == null) {
            return def;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Double argAsDouble(int idx, Double def) {
        return this.strAsDouble(this.argAsString(idx), def);
    }

    public Double argAsDouble(int idx) {
        return this.argAsDouble(idx, null);
    }

    public Boolean strAsBool(String str) {
        return (str = str.toLowerCase()).startsWith("y") || str.startsWith("t") || str.startsWith("on") || str.startsWith("+") || str.startsWith("1");
    }

    public Boolean argAsBool(int idx, boolean def) {
        String str = this.argAsString(idx);
        if (str == null) {
            return def;
        }
        return this.strAsBool(str);
    }

    public Boolean argAsBool(int idx) {
        return this.argAsBool(idx, false);
    }

    public Player strAsPlayer(String name, Player def, boolean msg) {
        Player player;
        Player ret = def;
        if (name != null && (player = Bukkit.getServer().getPlayer(name)) != null) {
            ret = player;
        }
        if (msg && ret == null) {
            this.msg(TL.GENERIC_NOPLAYERFOUND, name);
        }
        return ret;
    }

    public Player argAsPlayer(int idx, Player def, boolean msg) {
        return this.strAsPlayer(this.argAsString(idx), def, msg);
    }

    public Player argAsPlayer(int idx, Player def) {
        return this.argAsPlayer(idx, def, true);
    }

    public Player argAsPlayer(int idx) {
        return this.argAsPlayer(idx, null);
    }

    public Player strAsBestPlayerMatch(String name, Player def, boolean msg) {
        List players;
        Player ret = def;
        if (name != null && (players = Bukkit.getServer().matchPlayer(name)).size() > 0) {
            ret = (Player)players.get(0);
        }
        if (msg && ret == null) {
            this.msg(TL.GENERIC_NOPLAYERMATCH, name);
        }
        return ret;
    }

    public Player argAsBestPlayerMatch(int idx, Player def, boolean msg) {
        return this.strAsBestPlayerMatch(this.argAsString(idx), def, msg);
    }

    public Player argAsBestPlayerMatch(int idx, Player def) {
        return this.argAsBestPlayerMatch(idx, def, true);
    }

    public Player argAsBestPlayerMatch(int idx) {
        return this.argAsPlayer(idx, null);
    }
}

