/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.shade.com.google.gson.Gson;
import com.massivecraft.factions.shade.com.google.gson.GsonBuilder;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.zcore.MCommand;
import com.massivecraft.factions.zcore.MPluginSecretPlayerListener;
import com.massivecraft.factions.zcore.MPluginSecretServerListener;
import com.massivecraft.factions.zcore.persist.SaveTask;
import com.massivecraft.factions.zcore.util.PermUtil;
import com.massivecraft.factions.zcore.util.Persist;
import com.massivecraft.factions.zcore.util.TL;
import com.massivecraft.factions.zcore.util.TextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MPlugin
extends JavaPlugin {
    public Persist persist;
    public TextUtil txt;
    public PermUtil perm;
    public Gson gson;
    private Integer saveTask = null;
    private boolean autoSave = true;
    protected boolean loadSuccessful = false;
    public String refCommand = "";
    private MPluginSecretPlayerListener mPluginSecretPlayerListener;
    private MPluginSecretServerListener mPluginSecretServerListener;
    private List<MCommand<?>> baseCommands = new ArrayList();
    private Map<UUID, Long> timers = new HashMap<UUID, Long>();
    public Map<UUID, Integer> stuckMap = new HashMap<UUID, Integer>();
    private long timeEnableStart;
    public Map<String, String> rawTags = new LinkedHashMap<String, String>();

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean val) {
        this.autoSave = val;
    }

    public List<MCommand<?>> getBaseCommands() {
        return this.baseCommands;
    }

    public boolean preEnable() {
        this.log("=== ENABLE START ===");
        this.timeEnableStart = System.currentTimeMillis();
        this.getDataFolder().mkdirs();
        this.perm = new PermUtil(this);
        this.persist = new Persist(this);
        this.gson = this.getGsonBuilder().create();
        this.txt = new TextUtil();
        this.initTXT();
        try {
            Map refCmd = this.getDescription().getCommands();
            if (refCmd != null && !refCmd.isEmpty()) {
                this.refCommand = (String)refCmd.keySet().toArray()[0];
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.mPluginSecretPlayerListener = new MPluginSecretPlayerListener(this);
        this.mPluginSecretServerListener = new MPluginSecretServerListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.mPluginSecretPlayerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.mPluginSecretServerListener, (Plugin)this);
        if (this.saveTask == null && Conf.saveToFileEveryXMinutes > 0.0) {
            long saveTicks = (long)(1200.0 * Conf.saveToFileEveryXMinutes);
            this.saveTask = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new SaveTask(this), saveTicks, saveTicks);
        }
        this.loadLang();
        this.loadSuccessful = true;
        return true;
    }

    public void postEnable() {
        this.log("=== ENABLE DONE (Took " + (System.currentTimeMillis() - this.timeEnableStart) + "ms) ===");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLang() {
        File lang = new File(this.getDataFolder(), "lang.yml");
        OutputStream out = null;
        InputStream defLangStream = this.getResource("lang.yml");
        if (!lang.exists()) {
            try {
                this.getDataFolder().mkdir();
                lang.createNewFile();
                if (defLangStream != null) {
                    int read;
                    out = new FileOutputStream(lang);
                    byte[] byArray = new byte[1024];
                    while ((read = defLangStream.read(byArray)) != -1) {
                        out.write(byArray, 0, read);
                    }
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defLangStream);
                    TL.setFile(defConfig);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.getLogger().severe("[Factions] Couldn't create language file.");
                this.getLogger().severe("[Factions] This is a fatal error. Now disabling");
                this.setEnabled(false);
            }
            finally {
                if (defLangStream != null) {
                    try {
                        defLangStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
        for (TL item : TL.values()) {
            if (conf.getString(item.getPath()) != null) continue;
            conf.set(item.getPath(), (Object)item.getDefault());
        }
        if (conf.getString(TL.COMMAND_SHOW_POWER.getPath(), "").contains("%5$s")) {
            conf.set(TL.COMMAND_SHOW_POWER.getPath(), (Object)TL.COMMAND_SHOW_POWER.getDefault());
            this.log(Level.INFO, (Object)"Removed errant format specifier from f show power.");
        }
        TL.setFile(conf);
        try {
            conf.save(lang);
        }
        catch (IOException iOException) {
            this.getLogger().log(Level.WARNING, "Factions: Failed to save lang.yml.");
            this.getLogger().log(Level.WARNING, "Factions: Report this stack trace to drtshock.");
            iOException.printStackTrace();
        }
    }

    public void onDisable() {
        if (this.saveTask != null) {
            this.getServer().getScheduler().cancelTask(this.saveTask.intValue());
            this.saveTask = null;
        }
        if (this.loadSuccessful) {
            Factions.getInstance().forceSave();
            FPlayers.getInstance().forceSave();
            Board.getInstance().forceSave();
        }
        this.log("Disabled");
    }

    public void suicide() {
        this.log("Now I suicide!");
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().excludeFieldsWithModifiers(128, 64);
    }

    public void addRawTags() {
        this.rawTags.put("l", "<green>");
        this.rawTags.put("a", "<gold>");
        this.rawTags.put("n", "<silver>");
        this.rawTags.put("i", "<yellow>");
        this.rawTags.put("g", "<lime>");
        this.rawTags.put("b", "<rose>");
        this.rawTags.put("h", "<pink>");
        this.rawTags.put("c", "<aqua>");
        this.rawTags.put("p", "<teal>");
    }

    public void initTXT() {
        this.addRawTags();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map tagsFromFile = (Map)this.persist.load(type, "tags");
        if (tagsFromFile != null) {
            this.rawTags.putAll(tagsFromFile);
        }
        this.persist.save(this.rawTags, "tags");
        for (Map.Entry<String, String> rawTag : this.rawTags.entrySet()) {
            this.txt.tags.put(rawTag.getKey(), TextUtil.parseColor(rawTag.getValue()));
        }
    }

    public boolean logPlayerCommands() {
        return true;
    }

    public boolean handleCommand(CommandSender sender, String commandString, boolean testOnly) {
        return this.handleCommand(sender, commandString, testOnly, false);
    }

    public boolean handleCommand(final CommandSender sender, String commandString, boolean testOnly, boolean async) {
        boolean noSlash = true;
        if (commandString.startsWith("/")) {
            noSlash = false;
            commandString = commandString.substring(1);
        }
        for (final MCommand<?> command : this.getBaseCommands()) {
            if (noSlash && !command.allowNoSlashAccess) continue;
            for (String alias : command.aliases) {
                if (commandString.startsWith(alias + "  ")) {
                    return false;
                }
                if (!commandString.startsWith(alias + " ") && !commandString.equals(alias)) continue;
                final ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandString.split("\\s+")));
                args.remove(0);
                if (testOnly) {
                    return true;
                }
                if (async) {
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                        @Override
                        public void run() {
                            command.execute(sender, args);
                        }
                    });
                } else {
                    command.execute(sender, args);
                }
                return true;
            }
        }
        return false;
    }

    public boolean handleCommand(CommandSender sender, String commandString) {
        return this.handleCommand(sender, commandString, false);
    }

    public void preAutoSave() {
    }

    public void postAutoSave() {
    }

    public Map<UUID, Integer> getStuckMap() {
        return this.stuckMap;
    }

    public Map<UUID, Long> getTimers() {
        return this.timers;
    }

    public void log(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void log(String str, Object ... args) {
        this.log(Level.INFO, (Object)this.txt.parse(str, args));
    }

    public void log(Level level, String str, Object ... args) {
        this.log(level, (Object)this.txt.parse(str, args));
    }

    public void log(Level level, Object msg) {
        Bukkit.getLogger().log(level, "[" + this.getDescription().getFullName() + "] " + msg);
    }
}

