/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.util.AsciiCompass;
import com.massivecraft.factions.util.LazyLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;

public abstract class MemoryBoard
extends Board {
    public HashMap<FLocation, String> flocationIds = new HashMap();

    @Override
    public String getIdAt(FLocation flocation) {
        if (!this.flocationIds.containsKey(flocation)) {
            return "0";
        }
        return this.flocationIds.get(flocation);
    }

    @Override
    public Faction getFactionAt(FLocation flocation) {
        return Factions.getInstance().getFactionById(this.getIdAt(flocation));
    }

    @Override
    public void setIdAt(String id, FLocation flocation) {
        this.clearOwnershipAt(flocation);
        if (id.equals("0")) {
            this.removeAt(flocation);
        }
        this.flocationIds.put(flocation, id);
    }

    @Override
    public void setFactionAt(Faction faction, FLocation flocation) {
        this.setIdAt(faction.getId(), flocation);
    }

    @Override
    public void removeAt(FLocation flocation) {
        Faction faction = this.getFactionAt(flocation);
        Iterator<LazyLocation> it = faction.getWarps().values().iterator();
        while (it.hasNext()) {
            if (!flocation.isInChunk(it.next().getLocation())) continue;
            it.remove();
        }
        this.clearOwnershipAt(flocation);
        this.flocationIds.remove(flocation);
    }

    @Override
    public Set<FLocation> getAllClaims(String factionId) {
        HashSet<FLocation> locs = new HashSet<FLocation>();
        for (Map.Entry<FLocation, String> entry : this.flocationIds.entrySet()) {
            if (!entry.getValue().equals(factionId)) continue;
            locs.add(entry.getKey());
        }
        return locs;
    }

    @Override
    public Set<FLocation> getAllClaims(Faction faction) {
        return this.getAllClaims(faction.getId());
    }

    @Override
    public void clearOwnershipAt(FLocation flocation) {
        Faction faction = this.getFactionAt(flocation);
        if (faction != null && faction.isNormal()) {
            faction.clearClaimOwnership(flocation);
        }
    }

    @Override
    public void unclaimAll(String factionId) {
        Faction faction = Factions.getInstance().getFactionById(factionId);
        if (faction != null && faction.isNormal()) {
            faction.clearAllClaimOwnership();
            faction.clearWarps();
        }
        this.clean(factionId);
    }

    public void clean(String factionId) {
        Iterator<Map.Entry<FLocation, String>> iter = this.flocationIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<FLocation, String> entry = iter.next();
            if (!entry.getValue().equals(factionId)) continue;
            iter.remove();
        }
    }

    @Override
    public boolean isBorderLocation(FLocation flocation) {
        Faction faction = this.getFactionAt(flocation);
        FLocation a = flocation.getRelative(1, 0);
        FLocation b = flocation.getRelative(-1, 0);
        FLocation c = flocation.getRelative(0, 1);
        FLocation d = flocation.getRelative(0, -1);
        return faction != this.getFactionAt(a) || faction != this.getFactionAt(b) || faction != this.getFactionAt(c) || faction != this.getFactionAt(d);
    }

    @Override
    public boolean isConnectedLocation(FLocation flocation, Faction faction) {
        FLocation a = flocation.getRelative(1, 0);
        FLocation b = flocation.getRelative(-1, 0);
        FLocation c = flocation.getRelative(0, 1);
        FLocation d = flocation.getRelative(0, -1);
        return faction == this.getFactionAt(a) || faction == this.getFactionAt(b) || faction == this.getFactionAt(c) || faction == this.getFactionAt(d);
    }

    @Override
    public boolean hasFactionWithin(FLocation flocation, Faction faction, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                FLocation relative;
                Faction other;
                if (x == 0 && z == 0 || !(other = this.getFactionAt(relative = flocation.getRelative(x, z))).isNormal() || other == faction) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clean() {
        Iterator<Map.Entry<FLocation, String>> iter = this.flocationIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<FLocation, String> entry = iter.next();
            if (Factions.getInstance().isValidFactionId(entry.getValue())) continue;
            P.p.log("Board cleaner removed " + entry.getValue() + " from " + entry.getKey());
            iter.remove();
        }
    }

    @Override
    public int getFactionCoordCount(String factionId) {
        int ret = 0;
        for (String thatFactionId : this.flocationIds.values()) {
            if (!thatFactionId.equals(factionId)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public int getFactionCoordCount(Faction faction) {
        return this.getFactionCoordCount(faction.getId());
    }

    @Override
    public int getFactionCoordCountInWorld(Faction faction, String worldName) {
        String factionId = faction.getId();
        int ret = 0;
        for (Map.Entry<FLocation, String> entry : this.flocationIds.entrySet()) {
            if (!entry.getValue().equals(factionId) || !entry.getKey().getWorldName().equals(worldName)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public ArrayList<String> getMap(Faction faction, FLocation flocation, double inDegrees) {
        ArrayList<String> ret = new ArrayList<String>();
        Faction factionLoc = this.getFactionAt(flocation);
        ret.add(P.p.txt.titleize("(" + flocation.getCoordString() + ") " + factionLoc.getTag(faction)));
        int halfWidth = Conf.mapWidth / 2;
        int halfHeight = Conf.mapHeight / 2;
        FLocation topLeft = flocation.getRelative(-halfWidth, -halfHeight);
        int width = halfWidth * 2 + 1;
        int height = halfHeight * 2 + 1;
        if (Conf.showMapFactionKey) {
            --height;
        }
        HashMap<String, Character> fList = new HashMap<String, Character>();
        int chrIdx = 0;
        for (int dz = 0; dz < height; ++dz) {
            String row = "";
            for (int dx = 0; dx < width; ++dx) {
                if (dx == halfWidth && dz == halfHeight) {
                    row = row + ChatColor.AQUA + "+";
                    continue;
                }
                FLocation flocationHere = topLeft.getRelative(dx, dz);
                Faction factionHere = this.getFactionAt(flocationHere);
                Relation relation = faction.getRelationTo(factionHere);
                if (factionHere.isNone()) {
                    row = row + ChatColor.GRAY + "-";
                    continue;
                }
                if (factionHere.isSafeZone()) {
                    row = row + Conf.colorPeaceful + "+";
                    continue;
                }
                if (factionHere.isWarZone()) {
                    row = row + ChatColor.DARK_RED + "+";
                    continue;
                }
                if (factionHere == faction || factionHere == factionLoc || relation.isAtLeast(Relation.ALLY) || Conf.showNeutralFactionsOnMap && relation.equals((Object)Relation.NEUTRAL) || Conf.showEnemyFactionsOnMap && relation.equals((Object)Relation.ENEMY)) {
                    if (!fList.containsKey(factionHere.getTag())) {
                        fList.put(factionHere.getTag(), Character.valueOf(Conf.mapKeyChrs[Math.min(chrIdx++, Conf.mapKeyChrs.length - 1)]));
                    }
                    char tag = ((Character)fList.get(factionHere.getTag())).charValue();
                    row = row + factionHere.getColorTo(faction) + "" + tag;
                    continue;
                }
                row = row + ChatColor.GRAY + "-";
            }
            ret.add(row);
        }
        ArrayList<String> asciiCompass = AsciiCompass.getAsciiCompass(inDegrees, ChatColor.RED, P.p.txt.parse("<a>"));
        ret.set(1, asciiCompass.get(0) + ((String)ret.get(1)).substring(9));
        ret.set(2, asciiCompass.get(1) + ((String)ret.get(2)).substring(9));
        ret.set(3, asciiCompass.get(2) + ((String)ret.get(3)).substring(9));
        if (Conf.showMapFactionKey) {
            String fRow = "";
            for (String key : fList.keySet()) {
                fRow = fRow + String.format("%s%s: %s ", ChatColor.GRAY, fList.get(key), key);
            }
            ret.add(fRow);
        }
        return ret;
    }

    public abstract void convertFrom(MemoryBoard var1);
}

