/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.event.FPlayerLeaveEvent;
import com.massivecraft.factions.event.LandClaimEvent;
import com.massivecraft.factions.iface.EconomyParticipator;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.integration.Essentials;
import com.massivecraft.factions.integration.Worldguard;
import com.massivecraft.factions.scoreboards.FScoreboard;
import com.massivecraft.factions.scoreboards.sidebar.FInfoSidebar;
import com.massivecraft.factions.struct.ChatMode;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.RelationUtil;
import com.massivecraft.factions.util.WarmUpUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class MemoryFPlayer
implements FPlayer {
    protected String factionId;
    protected Role role;
    protected String title;
    protected double power;
    protected double powerBoost;
    protected long lastPowerUpdateTime;
    protected long lastLoginTime;
    protected ChatMode chatMode;
    protected boolean ignoreAllianceChat = false;
    protected String id;
    protected String name;
    protected boolean monitorJoins;
    protected transient FLocation lastStoodAt = new FLocation();
    protected transient boolean mapAutoUpdating;
    protected transient Faction autoClaimFor;
    protected transient boolean autoSafeZoneEnabled;
    protected transient boolean autoWarZoneEnabled;
    protected transient boolean isAdminBypassing = false;
    protected transient boolean loginPvpDisabled;
    protected boolean spyingChat = false;
    protected boolean showScoreboard = true;
    protected WarmUpUtil.Warmup warmup;
    protected int warmupTask;

    @Override
    public Faction getFaction() {
        if (this.factionId == null) {
            this.factionId = "0";
        }
        return Factions.getInstance().getFactionById(this.factionId);
    }

    @Override
    public String getFactionId() {
        return this.factionId;
    }

    @Override
    public boolean hasFaction() {
        return !this.factionId.equals("0");
    }

    @Override
    public void setFaction(Faction faction) {
        Faction oldFaction = this.getFaction();
        if (oldFaction != null) {
            oldFaction.removeFPlayer(this);
        }
        faction.addFPlayer(this);
        this.factionId = faction.getId();
    }

    @Override
    public void setMonitorJoins(boolean monitor) {
        this.monitorJoins = monitor;
    }

    @Override
    public boolean isMonitoringJoins() {
        return this.monitorJoins;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public double getPowerBoost() {
        return this.powerBoost;
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.powerBoost = powerBoost;
    }

    @Override
    public Faction getAutoClaimFor() {
        return this.autoClaimFor;
    }

    @Override
    public void setAutoClaimFor(Faction faction) {
        this.autoClaimFor = faction;
        if (this.autoClaimFor != null) {
            this.autoSafeZoneEnabled = false;
            this.autoWarZoneEnabled = false;
        }
    }

    @Override
    public boolean isAutoSafeClaimEnabled() {
        return this.autoSafeZoneEnabled;
    }

    @Override
    public void setIsAutoSafeClaimEnabled(boolean enabled) {
        this.autoSafeZoneEnabled = enabled;
        if (enabled) {
            this.autoClaimFor = null;
            this.autoWarZoneEnabled = false;
        }
    }

    @Override
    public boolean isAutoWarClaimEnabled() {
        return this.autoWarZoneEnabled;
    }

    @Override
    public void setIsAutoWarClaimEnabled(boolean enabled) {
        this.autoWarZoneEnabled = enabled;
        if (enabled) {
            this.autoClaimFor = null;
            this.autoSafeZoneEnabled = false;
        }
    }

    @Override
    public boolean isAdminBypassing() {
        return this.isAdminBypassing;
    }

    @Override
    public boolean isVanished() {
        return Essentials.isVanished(this.getPlayer());
    }

    @Override
    public void setIsAdminBypassing(boolean val) {
        this.isAdminBypassing = val;
    }

    @Override
    public void setChatMode(ChatMode chatMode) {
        this.chatMode = chatMode;
    }

    @Override
    public ChatMode getChatMode() {
        if (this.factionId.equals("0") || !Conf.factionOnlyChat) {
            this.chatMode = ChatMode.PUBLIC;
        }
        return this.chatMode;
    }

    @Override
    public void setIgnoreAllianceChat(boolean ignore) {
        this.ignoreAllianceChat = ignore;
    }

    @Override
    public boolean isIgnoreAllianceChat() {
        return this.ignoreAllianceChat;
    }

    @Override
    public void setSpyingChat(boolean chatSpying) {
        this.spyingChat = chatSpying;
    }

    @Override
    public boolean isSpyingChat() {
        return this.spyingChat;
    }

    @Override
    public String getAccountId() {
        return this.getId();
    }

    public MemoryFPlayer() {
    }

    public MemoryFPlayer(String id) {
        this.id = id;
        this.resetFactionData(false);
        this.power = Conf.powerPlayerStarting;
        this.lastPowerUpdateTime = System.currentTimeMillis();
        this.lastLoginTime = System.currentTimeMillis();
        this.mapAutoUpdating = false;
        this.autoClaimFor = null;
        this.autoSafeZoneEnabled = false;
        this.autoWarZoneEnabled = false;
        this.loginPvpDisabled = Conf.noPVPDamageToOthersForXSecondsAfterLogin > 0;
        this.powerBoost = 0.0;
        this.showScoreboard = P.p.getConfig().getBoolean("scoreboard.default-enabled", false);
        if (!Conf.newPlayerStartingFactionID.equals("0") && Factions.getInstance().isValidFactionId(Conf.newPlayerStartingFactionID)) {
            this.factionId = Conf.newPlayerStartingFactionID;
        }
    }

    public MemoryFPlayer(MemoryFPlayer other) {
        this.factionId = other.factionId;
        this.id = other.id;
        this.power = other.power;
        this.lastLoginTime = other.lastLoginTime;
        this.mapAutoUpdating = other.mapAutoUpdating;
        this.autoClaimFor = other.autoClaimFor;
        this.autoSafeZoneEnabled = other.autoSafeZoneEnabled;
        this.autoWarZoneEnabled = other.autoWarZoneEnabled;
        this.loginPvpDisabled = other.loginPvpDisabled;
        this.powerBoost = other.powerBoost;
        this.role = other.role;
        this.title = other.title;
        this.chatMode = other.chatMode;
        this.spyingChat = other.spyingChat;
        this.lastStoodAt = other.lastStoodAt;
        this.isAdminBypassing = other.isAdminBypassing;
        this.showScoreboard = P.p.getConfig().getBoolean("scoreboard.default-enabled", true);
    }

    @Override
    public void resetFactionData(boolean doSpoutUpdate) {
        if (this.factionId != null && Factions.getInstance().isValidFactionId(this.getFactionId())) {
            Faction currentFaction = this.getFaction();
            currentFaction.removeFPlayer(this);
            if (currentFaction.isNormal()) {
                currentFaction.clearClaimOwnership(this);
            }
        }
        this.factionId = "0";
        this.chatMode = ChatMode.PUBLIC;
        this.role = Role.NORMAL;
        this.title = "";
        this.autoClaimFor = null;
    }

    @Override
    public void resetFactionData() {
        this.resetFactionData(true);
    }

    @Override
    public long getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Override
    public void setLastLoginTime(long lastLoginTime) {
        this.losePowerFromBeingOffline();
        this.lastLoginTime = lastLoginTime;
        this.lastPowerUpdateTime = lastLoginTime;
        if (Conf.noPVPDamageToOthersForXSecondsAfterLogin > 0) {
            this.loginPvpDisabled = true;
        }
    }

    @Override
    public boolean isMapAutoUpdating() {
        return this.mapAutoUpdating;
    }

    @Override
    public void setMapAutoUpdating(boolean mapAutoUpdating) {
        this.mapAutoUpdating = mapAutoUpdating;
    }

    @Override
    public boolean hasLoginPvpDisabled() {
        if (!this.loginPvpDisabled) {
            return false;
        }
        if (this.lastLoginTime + (long)(Conf.noPVPDamageToOthersForXSecondsAfterLogin * 1000) < System.currentTimeMillis()) {
            this.loginPvpDisabled = false;
            return false;
        }
        return true;
    }

    @Override
    public FLocation getLastStoodAt() {
        return this.lastStoodAt;
    }

    @Override
    public void setLastStoodAt(FLocation flocation) {
        this.lastStoodAt = flocation;
    }

    @Override
    public String getTitle() {
        return this.hasFaction() ? this.title : "";
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getId()));
            this.name = offline.getName() != null ? offline.getName() : this.getId();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTag() {
        return this.hasFaction() ? this.getFaction().getTag() : "";
    }

    @Override
    public String getNameAndSomething(String something) {
        String ret = this.role.getPrefix();
        if (something.length() > 0) {
            ret = ret + something + " ";
        }
        ret = ret + this.getName();
        return ret;
    }

    @Override
    public String getNameAndTitle() {
        return this.getNameAndSomething(this.getTitle());
    }

    @Override
    public String getNameAndTag() {
        return this.getNameAndSomething(this.getTag());
    }

    @Override
    public String getNameAndTitle(Faction faction) {
        return this.getColorTo(faction) + this.getNameAndTitle();
    }

    public String getNameAndTitle(MemoryFPlayer fplayer) {
        return this.getColorTo(fplayer) + this.getNameAndTitle();
    }

    @Override
    public String getChatTag() {
        return this.hasFaction() ? String.format(Conf.chatTagFormat, this.role.getPrefix() + this.getTag()) : "";
    }

    @Override
    public String getChatTag(Faction faction) {
        return this.hasFaction() ? this.getRelationTo(faction).getColor() + this.getChatTag() : "";
    }

    public String getChatTag(MemoryFPlayer fplayer) {
        return this.hasFaction() ? this.getColorTo(fplayer) + this.getChatTag() : "";
    }

    @Override
    public String describeTo(RelationParticipator that, boolean ucfirst) {
        return RelationUtil.describeThatToMe(this, that, ucfirst);
    }

    @Override
    public String describeTo(RelationParticipator that) {
        return RelationUtil.describeThatToMe(this, that);
    }

    @Override
    public Relation getRelationTo(RelationParticipator rp) {
        return RelationUtil.getRelationTo(this, rp);
    }

    @Override
    public Relation getRelationTo(RelationParticipator rp, boolean ignorePeaceful) {
        return RelationUtil.getRelationTo(this, rp, ignorePeaceful);
    }

    @Override
    public Relation getRelationToLocation() {
        return Board.getInstance().getFactionAt(new FLocation(this)).getRelationTo(this);
    }

    @Override
    public ChatColor getColorTo(RelationParticipator rp) {
        return RelationUtil.getColorOfThatToMe(this, rp);
    }

    @Override
    public void heal(int amnt) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.setHealth(player.getHealth() + (double)amnt);
    }

    @Override
    public double getPower() {
        this.updatePower();
        return this.power;
    }

    @Override
    public void alterPower(double delta) {
        this.power += delta;
        if (this.power > this.getPowerMax()) {
            this.power = this.getPowerMax();
        } else if (this.power < this.getPowerMin()) {
            this.power = this.getPowerMin();
        }
    }

    @Override
    public double getPowerMax() {
        return Conf.powerPlayerMax + this.powerBoost;
    }

    @Override
    public double getPowerMin() {
        return Conf.powerPlayerMin + this.powerBoost;
    }

    @Override
    public int getPowerRounded() {
        return (int)Math.round(this.getPower());
    }

    @Override
    public int getPowerMaxRounded() {
        return (int)Math.round(this.getPowerMax());
    }

    @Override
    public int getPowerMinRounded() {
        return (int)Math.round(this.getPowerMin());
    }

    @Override
    public void updatePower() {
        if (this.isOffline()) {
            this.losePowerFromBeingOffline();
            if (!Conf.powerRegenOffline) {
                return;
            }
        } else if (this.hasFaction() && this.getFaction().isPowerFrozen()) {
            return;
        }
        long now = System.currentTimeMillis();
        long millisPassed = now - this.lastPowerUpdateTime;
        this.lastPowerUpdateTime = now;
        Player thisPlayer = this.getPlayer();
        if (thisPlayer != null && thisPlayer.isDead()) {
            return;
        }
        int millisPerMinute = 60000;
        this.alterPower((double)millisPassed * Conf.powerPerMinute / (double)millisPerMinute);
    }

    @Override
    public void losePowerFromBeingOffline() {
        if (Conf.powerOfflineLossPerDay > 0.0 && this.power > Conf.powerOfflineLossLimit) {
            long now = System.currentTimeMillis();
            long millisPassed = now - this.lastPowerUpdateTime;
            this.lastPowerUpdateTime = now;
            double loss = (double)millisPassed * Conf.powerOfflineLossPerDay / 8.64E7;
            if (this.power - loss < Conf.powerOfflineLossLimit) {
                loss = this.power;
            }
            this.alterPower(-loss);
        }
    }

    @Override
    public void onDeath() {
        this.updatePower();
        this.alterPower(-Conf.powerPerDeath);
        if (this.hasFaction()) {
            this.getFaction().setLastDeath(System.currentTimeMillis());
        }
    }

    @Override
    public boolean isInOwnTerritory() {
        return Board.getInstance().getFactionAt(new FLocation(this)) == this.getFaction();
    }

    @Override
    public boolean isInOthersTerritory() {
        Faction factionHere = Board.getInstance().getFactionAt(new FLocation(this));
        return factionHere != null && factionHere.isNormal() && factionHere != this.getFaction();
    }

    @Override
    public boolean isInAllyTerritory() {
        return Board.getInstance().getFactionAt(new FLocation(this)).getRelationTo(this).isAlly();
    }

    @Override
    public boolean isInNeutralTerritory() {
        return Board.getInstance().getFactionAt(new FLocation(this)).getRelationTo(this).isNeutral();
    }

    @Override
    public boolean isInEnemyTerritory() {
        return Board.getInstance().getFactionAt(new FLocation(this)).getRelationTo(this).isEnemy();
    }

    @Override
    public void sendFactionHereMessage(Faction from) {
        Faction toShow = Board.getInstance().getFactionAt(this.getLastStoodAt());
        boolean showChat = true;
        if (this.showInfoBoard(toShow)) {
            FScoreboard.get(this).setTemporarySidebar(new FInfoSidebar(toShow));
            showChat = P.p.getConfig().getBoolean("scoreboard.also-send-chat", true);
        }
        if (showChat) {
            this.sendMessage(P.p.txt.parse(TL.FACTION_LEAVE.format(from.getTag(this), toShow.getTag(this))));
        }
    }

    public boolean showInfoBoard(Faction toShow) {
        return this.showScoreboard && !toShow.isWarZone() && !toShow.isNone() && !toShow.isSafeZone() && P.p.getConfig().contains("scoreboard.finfo") && P.p.getConfig().getBoolean("scoreboard.finfo-enabled", false) && FScoreboard.get(this) != null;
    }

    @Override
    public boolean showScoreboard() {
        return this.showScoreboard;
    }

    @Override
    public void setShowScoreboard(boolean show) {
        this.showScoreboard = show;
    }

    @Override
    public void leave(boolean makePay) {
        Faction myFaction = this.getFaction();
        boolean bl = makePay = makePay && Econ.shouldBeUsed() && !this.isAdminBypassing();
        if (myFaction == null) {
            this.resetFactionData();
            return;
        }
        boolean perm = myFaction.isPermanent();
        if (!perm && this.getRole() == Role.ADMIN && myFaction.getFPlayers().size() > 1) {
            this.msg(TL.LEAVE_PASSADMIN, new Object[0]);
            return;
        }
        if (!Conf.canLeaveWithNegativePower && this.getPower() < 0.0) {
            this.msg(TL.LEAVE_NEGATIVEPOWER, new Object[0]);
            return;
        }
        if (makePay && !Econ.hasAtLeast(this, Conf.econCostLeave, TL.LEAVE_TOLEAVE.toString())) {
            return;
        }
        FPlayerLeaveEvent leaveEvent = new FPlayerLeaveEvent(this, myFaction, FPlayerLeaveEvent.PlayerLeaveReason.LEAVE);
        Bukkit.getServer().getPluginManager().callEvent((Event)leaveEvent);
        if (leaveEvent.isCancelled()) {
            return;
        }
        if (makePay && !Econ.modifyMoney(this, -Conf.econCostLeave, TL.LEAVE_TOLEAVE.toString(), TL.LEAVE_FORLEAVE.toString())) {
            return;
        }
        if (myFaction.getFPlayers().size() == 1 && Econ.shouldBeUsed()) {
            Econ.transferMoney(this, myFaction, this, Econ.getBalance(myFaction.getAccountId()));
        }
        if (myFaction.isNormal()) {
            for (FPlayer fplayer : myFaction.getFPlayersWhereOnline(true)) {
                fplayer.msg(TL.LEAVE_LEFT, this.describeTo(fplayer, true), myFaction.describeTo(fplayer));
            }
            if (Conf.logFactionLeave) {
                P.p.log(TL.LEAVE_LEFT.format(this.getName(), myFaction.getTag()));
            }
        }
        myFaction.removeAnnouncements(this);
        this.resetFactionData();
        if (myFaction.isNormal() && !perm && myFaction.getFPlayers().isEmpty()) {
            for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
                fplayer.msg(TL.LEAVE_DISBANDED, myFaction.describeTo(fplayer, true));
            }
            Factions.getInstance().removeFaction(myFaction.getId());
            if (Conf.logFactionDisband) {
                P.p.log(TL.LEAVE_DISBANDEDLOG.format(myFaction.getTag(), myFaction.getId(), this.getName()));
            }
        }
    }

    @Override
    public boolean canClaimForFaction(Faction forFaction) {
        return !forFaction.isNone() && (this.isAdminBypassing() || forFaction == this.getFaction() && this.getRole().isAtLeast(Role.MODERATOR) || forFaction.isSafeZone() && Permission.MANAGE_SAFE_ZONE.has((CommandSender)this.getPlayer()) || forFaction.isWarZone() && Permission.MANAGE_WAR_ZONE.has((CommandSender)this.getPlayer()));
    }

    @Override
    public boolean canClaimForFactionAtLocation(Faction forFaction, Location location, boolean notifyFailure) {
        String error = null;
        FLocation flocation = new FLocation(location);
        Faction myFaction = this.getFaction();
        Faction currentFaction = Board.getInstance().getFactionAt(flocation);
        int ownedLand = forFaction.getLandRounded();
        int factionBuffer = P.p.getConfig().getInt("hcf.buffer-zone", 0);
        int worldBuffer = P.p.getConfig().getInt("world-border.buffer", 0);
        if (Conf.worldGuardChecking && Worldguard.checkForRegionsInChunk(location)) {
            error = P.p.txt.parse(TL.CLAIM_PROTECTED.toString());
        } else if (Conf.worldsNoClaiming.contains(flocation.getWorldName())) {
            error = P.p.txt.parse(TL.CLAIM_DISABLED.toString());
        } else {
            if (this.isAdminBypassing()) {
                return true;
            }
            if (forFaction.isSafeZone() && Permission.MANAGE_SAFE_ZONE.has((CommandSender)this.getPlayer())) {
                return true;
            }
            if (forFaction.isWarZone() && Permission.MANAGE_WAR_ZONE.has((CommandSender)this.getPlayer())) {
                return true;
            }
            if (myFaction != forFaction) {
                error = P.p.txt.parse(TL.CLAIM_CANTCLAIM.toString(), forFaction.describeTo(this));
            } else if (forFaction == currentFaction) {
                error = P.p.txt.parse(TL.CLAIM_ALREADYOWN.toString(), forFaction.describeTo(this, true));
            } else if (this.getRole().value < Role.MODERATOR.value) {
                error = P.p.txt.parse(TL.CLAIM_MUSTBE.toString(), new Object[]{Role.MODERATOR.getTranslation()});
            } else if (forFaction.getFPlayers().size() < Conf.claimsRequireMinFactionMembers) {
                error = P.p.txt.parse(TL.CLAIM_MEMBERS.toString(), Conf.claimsRequireMinFactionMembers);
            } else if (currentFaction.isSafeZone()) {
                error = P.p.txt.parse(TL.CLAIM_SAFEZONE.toString());
            } else if (currentFaction.isWarZone()) {
                error = P.p.txt.parse(TL.CLAIM_WARZONE.toString());
            } else if (P.p.getConfig().getBoolean("hcf.overclaim", true) && ownedLand >= forFaction.getPowerRounded()) {
                error = P.p.txt.parse(TL.CLAIM_POWER.toString());
            } else if (Conf.claimedLandsMax != 0 && ownedLand >= Conf.claimedLandsMax && forFaction.isNormal()) {
                error = P.p.txt.parse(TL.CLAIM_LIMIT.toString());
            } else if (currentFaction.getRelationTo(forFaction) == Relation.ALLY) {
                error = P.p.txt.parse(TL.CLAIM_ALLY.toString());
            } else if (!(!Conf.claimsMustBeConnected || this.isAdminBypassing() || myFaction.getLandRoundedInWorld(flocation.getWorldName()) <= 0 || Board.getInstance().isConnectedLocation(flocation, myFaction) || Conf.claimsCanBeUnconnectedIfOwnedByOtherFaction && currentFaction.isNormal())) {
                error = Conf.claimsCanBeUnconnectedIfOwnedByOtherFaction ? P.p.txt.parse(TL.CLAIM_CONTIGIOUS.toString()) : P.p.txt.parse(TL.CLAIM_FACTIONCONTIGUOUS.toString());
            } else if (factionBuffer > 0 && Board.getInstance().hasFactionWithin(flocation, myFaction, factionBuffer)) {
                error = P.p.txt.parse(TL.CLAIM_TOOCLOSETOOTHERFACTION.format(factionBuffer));
            } else if (flocation.isOutsideWorldBorder(worldBuffer)) {
                error = worldBuffer > 0 ? P.p.txt.parse(TL.CLAIM_OUTSIDEBORDERBUFFER.format(worldBuffer)) : P.p.txt.parse(TL.CLAIM_OUTSIDEWORLDBORDER.toString());
            } else if (currentFaction.isNormal()) {
                if (myFaction.isPeaceful()) {
                    error = P.p.txt.parse(TL.CLAIM_PEACEFUL.toString(), currentFaction.getTag(this));
                } else if (currentFaction.isPeaceful()) {
                    error = P.p.txt.parse(TL.CLAIM_PEACEFULTARGET.toString(), currentFaction.getTag(this));
                } else if (!currentFaction.hasLandInflation()) {
                    error = P.p.txt.parse(TL.CLAIM_THISISSPARTA.toString(), currentFaction.getTag(this));
                } else if (currentFaction.hasLandInflation() && !P.p.getConfig().getBoolean("hcf.allow-overclaim", true)) {
                    error = P.p.txt.parse(TL.CLAIM_OVERCLAIM_DISABLED.toString());
                } else if (!Board.getInstance().isBorderLocation(flocation)) {
                    error = P.p.txt.parse(TL.CLAIM_BORDER.toString());
                }
            }
        }
        if (notifyFailure && error != null) {
            this.msg(error, new Object[0]);
        }
        return error == null;
    }

    @Override
    public boolean attemptClaim(Faction forFaction, Location location, boolean notifyFailure) {
        FLocation flocation = new FLocation(location);
        Faction currentFaction = Board.getInstance().getFactionAt(flocation);
        int ownedLand = forFaction.getLandRounded();
        if (!this.canClaimForFactionAtLocation(forFaction, location, notifyFailure)) {
            return false;
        }
        boolean mustPay = Econ.shouldBeUsed() && !this.isAdminBypassing() && !forFaction.isSafeZone() && !forFaction.isWarZone();
        double cost = 0.0;
        EconomyParticipator payee = null;
        if (mustPay) {
            cost = Econ.calculateClaimCost(ownedLand, currentFaction.isNormal());
            if (Conf.econClaimUnconnectedFee != 0.0 && forFaction.getLandRoundedInWorld(flocation.getWorldName()) > 0 && !Board.getInstance().isConnectedLocation(flocation, forFaction)) {
                cost += Conf.econClaimUnconnectedFee;
            }
            if (!Econ.hasAtLeast(payee = Conf.bankEnabled && Conf.bankFactionPaysLandCosts && this.hasFaction() ? this.getFaction() : this, cost, TL.CLAIM_TOCLAIM.toString())) {
                return false;
            }
        }
        LandClaimEvent claimEvent = new LandClaimEvent(flocation, forFaction, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)claimEvent);
        if (claimEvent.isCancelled()) {
            return false;
        }
        if (mustPay && !Econ.modifyMoney(payee, -cost, TL.CLAIM_TOCLAIM.toString(), TL.CLAIM_FORCLAIM.toString())) {
            return false;
        }
        HashSet<FPlayer> informTheseFPlayers = new HashSet<FPlayer>();
        informTheseFPlayers.add(this);
        informTheseFPlayers.addAll(forFaction.getFPlayersWhereOnline(true));
        for (FPlayer fp : informTheseFPlayers) {
            fp.msg(TL.CLAIM_CLAIMED, this.describeTo(fp, true), forFaction.describeTo(fp), currentFaction.describeTo(fp));
        }
        Board.getInstance().setFactionAt(forFaction, flocation);
        if (Conf.logLandClaims) {
            P.p.log(TL.CLAIM_CLAIMEDLOG.toString(), this.getName(), flocation.getCoordString(), forFaction.getTag());
        }
        return true;
    }

    public boolean shouldBeSaved() {
        return this.hasFaction() || this.getPowerRounded() != this.getPowerMaxRounded() && this.getPowerRounded() != (int)Math.round(Conf.powerPlayerStarting);
    }

    @Override
    public void msg(String str, Object ... args) {
        this.sendMessage(P.p.txt.parse(str, args));
    }

    @Override
    public void msg(TL translation, Object ... args) {
        this.msg(translation.toString(), args);
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)UUID.fromString(this.getId()));
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean isOnlineAndVisibleTo(Player player) {
        Player target = this.getPlayer();
        return target != null && player.canSee(target);
    }

    @Override
    public boolean isOffline() {
        return !this.isOnline();
    }

    @Override
    public void sendMessage(String msg) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.sendMessage(msg);
    }

    @Override
    public void sendMessage(List<String> msgs) {
        for (String msg : msgs) {
            this.sendMessage(msg);
        }
    }

    @Override
    public String getNameAndTitle(FPlayer fplayer) {
        return this.getColorTo(fplayer) + this.getNameAndTitle();
    }

    @Override
    public String getChatTag(FPlayer fplayer) {
        return this.hasFaction() ? this.getRelationTo(fplayer).getColor() + this.getChatTag() : "";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public abstract void remove();

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void clearWarmup() {
        if (this.warmup != null) {
            Bukkit.getScheduler().cancelTask(this.warmupTask);
            this.stopWarmup();
        }
    }

    @Override
    public void stopWarmup() {
        this.warmup = null;
    }

    @Override
    public boolean isWarmingUp() {
        return this.warmup != null;
    }

    @Override
    public WarmUpUtil.Warmup getWarmupType() {
        return this.warmup;
    }

    @Override
    public void addWarmup(WarmUpUtil.Warmup warmup, int taskId) {
        if (this.warmup != null) {
            this.clearWarmup();
        }
        this.warmup = warmup;
        this.warmupTask = taskId;
    }
}

