/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class MemoryFPlayers
extends FPlayers {
    public Map<String, FPlayer> fPlayers = new ConcurrentSkipListMap<String, FPlayer>(String.CASE_INSENSITIVE_ORDER);

    @Override
    public void clean() {
        for (FPlayer fplayer : this.fPlayers.values()) {
            if (Factions.getInstance().isValidFactionId(fplayer.getFactionId())) continue;
            P.p.log("Reset faction data (invalid faction:" + fplayer.getFactionId() + ") for player " + fplayer.getName());
            fplayer.resetFactionData(false);
        }
    }

    @Override
    public Collection<FPlayer> getOnlinePlayers() {
        HashSet<FPlayer> entities = new HashSet<FPlayer>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            entities.add(this.getByPlayer(player));
        }
        return entities;
    }

    @Override
    public FPlayer getByPlayer(Player player) {
        return this.getById(player.getUniqueId().toString());
    }

    public List<FPlayer> getAllFPlayers() {
        return new ArrayList<FPlayer>(this.fPlayers.values());
    }

    @Override
    public abstract void forceSave();

    @Override
    public abstract void load();

    @Override
    public FPlayer getByOfflinePlayer(OfflinePlayer player) {
        return this.getById(player.getUniqueId().toString());
    }

    @Override
    public FPlayer getById(String id) {
        FPlayer player = this.fPlayers.get(id);
        if (player == null) {
            player = this.generateFPlayer(id);
        }
        return player;
    }

    public abstract FPlayer generateFPlayer(String var1);

    public abstract void convertFrom(MemoryFPlayers var1);
}

