/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.iface.EconomyParticipator;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.struct.Permission;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.util.LazyLocation;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.util.RelationUtil;
import com.massivecraft.factions.zcore.persist.MemoryBoard;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class MemoryFaction
implements Faction,
EconomyParticipator {
    protected String id = null;
    protected boolean peacefulExplosionsEnabled;
    protected boolean permanent;
    protected String tag;
    protected String description;
    protected boolean open;
    protected boolean peaceful;
    protected Integer permanentPower;
    protected LazyLocation home;
    protected long foundedDate;
    protected transient long lastPlayerLoggedOffTime;
    protected double money;
    protected double powerBoost;
    protected Map<String, Relation> relationWish = new HashMap<String, Relation>();
    protected Map<FLocation, Set<String>> claimOwnership = new ConcurrentHashMap<FLocation, Set<String>>();
    protected transient Set<FPlayer> fplayers = new HashSet<FPlayer>();
    protected Set<String> invites = new HashSet<String>();
    protected HashMap<String, List<String>> announcements = new HashMap();
    protected ConcurrentHashMap<String, LazyLocation> warps = new ConcurrentHashMap();
    private long lastDeath;

    @Override
    public HashMap<String, List<String>> getAnnouncements() {
        return this.announcements;
    }

    @Override
    public void addAnnouncement(FPlayer fPlayer, String msg) {
        ArrayList<String> list = this.announcements.containsKey(fPlayer.getId()) ? this.announcements.get(fPlayer.getId()) : new ArrayList<String>();
        list.add(msg);
        this.announcements.put(fPlayer.getId(), list);
    }

    @Override
    public void sendUnreadAnnouncements(FPlayer fPlayer) {
        if (!this.announcements.containsKey(fPlayer.getId())) {
            return;
        }
        fPlayer.sendMessage(ChatColor.LIGHT_PURPLE + "--Unread Faction Announcements--");
        for (String s : this.announcements.get(fPlayer.getPlayer().getUniqueId().toString())) {
            fPlayer.sendMessage(s);
        }
        fPlayer.sendMessage(ChatColor.LIGHT_PURPLE + "--Unread Faction Announcements--");
        this.announcements.remove(fPlayer.getId());
    }

    @Override
    public void removeAnnouncements(FPlayer fPlayer) {
        if (this.announcements.containsKey(fPlayer.getId())) {
            this.announcements.remove(fPlayer.getId());
        }
    }

    @Override
    public ConcurrentHashMap<String, LazyLocation> getWarps() {
        return this.warps;
    }

    @Override
    public LazyLocation getWarp(String name) {
        return this.warps.get(name);
    }

    @Override
    public void setWarp(String name, LazyLocation loc) {
        this.warps.put(name, loc);
    }

    @Override
    public boolean isWarp(String name) {
        return this.warps.containsKey(name);
    }

    @Override
    public boolean removeWarp(String name) {
        return this.warps.remove(name) != null;
    }

    @Override
    public void clearWarps() {
        this.warps.clear();
    }

    @Override
    public Set<String> getInvites() {
        return this.invites;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void invite(FPlayer fplayer) {
        this.invites.add(fplayer.getId());
    }

    @Override
    public void deinvite(FPlayer fplayer) {
        this.invites.remove(fplayer.getId());
    }

    @Override
    public boolean isInvited(FPlayer fplayer) {
        return this.invites.contains(fplayer.getId());
    }

    @Override
    public boolean getOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean isOpen) {
        this.open = isOpen;
    }

    @Override
    public boolean isPeaceful() {
        return this.peaceful;
    }

    @Override
    public void setPeaceful(boolean isPeaceful) {
        this.peaceful = isPeaceful;
    }

    @Override
    public void setPeacefulExplosionsEnabled(boolean val) {
        this.peacefulExplosionsEnabled = val;
    }

    @Override
    public boolean getPeacefulExplosionsEnabled() {
        return this.peacefulExplosionsEnabled;
    }

    @Override
    public boolean noExplosionsInTerritory() {
        return this.peaceful && !this.peacefulExplosionsEnabled;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent || !this.isNormal();
    }

    @Override
    public void setPermanent(boolean isPermanent) {
        this.permanent = isPermanent;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getTag(String prefix) {
        return prefix + this.tag;
    }

    @Override
    public String getTag(Faction otherFaction) {
        if (otherFaction == null) {
            return this.getTag();
        }
        return this.getTag(this.getColorTo(otherFaction).toString());
    }

    @Override
    public String getTag(FPlayer otherFplayer) {
        if (otherFplayer == null) {
            return this.getTag();
        }
        return this.getTag(this.getColorTo(otherFplayer).toString());
    }

    @Override
    public void setTag(String str) {
        if (Conf.factionTagForceUpperCase) {
            str = str.toUpperCase();
        }
        this.tag = str;
    }

    @Override
    public String getComparisonTag() {
        return MiscUtil.getComparisonString(this.tag);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public void setHome(Location home) {
        this.home = new LazyLocation(home);
    }

    @Override
    public boolean hasHome() {
        return this.getHome() != null;
    }

    @Override
    public Location getHome() {
        this.confirmValidHome();
        return this.home != null ? this.home.getLocation() : null;
    }

    @Override
    public long getFoundedDate() {
        if (this.foundedDate == 0L) {
            this.setFoundedDate(System.currentTimeMillis());
        }
        return this.foundedDate;
    }

    @Override
    public void setFoundedDate(long newDate) {
        this.foundedDate = newDate;
    }

    @Override
    public void confirmValidHome() {
        if (!Conf.homesMustBeInClaimedTerritory || this.home == null || this.home.getLocation() != null && Board.getInstance().getFactionAt(new FLocation(this.home.getLocation())) == this) {
            return;
        }
        this.msg("<b>Your faction home has been un-set since it is no longer in your territory.", new Object[0]);
        this.home = null;
    }

    @Override
    public String getAccountId() {
        String aid = "faction-" + this.getId();
        if (!Econ.hasAccount(aid)) {
            Econ.setBalance(aid, 0.0);
        }
        return aid;
    }

    @Override
    public Integer getPermanentPower() {
        return this.permanentPower;
    }

    @Override
    public void setPermanentPower(Integer permanentPower) {
        this.permanentPower = permanentPower;
    }

    @Override
    public boolean hasPermanentPower() {
        return this.permanentPower != null;
    }

    @Override
    public double getPowerBoost() {
        return this.powerBoost;
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.powerBoost = powerBoost;
    }

    @Override
    public boolean isPowerFrozen() {
        int freezeSeconds = P.p.getConfig().getInt("hcf.powerfreeze", 0);
        if (freezeSeconds == 0) {
            return false;
        }
        return System.currentTimeMillis() - this.lastDeath < (long)(freezeSeconds * 1000);
    }

    @Override
    public void setLastDeath(long time) {
        this.lastDeath = time;
    }

    public long getLastDeath() {
        return this.lastDeath;
    }

    public MemoryFaction() {
    }

    public MemoryFaction(String id) {
        this.id = id;
        this.open = Conf.newFactionsDefaultOpen;
        this.tag = "???";
        this.description = TL.GENERIC_DEFAULTDESCRIPTION.toString();
        this.lastPlayerLoggedOffTime = 0L;
        this.peaceful = false;
        this.peacefulExplosionsEnabled = false;
        this.permanent = false;
        this.money = 0.0;
        this.powerBoost = 0.0;
        this.foundedDate = System.currentTimeMillis();
    }

    public MemoryFaction(MemoryFaction old) {
        this.id = old.id;
        this.peacefulExplosionsEnabled = old.peacefulExplosionsEnabled;
        this.permanent = old.permanent;
        this.tag = old.tag;
        this.description = old.description;
        this.open = old.open;
        this.foundedDate = old.foundedDate;
        this.peaceful = old.peaceful;
        this.permanentPower = old.permanentPower;
        this.home = old.home;
        this.lastPlayerLoggedOffTime = old.lastPlayerLoggedOffTime;
        this.money = old.money;
        this.powerBoost = old.powerBoost;
        this.relationWish = old.relationWish;
        this.claimOwnership = old.claimOwnership;
        this.fplayers = new HashSet<FPlayer>();
        this.invites = old.invites;
        this.announcements = old.announcements;
    }

    @Override
    public boolean noPvPInTerritory() {
        return this.isSafeZone() || this.peaceful && Conf.peacefulTerritoryDisablePVP;
    }

    @Override
    public boolean noMonstersInTerritory() {
        return this.isSafeZone() || this.peaceful && Conf.peacefulTerritoryDisableMonsters;
    }

    @Override
    public boolean isNormal() {
        return !this.isNone() && !this.isSafeZone() && !this.isWarZone();
    }

    @Override
    public boolean isNone() {
        return this.getId().equals("0");
    }

    @Override
    public boolean isSafeZone() {
        return this.getId().equals("-1");
    }

    @Override
    public boolean isWarZone() {
        return this.getId().equals("-2");
    }

    @Override
    public boolean isPlayerFreeType() {
        return this.isSafeZone() || this.isWarZone();
    }

    @Override
    public String describeTo(RelationParticipator that, boolean ucfirst) {
        return RelationUtil.describeThatToMe(this, that, ucfirst);
    }

    @Override
    public String describeTo(RelationParticipator that) {
        return RelationUtil.describeThatToMe(this, that);
    }

    @Override
    public Relation getRelationTo(RelationParticipator rp) {
        return RelationUtil.getRelationTo(this, rp);
    }

    @Override
    public Relation getRelationTo(RelationParticipator rp, boolean ignorePeaceful) {
        return RelationUtil.getRelationTo(this, rp, ignorePeaceful);
    }

    @Override
    public ChatColor getColorTo(RelationParticipator rp) {
        return RelationUtil.getColorOfThatToMe(this, rp);
    }

    @Override
    public Relation getRelationWish(Faction otherFaction) {
        if (this.relationWish.containsKey(otherFaction.getId())) {
            return this.relationWish.get(otherFaction.getId());
        }
        return Relation.fromString(P.p.getConfig().getString("default-relation", "neutral"));
    }

    @Override
    public void setRelationWish(Faction otherFaction, Relation relation) {
        if (this.relationWish.containsKey(otherFaction.getId()) && relation.equals((Object)Relation.NEUTRAL)) {
            this.relationWish.remove(otherFaction.getId());
        } else {
            this.relationWish.put(otherFaction.getId(), relation);
        }
    }

    @Override
    public int getRelationCount(Relation relation) {
        int count = 0;
        for (Faction faction : Factions.getInstance().getAllFactions()) {
            if (faction.getRelationTo(this) != relation) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getPower() {
        if (this.hasPermanentPower()) {
            return this.getPermanentPower().intValue();
        }
        double ret = 0.0;
        for (FPlayer fplayer : this.fplayers) {
            ret += fplayer.getPower();
        }
        if (Conf.powerFactionMax > 0.0 && ret > Conf.powerFactionMax) {
            ret = Conf.powerFactionMax;
        }
        return ret + this.powerBoost;
    }

    @Override
    public double getPowerMax() {
        if (this.hasPermanentPower()) {
            return this.getPermanentPower().intValue();
        }
        double ret = 0.0;
        for (FPlayer fplayer : this.fplayers) {
            ret += fplayer.getPowerMax();
        }
        if (Conf.powerFactionMax > 0.0 && ret > Conf.powerFactionMax) {
            ret = Conf.powerFactionMax;
        }
        return ret + this.powerBoost;
    }

    @Override
    public int getPowerRounded() {
        return (int)Math.round(this.getPower());
    }

    @Override
    public int getPowerMaxRounded() {
        return (int)Math.round(this.getPowerMax());
    }

    @Override
    public int getLandRounded() {
        return Board.getInstance().getFactionCoordCount(this);
    }

    @Override
    public int getLandRoundedInWorld(String worldName) {
        return Board.getInstance().getFactionCoordCountInWorld(this, worldName);
    }

    @Override
    public boolean hasLandInflation() {
        return this.getLandRounded() > this.getPowerRounded();
    }

    @Override
    public void refreshFPlayers() {
        this.fplayers.clear();
        if (this.isPlayerFreeType()) {
            return;
        }
        for (FPlayer fplayer : FPlayers.getInstance().getAllFPlayers()) {
            if (!fplayer.getFactionId().equalsIgnoreCase(this.id)) continue;
            this.fplayers.add(fplayer);
        }
    }

    @Override
    public boolean addFPlayer(FPlayer fplayer) {
        return !this.isPlayerFreeType() && this.fplayers.add(fplayer);
    }

    @Override
    public boolean removeFPlayer(FPlayer fplayer) {
        return !this.isPlayerFreeType() && this.fplayers.remove(fplayer);
    }

    @Override
    public int getSize() {
        return this.fplayers.size();
    }

    @Override
    public Set<FPlayer> getFPlayers() {
        return new HashSet<FPlayer>(this.fplayers);
    }

    @Override
    public Set<FPlayer> getFPlayersWhereOnline(boolean online) {
        HashSet<FPlayer> ret = new HashSet<FPlayer>();
        if (!this.isNormal()) {
            return ret;
        }
        for (FPlayer fplayer : this.fplayers) {
            if (fplayer.isOnline() != online) continue;
            ret.add(fplayer);
        }
        return ret;
    }

    @Override
    public FPlayer getFPlayerAdmin() {
        if (!this.isNormal()) {
            return null;
        }
        for (FPlayer fplayer : this.fplayers) {
            if (fplayer.getRole() != Role.ADMIN) continue;
            return fplayer;
        }
        return null;
    }

    @Override
    public ArrayList<FPlayer> getFPlayersWhereRole(Role role) {
        ArrayList<FPlayer> ret = new ArrayList<FPlayer>();
        if (!this.isNormal()) {
            return ret;
        }
        for (FPlayer fplayer : this.fplayers) {
            if (fplayer.getRole() != role) continue;
            ret.add(fplayer);
        }
        return ret;
    }

    @Override
    public ArrayList<Player> getOnlinePlayers() {
        ArrayList<Player> ret = new ArrayList<Player>();
        if (this.isPlayerFreeType()) {
            return ret;
        }
        for (Player player : P.p.getServer().getOnlinePlayers()) {
            FPlayer fplayer = FPlayers.getInstance().getByPlayer(player);
            if (fplayer.getFaction() != this) continue;
            ret.add(player);
        }
        return ret;
    }

    @Override
    public boolean hasPlayersOnline() {
        if (this.isPlayerFreeType()) {
            return false;
        }
        for (Player player : P.p.getServer().getOnlinePlayers()) {
            FPlayer fplayer = FPlayers.getInstance().getByPlayer(player);
            if (fplayer == null || fplayer.getFaction() != this) continue;
            return true;
        }
        return Conf.considerFactionsReallyOfflineAfterXMinutes > 0.0 && (double)System.currentTimeMillis() < (double)this.lastPlayerLoggedOffTime + Conf.considerFactionsReallyOfflineAfterXMinutes * 60000.0;
    }

    @Override
    public void memberLoggedOff() {
        if (this.isNormal()) {
            this.lastPlayerLoggedOffTime = System.currentTimeMillis();
        }
    }

    @Override
    public void promoteNewLeader() {
        if (!this.isNormal()) {
            return;
        }
        if (this.isPermanent() && Conf.permanentFactionsDisableLeaderPromotion) {
            return;
        }
        FPlayer oldLeader = this.getFPlayerAdmin();
        ArrayList<FPlayer> replacements = this.getFPlayersWhereRole(Role.MODERATOR);
        if (replacements == null || replacements.isEmpty()) {
            replacements = this.getFPlayersWhereRole(Role.NORMAL);
        }
        if (replacements == null || replacements.isEmpty()) {
            if (this.isPermanent()) {
                if (oldLeader != null) {
                    oldLeader.setRole(Role.NORMAL);
                }
                return;
            }
            if (Conf.logFactionDisband) {
                P.p.log("The faction " + this.getTag() + " (" + this.getId() + ") has been disbanded since it has no members left.");
            }
            for (FPlayer fplayer : FPlayers.getInstance().getOnlinePlayers()) {
                fplayer.msg("The faction %s<i> was disbanded.", this.getTag(fplayer));
            }
            Factions.getInstance().removeFaction(this.getId());
        } else {
            if (oldLeader != null) {
                oldLeader.setRole(Role.NORMAL);
            }
            replacements.get(0).setRole(Role.ADMIN);
            this.msg("<i>Faction admin <h>%s<i> has been removed. %s<i> has been promoted as the new faction admin.", oldLeader == null ? "" : oldLeader.getName(), replacements.get(0).getName());
            P.p.log("Faction " + this.getTag() + " (" + this.getId() + ") admin was removed. Replacement admin: " + replacements.get(0).getName());
        }
    }

    @Override
    public void msg(String message, Object ... args) {
        message = P.p.txt.parse(message, args);
        for (FPlayer fplayer : this.getFPlayersWhereOnline(true)) {
            fplayer.sendMessage(message);
        }
    }

    @Override
    public void msg(TL translation, Object ... args) {
        this.msg(translation.toString(), args);
    }

    @Override
    public void sendMessage(String message) {
        for (FPlayer fplayer : this.getFPlayersWhereOnline(true)) {
            fplayer.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(List<String> messages) {
        for (FPlayer fplayer : this.getFPlayersWhereOnline(true)) {
            fplayer.sendMessage(messages);
        }
    }

    @Override
    public Map<FLocation, Set<String>> getClaimOwnership() {
        return this.claimOwnership;
    }

    @Override
    public void clearAllClaimOwnership() {
        this.claimOwnership.clear();
    }

    @Override
    public void clearClaimOwnership(FLocation loc) {
        this.claimOwnership.remove(loc);
    }

    @Override
    public void clearClaimOwnership(FPlayer player) {
        if (this.id == null || this.id.isEmpty()) {
            return;
        }
        for (Map.Entry<FLocation, Set<String>> entry : this.claimOwnership.entrySet()) {
            Set<String> ownerData = entry.getValue();
            if (ownerData == null) continue;
            Iterator<String> iter = ownerData.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(player.getId())) continue;
                iter.remove();
            }
            if (!ownerData.isEmpty()) continue;
            this.claimOwnership.remove(entry.getKey());
        }
    }

    @Override
    public int getCountOfClaimsWithOwners() {
        return this.claimOwnership.isEmpty() ? 0 : this.claimOwnership.size();
    }

    @Override
    public boolean doesLocationHaveOwnersSet(FLocation loc) {
        if (this.claimOwnership.isEmpty() || !this.claimOwnership.containsKey(loc)) {
            return false;
        }
        Set<String> ownerData = this.claimOwnership.get(loc);
        return ownerData != null && !ownerData.isEmpty();
    }

    @Override
    public boolean isPlayerInOwnerList(FPlayer player, FLocation loc) {
        if (this.claimOwnership.isEmpty()) {
            return false;
        }
        Set<String> ownerData = this.claimOwnership.get(loc);
        if (ownerData == null) {
            return false;
        }
        return ownerData.contains(player.getId());
    }

    @Override
    public void setPlayerAsOwner(FPlayer player, FLocation loc) {
        Set<String> ownerData = this.claimOwnership.get(loc);
        if (ownerData == null) {
            ownerData = new HashSet<String>();
        }
        ownerData.add(player.getId());
        this.claimOwnership.put(loc, ownerData);
    }

    @Override
    public void removePlayerAsOwner(FPlayer player, FLocation loc) {
        Set<String> ownerData = this.claimOwnership.get(loc);
        if (ownerData == null) {
            return;
        }
        ownerData.remove(player.getId());
        this.claimOwnership.put(loc, ownerData);
    }

    @Override
    public Set<String> getOwnerList(FLocation loc) {
        return this.claimOwnership.get(loc);
    }

    @Override
    public String getOwnerListString(FLocation loc) {
        Set<String> ownerData = this.claimOwnership.get(loc);
        if (ownerData == null || ownerData.isEmpty()) {
            return "";
        }
        String ownerList = "";
        Iterator<String> iter = ownerData.iterator();
        while (iter.hasNext()) {
            if (!ownerList.isEmpty()) {
                ownerList = ownerList + ", ";
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(iter.next()));
            ownerList = ownerList + (offlinePlayer != null ? offlinePlayer.getName() : "null player");
        }
        return ownerList;
    }

    @Override
    public boolean playerHasOwnershipRights(FPlayer fplayer, FLocation loc) {
        if (fplayer.getFaction() == this && (fplayer.getRole().isAtLeast(Conf.ownedAreaModeratorsBypass ? Role.MODERATOR : Role.ADMIN) || Permission.OWNERSHIP_BYPASS.has((CommandSender)fplayer.getPlayer()))) {
            return true;
        }
        if (this.claimOwnership.isEmpty()) {
            return true;
        }
        Set<String> ownerData = this.claimOwnership.get(loc);
        return ownerData == null || ownerData.isEmpty() || ownerData.contains(fplayer.getId());
    }

    @Override
    public void remove() {
        if (Econ.shouldBeUsed()) {
            Econ.setBalance(this.getAccountId(), 0.0);
        }
        ((MemoryBoard)Board.getInstance()).clean(this.id);
        for (FPlayer fPlayer : this.fplayers) {
            fPlayer.resetFactionData(false);
        }
    }

    @Override
    public Set<FLocation> getAllClaims() {
        return Board.getInstance().getAllClaims(this);
    }
}

