/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist;

import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;

public abstract class MemoryFactions
extends Factions {
    public Map<String, Faction> factions = new ConcurrentHashMap<String, Faction>();
    public int nextId = 1;

    @Override
    public void load() {
        Faction faction;
        if (!this.factions.containsKey("0")) {
            faction = this.generateFactionObject("0");
            this.factions.put("0", faction);
            faction.setTag(TL.WILDERNESS.toString());
            faction.setDescription(TL.WILDERNESS_DESCRIPTION.toString());
        } else {
            faction = this.factions.get("0");
            if (!faction.getTag().equalsIgnoreCase(TL.WILDERNESS.toString())) {
                faction.setTag(TL.WILDERNESS.toString());
            }
            if (!faction.getDescription().equalsIgnoreCase(TL.WILDERNESS_DESCRIPTION.toString())) {
                faction.setDescription(TL.WILDERNESS_DESCRIPTION.toString());
            }
        }
        if (!this.factions.containsKey("-1")) {
            faction = this.generateFactionObject("-1");
            this.factions.put("-1", faction);
            faction.setTag(TL.SAFEZONE.toString());
            faction.setDescription(TL.SAFEZONE_DESCRIPTION.toString());
        } else {
            faction = this.factions.get("-1");
            if (!faction.getTag().equalsIgnoreCase(TL.SAFEZONE.toString())) {
                faction.setTag(TL.SAFEZONE.toString());
            }
            if (!faction.getDescription().equalsIgnoreCase(TL.SAFEZONE_DESCRIPTION.toString())) {
                faction.setDescription(TL.SAFEZONE_DESCRIPTION.toString());
            }
            if (faction.getTag().contains(" ")) {
                faction.setTag(TL.SAFEZONE.toString());
            }
        }
        if (!this.factions.containsKey("-2")) {
            faction = this.generateFactionObject("-2");
            this.factions.put("-2", faction);
            faction.setTag(TL.WARZONE.toString());
            faction.setDescription(TL.WARZONE_DESCRIPTION.toString());
        } else {
            faction = this.factions.get("-2");
            if (!faction.getTag().equalsIgnoreCase(TL.WARZONE.toString())) {
                faction.setTag(TL.WARZONE.toString());
            }
            if (!faction.getDescription().equalsIgnoreCase(TL.WARZONE_DESCRIPTION.toString())) {
                faction.setDescription(TL.WARZONE_DESCRIPTION.toString());
            }
            if (faction.getTag().contains(" ")) {
                faction.setTag(TL.WARZONE.toString());
            }
        }
    }

    @Override
    public Faction getFactionById(String id) {
        return this.factions.get(id);
    }

    public abstract Faction generateFactionObject(String var1);

    @Override
    public Faction getByTag(String str) {
        String compStr = MiscUtil.getComparisonString(str);
        for (Faction faction : this.factions.values()) {
            if (!faction.getComparisonTag().equals(compStr)) continue;
            return faction;
        }
        return null;
    }

    @Override
    public Faction getBestTagMatch(String start) {
        int best = 0;
        start = start.toLowerCase();
        int minlength = start.length();
        Faction bestMatch = null;
        for (Faction faction : this.factions.values()) {
            String candidate = faction.getTag();
            if ((candidate = ChatColor.stripColor((String)candidate)).length() < minlength || !candidate.toLowerCase().startsWith(start)) continue;
            int lendiff = candidate.length() - minlength;
            if (lendiff == 0) {
                return faction;
            }
            if (lendiff >= best && best != 0) continue;
            best = lendiff;
            bestMatch = faction;
        }
        return bestMatch;
    }

    @Override
    public boolean isTagTaken(String str) {
        return this.getByTag(str) != null;
    }

    @Override
    public boolean isValidFactionId(String id) {
        return this.factions.containsKey(id);
    }

    @Override
    public Faction createFaction() {
        Faction faction = this.generateFactionObject();
        this.factions.put(faction.getId(), faction);
        return faction;
    }

    @Override
    public Set<String> getFactionTags() {
        HashSet<String> tags = new HashSet<String>();
        for (Faction faction : this.factions.values()) {
            tags.add(faction.getTag());
        }
        return tags;
    }

    public abstract Faction generateFactionObject();

    @Override
    public void removeFaction(String id) {
        this.factions.remove(id).remove();
    }

    @Override
    public ArrayList<Faction> getAllFactions() {
        return new ArrayList<Faction>(this.factions.values());
    }

    @Override
    public Faction getNone() {
        return this.factions.get("0");
    }

    @Override
    public Faction getSafeZone() {
        return this.factions.get("-1");
    }

    @Override
    public Faction getWarZone() {
        return this.factions.get("-2");
    }

    public abstract void convertFrom(MemoryFactions var1);
}

