/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist.json;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.P;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.zcore.persist.MemoryBoard;
import com.massivecraft.factions.zcore.util.DiscUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class JSONBoard
extends MemoryBoard {
    private static transient File file = new File(P.p.getDataFolder(), "board.json");

    public Map<String, Map<String, String>> dumpAsSaveFormat() {
        HashMap<String, Map<String, String>> worldCoordIds = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : this.flocationIds.entrySet()) {
            String worldName = ((FLocation)entry.getKey()).getWorldName();
            String coords = ((FLocation)entry.getKey()).getCoordString();
            String id = (String)entry.getValue();
            if (!worldCoordIds.containsKey(worldName)) {
                worldCoordIds.put(worldName, new TreeMap());
            }
            ((Map)worldCoordIds.get(worldName)).put(coords, id);
        }
        return worldCoordIds;
    }

    public void loadFromSaveFormat(Map<String, Map<String, String>> worldCoordIds) {
        this.flocationIds.clear();
        for (Map.Entry<String, Map<String, String>> entry : worldCoordIds.entrySet()) {
            String worldName = entry.getKey();
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                String[] coords = entry2.getKey().trim().split("[,\\s]+");
                int x = Integer.parseInt(coords[0]);
                int z = Integer.parseInt(coords[1]);
                String factionId = entry2.getValue();
                this.flocationIds.put(new FLocation(worldName, x, z), factionId);
            }
        }
    }

    @Override
    public boolean forceSave() {
        try {
            DiscUtil.write(file, P.p.gson.toJson(this.dumpAsSaveFormat()));
        }
        catch (Exception e) {
            e.printStackTrace();
            P.p.log("Failed to save the board to disk.");
            return false;
        }
        return true;
    }

    @Override
    public boolean load() {
        P.p.log("Loading board from disk");
        if (!file.exists()) {
            P.p.log("No board to load from disk. Creating new file.");
            this.forceSave();
            return true;
        }
        try {
            Type type = new TypeToken<Map<String, Map<String, String>>>(){}.getType();
            Map worldCoordIds = (Map)P.p.gson.fromJson(DiscUtil.read(file), type);
            this.loadFromSaveFormat(worldCoordIds);
            P.p.log("Loaded " + this.flocationIds.size() + " board locations");
        }
        catch (Exception e) {
            e.printStackTrace();
            P.p.log("Failed to load the board from disk.");
            return false;
        }
        return true;
    }

    @Override
    public void convertFrom(MemoryBoard old) {
        this.flocationIds = old.flocationIds;
        this.forceSave();
        Board.instance = this;
    }
}

