/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist.json;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.P;
import com.massivecraft.factions.shade.com.google.gson.Gson;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.zcore.persist.MemoryFPlayer;
import com.massivecraft.factions.zcore.persist.MemoryFPlayers;
import com.massivecraft.factions.zcore.persist.json.JSONFPlayer;
import com.massivecraft.factions.zcore.util.DiscUtil;
import com.massivecraft.factions.zcore.util.UUIDFetcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;

public class JSONFPlayers
extends MemoryFPlayers {
    private Gson gson;
    private File file = new File(P.p.getDataFolder(), "players.json");

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public JSONFPlayers() {
        this.gson = P.p.gson;
    }

    @Override
    public void convertFrom(MemoryFPlayers old) {
        this.fPlayers.putAll(Maps.transformValues(old.fPlayers, (Function)new Function<FPlayer, JSONFPlayer>(){

            public JSONFPlayer apply(FPlayer arg0) {
                return new JSONFPlayer((MemoryFPlayer)arg0);
            }
        }));
        this.forceSave();
        FPlayers.instance = this;
    }

    @Override
    public void forceSave() {
        HashMap<String, JSONFPlayer> entitiesThatShouldBeSaved = new HashMap<String, JSONFPlayer>();
        for (FPlayer entity : this.fPlayers.values()) {
            if (!((MemoryFPlayer)entity).shouldBeSaved()) continue;
            entitiesThatShouldBeSaved.put(entity.getId(), (JSONFPlayer)entity);
        }
        this.saveCore(this.file, entitiesThatShouldBeSaved);
    }

    private boolean saveCore(File target, Map<String, JSONFPlayer> data) {
        return DiscUtil.writeCatch(target, this.gson.toJson(data));
    }

    @Override
    public void load() {
        Map<String, JSONFPlayer> fplayers = this.loadCore();
        if (fplayers == null) {
            return;
        }
        this.fPlayers.clear();
        this.fPlayers.putAll(fplayers);
        P.p.log("Loaded " + this.fPlayers.size() + " players");
    }

    private Map<String, JSONFPlayer> loadCore() {
        if (!this.file.exists()) {
            return new HashMap<String, JSONFPlayer>();
        }
        String content = DiscUtil.readCatch(this.file);
        if (content == null) {
            return null;
        }
        Map data = (Map)this.gson.fromJson(content, new TypeToken<Map<String, JSONFPlayer>>(){}.getType());
        HashSet<String> list = new HashSet<String>();
        HashSet<String> invalidList = new HashSet<String>();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            ((JSONFPlayer)entry.getValue()).setId(key);
            if (!this.doesKeyNeedMigration(key)) continue;
            if (!this.isKeyInvalid(key)) {
                list.add(key);
                continue;
            }
            invalidList.add(key);
        }
        if (list.size() > 0) {
            Bukkit.getLogger().log(Level.INFO, "Factions is now updating players.json");
            File file = new File(this.file.getParentFile(), "players.json.old");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveCore(file, data);
            Bukkit.getLogger().log(Level.INFO, "Backed up your old data at " + file.getAbsolutePath());
            Bukkit.getLogger().log(Level.INFO, "Please wait while Factions converts " + list.size() + " old player names to UUID. This may take a while.");
            UUIDFetcher fetcher = new UUIDFetcher(new ArrayList<String>(list));
            try {
                Object response = fetcher.call();
                for (String s : list) {
                    if (response.containsKey(s)) continue;
                    invalidList.add(s);
                }
                for (String value : response.keySet()) {
                    String id = ((UUID)response.get(value)).toString();
                    JSONFPlayer player = (JSONFPlayer)data.get(value);
                    if (player == null) {
                        invalidList.add(value);
                        continue;
                    }
                    player.setId(id);
                    data.remove(value);
                    data.put(id, player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (invalidList.size() > 0) {
                for (String name : invalidList) {
                    data.remove(name);
                }
                Bukkit.getLogger().log(Level.INFO, "While converting we found names that either don't have a UUID or aren't players and removed them from storage.");
                Bukkit.getLogger().log(Level.INFO, "The following names were detected as being invalid: " + StringUtils.join(invalidList, (String)", "));
            }
            this.saveCore(this.file, data);
            Bukkit.getLogger().log(Level.INFO, "Done converting players.json to UUID.");
        }
        return data;
    }

    private boolean doesKeyNeedMigration(String key) {
        return !key.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}") && key.matches("[a-zA-Z0-9_]{2,16}");
    }

    private boolean isKeyInvalid(String key) {
        return !key.matches("[a-zA-Z0-9_]{2,16}");
    }

    @Override
    public FPlayer generateFPlayer(String id) {
        JSONFPlayer player = new JSONFPlayer(id);
        this.fPlayers.put(player.getId(), player);
        return player;
    }
}

