/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.persist.json;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.shade.com.google.gson.Gson;
import com.massivecraft.factions.shade.com.google.gson.reflect.TypeToken;
import com.massivecraft.factions.zcore.persist.MemoryFaction;
import com.massivecraft.factions.zcore.persist.MemoryFactions;
import com.massivecraft.factions.zcore.persist.json.JSONFaction;
import com.massivecraft.factions.zcore.util.DiscUtil;
import com.massivecraft.factions.zcore.util.UUIDFetcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class JSONFactions
extends MemoryFactions {
    private Gson gson;
    private File file = new File(P.p.getDataFolder(), "factions.json");

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JSONFactions() {
        this.gson = P.p.gson;
        this.nextId = 1;
    }

    @Override
    public void forceSave() {
        HashMap<String, JSONFaction> entitiesThatShouldBeSaved = new HashMap<String, JSONFaction>();
        for (Faction entity : this.factions.values()) {
            entitiesThatShouldBeSaved.put(entity.getId(), (JSONFaction)entity);
        }
        this.saveCore(this.file, entitiesThatShouldBeSaved);
    }

    private boolean saveCore(File target, Map<String, JSONFaction> entities) {
        return DiscUtil.writeCatch(target, this.gson.toJson(entities));
    }

    @Override
    public void load() {
        Map<String, JSONFaction> factions = this.loadCore();
        if (factions == null) {
            return;
        }
        this.factions.putAll(factions);
        super.load();
        P.p.log("Loaded " + factions.size() + " Factions");
    }

    private Map<String, JSONFaction> loadCore() {
        Faction f;
        if (!this.file.exists()) {
            return new HashMap<String, JSONFaction>();
        }
        String content = DiscUtil.readCatch(this.file);
        if (content == null) {
            return null;
        }
        Map data = (Map)this.gson.fromJson(content, new TypeToken<Map<String, JSONFaction>>(){}.getType());
        this.nextId = 1;
        int needsUpdate = 0;
        for (Map.Entry entry : data.entrySet()) {
            String id = (String)entry.getKey();
            f = (Faction)entry.getValue();
            f.setId(id);
            this.updateNextIdForId(id);
            needsUpdate += this.whichKeysNeedMigration(f.getInvites()).size();
            for (Set<String> set : f.getClaimOwnership().values()) {
                needsUpdate += this.whichKeysNeedMigration(set).size();
            }
        }
        if (needsUpdate > 0) {
            Bukkit.getLogger().log(Level.INFO, "Factions is now updating factions.json");
            File file = new File(this.file.getParentFile(), "factions.json.old");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveCore(file, data);
            Bukkit.getLogger().log(Level.INFO, "Backed up your old data at " + file.getAbsolutePath());
            Bukkit.getLogger().log(Level.INFO, "Please wait while Factions converts " + needsUpdate + " old player names to UUID. This may take a while.");
            for (String string : data.keySet()) {
                f = (Faction)data.get(string);
                Map<FLocation, Set<String>> claims = f.getClaimOwnership();
                for (FLocation key : claims.keySet()) {
                    Set<String> set = claims.get(key);
                    Set<String> list = this.whichKeysNeedMigration(set);
                    if (list.size() <= 0) continue;
                    UUIDFetcher fetcher = new UUIDFetcher(new ArrayList<String>(list));
                    try {
                        Object response = fetcher.call();
                        for (String value : response.keySet()) {
                            String id = ((UUID)response.get(value)).toString();
                            set.remove(value.toLowerCase());
                            set.add(id);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    claims.put(key, set);
                }
            }
            for (String string : data.keySet()) {
                f = (Faction)data.get(string);
                Set<String> invites = f.getInvites();
                Set<String> set = this.whichKeysNeedMigration(invites);
                if (set.size() <= 0) continue;
                UUIDFetcher fetcher = new UUIDFetcher(new ArrayList<String>(set));
                try {
                    Object response = fetcher.call();
                    for (String value : response.keySet()) {
                        String id = ((UUID)response.get(value)).toString();
                        invites.remove(value.toLowerCase());
                        invites.add(id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.saveCore(this.file, data);
            Bukkit.getLogger().log(Level.INFO, "Done converting factions.json to UUID.");
        }
        return data;
    }

    private Set<String> whichKeysNeedMigration(Set<String> keys) {
        HashSet<String> list = new HashSet<String>();
        for (String value : keys) {
            if (value.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}") || !value.matches("[a-zA-Z0-9_]{2,16}")) continue;
            list.add(value);
        }
        return list;
    }

    public String getNextId() {
        while (!this.isIdFree(this.nextId)) {
            ++this.nextId;
        }
        return Integer.toString(this.nextId);
    }

    public boolean isIdFree(String id) {
        return !this.factions.containsKey(id);
    }

    public boolean isIdFree(int id) {
        return this.isIdFree(Integer.toString(id));
    }

    protected synchronized void updateNextIdForId(int id) {
        if (this.nextId < id) {
            this.nextId = id + 1;
        }
    }

    protected void updateNextIdForId(String id) {
        try {
            int idAsInt = Integer.parseInt(id);
            this.updateNextIdForId(idAsInt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Faction generateFactionObject() {
        String id = this.getNextId();
        JSONFaction faction = new JSONFaction(id);
        this.updateNextIdForId(id);
        return faction;
    }

    @Override
    public Faction generateFactionObject(String id) {
        JSONFaction faction = new JSONFaction(id);
        return faction;
    }

    @Override
    public void convertFrom(MemoryFactions old) {
        this.factions.putAll(Maps.transformValues(old.factions, (Function)new Function<Faction, JSONFaction>(){

            public JSONFaction apply(Faction arg0) {
                return new JSONFaction((MemoryFaction)arg0);
            }
        }));
        this.nextId = old.nextId;
        this.forceSave();
        Factions.instance = this;
    }
}

