/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.util;

import com.massivecraft.factions.zcore.MPlugin;
import com.massivecraft.factions.zcore.util.TL;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class PermUtil {
    public Map<String, String> permissionDescriptions = new HashMap<String, String>();
    protected MPlugin p;

    public PermUtil(MPlugin p) {
        this.p = p;
        this.setup();
    }

    public String getForbiddenMessage(String perm) {
        return this.p.txt.parse(TL.GENERIC_NOPERMISSION.toString(), this.getPermissionDescription(perm));
    }

    public final void setup() {
        for (Permission permission : this.p.getDescription().getPermissions()) {
            this.permissionDescriptions.put(permission.getName(), permission.getDescription());
        }
    }

    public String getPermissionDescription(String perm) {
        String desc = this.permissionDescriptions.get(perm);
        if (desc == null) {
            return TL.GENERIC_DOTHAT.toString();
        }
        return desc;
    }

    public boolean has(CommandSender me, String perm) {
        if (me == null) {
            return false;
        }
        if (!(me instanceof Player)) {
            return me.hasPermission(perm);
        }
        return me.hasPermission(perm);
    }

    public boolean has(CommandSender me, String perm, boolean informSenderIfNot) {
        if (this.has(me, perm)) {
            return true;
        }
        if (informSenderIfNot && me != null) {
            me.sendMessage(this.getForbiddenMessage(perm));
        }
        return false;
    }

    public <T> T pickFirstVal(CommandSender me, Map<String, T> perm2val) {
        if (perm2val == null) {
            return null;
        }
        T ret = null;
        for (Map.Entry<String, T> entry : perm2val.entrySet()) {
            ret = entry.getValue();
            if (!this.has(me, entry.getKey())) continue;
            break;
        }
        return ret;
    }
}

