/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.util;

import com.massivecraft.factions.Conf;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.integration.Econ;
import com.massivecraft.factions.struct.Relation;
import com.massivecraft.factions.zcore.util.TL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public enum TagReplacer {
    ALLIES_LIST(TagType.FANCY, "{allies-list}"),
    ONLINE_LIST(TagType.FANCY, "{online-list}"),
    ENEMIES_LIST(TagType.FANCY, "{enemies-list}"),
    OFFLINE_LIST(TagType.FANCY, "{offline-list}"),
    PLAYER_GROUP(TagType.PLAYER, "{group}"),
    LAST_SEEN(TagType.PLAYER, "{lastSeen}"),
    PLAYER_BALANCE(TagType.PLAYER, "{balance}"),
    PLAYER_POWER(TagType.PLAYER, "{player-power}"),
    PLAYER_MAXPOWER(TagType.PLAYER, "{player-maxpower}"),
    HOME_X(TagType.FACTION, "{x}"),
    HOME_Y(TagType.FACTION, "{y}"),
    HOME_Z(TagType.FACTION, "{z}"),
    CHUNKS(TagType.FACTION, "{chunks}"),
    WARPS(TagType.FACTION, "{warps}"),
    HEADER(TagType.FACTION, "{header}"),
    POWER(TagType.FACTION, "{power}"),
    MAX_POWER(TagType.FACTION, "{maxPower}"),
    POWER_BOOST(TagType.FACTION, "{power-boost}"),
    LEADER(TagType.FACTION, "{leader}"),
    JOINING(TagType.FACTION, "{joining}"),
    FACTION(TagType.FACTION, "{faction}"),
    PLAYER_NAME(TagType.FACTION, "{name}"),
    HOME_WORLD(TagType.FACTION, "{world}"),
    RAIDABLE(TagType.FACTION, "{raidable}"),
    PEACEFUL(TagType.FACTION, "{peaceful}"),
    PERMANENT(TagType.FACTION, "permanent"),
    TIME_LEFT(TagType.FACTION, "{time-left}"),
    LAND_VALUE(TagType.FACTION, "{land-value}"),
    DESCRIPTION(TagType.FACTION, "{description}"),
    CREATE_DATE(TagType.FACTION, "{create-date}"),
    LAND_REFUND(TagType.FACTION, "{land-refund}"),
    BANK_BALANCE(TagType.FACTION, "{faction-balance}"),
    ALLIES_COUNT(TagType.FACTION, "{allies}"),
    ENEMIES_COUNT(TagType.FACTION, "{enemies}"),
    ONLINE_COUNT(TagType.FACTION, "{online}"),
    OFFLINE_COUNT(TagType.FACTION, "{offline}"),
    FACTION_SIZE(TagType.FACTION, "{members}"),
    MAX_WARPS(TagType.GENERAL, "{max-warps}"),
    MAX_ALLIES(TagType.GENERAL, "{max-allies}"),
    MAX_ENEMIES(TagType.GENERAL, "{max-enemies}"),
    FACTIONLESS(TagType.GENERAL, "{factionless}"),
    TOTAL_ONLINE(TagType.GENERAL, "{total-online}");

    private TagType type;
    private String tag;

    private TagReplacer(TagType type, String tag) {
        this.type = type;
        this.tag = tag;
    }

    protected String getValue() {
        switch (this) {
            case TOTAL_ONLINE: {
                return String.valueOf(Bukkit.getOnlinePlayers().size());
            }
            case FACTIONLESS: {
                return String.valueOf(Factions.getInstance().getNone().getFPlayersWhereOnline(true).size());
            }
            case MAX_ALLIES: {
                if (P.p.getConfig().getBoolean("max-relations.enabled", true)) {
                    return String.valueOf(P.p.getConfig().getInt("max-relations.ally", 10));
                }
                return TL.GENERIC_INFINITY.toString();
            }
            case MAX_ENEMIES: {
                if (P.p.getConfig().getBoolean("max-relations.enabled", true)) {
                    return String.valueOf(P.p.getConfig().getInt("max-relations.enemy", 10));
                }
                return TL.GENERIC_INFINITY.toString();
            }
            case MAX_WARPS: {
                return String.valueOf(P.p.getConfig().getInt("max-warps", 5));
            }
        }
        return null;
    }

    protected String getValue(Faction fac, FPlayer fp) {
        if (this.type == TagType.GENERAL) {
            return this.getValue();
        }
        if (fp != null) {
            switch (this) {
                case HEADER: {
                    return P.p.txt.titleize(fac.getTag(fp));
                }
                case PLAYER_NAME: {
                    return fp.getName();
                }
                case FACTION: {
                    return !fac.isNone() ? fac.getTag(fp) : TL.GENERIC_FACTIONLESS.toString();
                }
                case LAST_SEEN: {
                    String humanized = DurationFormatUtils.formatDurationWords((long)(System.currentTimeMillis() - fp.getLastLoginTime()), (boolean)true, (boolean)true) + (Object)((Object)TL.COMMAND_STATUS_AGOSUFFIX);
                    return fp.isOnline() ? ChatColor.GREEN + TL.COMMAND_STATUS_ONLINE.toString() : (System.currentTimeMillis() - fp.getLastLoginTime() < 432000000L ? ChatColor.YELLOW + humanized : ChatColor.RED + humanized);
                }
                case PLAYER_GROUP: {
                    return P.p.getPrimaryGroup(Bukkit.getOfflinePlayer((UUID)UUID.fromString(fp.getId())));
                }
                case PLAYER_BALANCE: {
                    return Econ.isSetup() ? Econ.getFriendlyBalance(fp) : TL.ECON_OFF.format("balance");
                }
                case PLAYER_POWER: {
                    return String.valueOf(fp.getPowerRounded());
                }
                case PLAYER_MAXPOWER: {
                    return String.valueOf(fp.getPowerMaxRounded());
                }
            }
        }
        switch (this) {
            case DESCRIPTION: {
                return fac.getDescription();
            }
            case FACTION: {
                return fac.getTag();
            }
            case JOINING: {
                return fac.getOpen() ? TL.COMMAND_SHOW_UNINVITED.toString() : TL.COMMAND_SHOW_INVITATION.toString();
            }
            case PEACEFUL: {
                return fac.isPeaceful() ? Conf.colorNeutral + TL.COMMAND_SHOW_PEACEFUL.toString() : "";
            }
            case PERMANENT: {
                return fac.isPermanent() ? "permanent" : "{notPermanent}";
            }
            case CHUNKS: {
                return String.valueOf(fac.getLandRounded());
            }
            case POWER: {
                return String.valueOf(fac.getPowerRounded());
            }
            case MAX_POWER: {
                return String.valueOf(fac.getPowerMaxRounded());
            }
            case POWER_BOOST: {
                double powerBoost = fac.getPowerBoost();
                return powerBoost == 0.0 ? "" : (powerBoost > 0.0 ? TL.COMMAND_SHOW_BONUS.toString() : TL.COMMAND_SHOW_PENALTY.toString() + powerBoost + ")");
            }
            case LEADER: {
                FPlayer fAdmin = fac.getFPlayerAdmin();
                return fAdmin == null ? "Server" : fAdmin.getName().substring(0, fAdmin.getName().length() > 14 ? 13 : fAdmin.getName().length());
            }
            case WARPS: {
                return String.valueOf(fac.getWarps().size());
            }
            case CREATE_DATE: {
                return TL.sdf.format(fac.getFoundedDate());
            }
            case RAIDABLE: {
                boolean raid = P.p.getConfig().getBoolean("hcf.raidable", false) && fac.getLandRounded() >= fac.getPowerRounded();
                return raid ? TL.RAIDABLE_TRUE.toString() : TL.RAIDABLE_FALSE.toString();
            }
            case HOME_WORLD: {
                return fac.hasHome() ? fac.getHome().getWorld().getName() : "{ig}";
            }
            case HOME_X: {
                return fac.hasHome() ? String.valueOf(fac.getHome().getBlockX()) : "{ig}";
            }
            case HOME_Y: {
                return fac.hasHome() ? String.valueOf(fac.getHome().getBlockY()) : "{ig}";
            }
            case HOME_Z: {
                return fac.hasHome() ? String.valueOf(fac.getHome().getBlockZ()) : "{ig}";
            }
            case LAND_VALUE: {
                return Econ.shouldBeUsed() ? Econ.moneyString(Econ.calculateTotalLandValue(fac.getLandRounded())) : TL.ECON_OFF.format("value");
            }
            case LAND_REFUND: {
                return Econ.shouldBeUsed() ? Econ.moneyString(Econ.calculateTotalLandRefund(fac.getLandRounded())) : TL.ECON_OFF.format("refund");
            }
            case BANK_BALANCE: {
                if (Econ.shouldBeUsed()) {
                    return Conf.bankEnabled ? Econ.moneyString(Econ.getBalance(fac.getAccountId())) : TL.ECON_OFF.format("balance");
                }
                return TL.ECON_OFF.format("balance");
            }
            case ALLIES_COUNT: {
                return String.valueOf(fac.getRelationCount(Relation.ALLY));
            }
            case ENEMIES_COUNT: {
                return String.valueOf(fac.getRelationCount(Relation.ENEMY));
            }
            case ONLINE_COUNT: {
                return String.valueOf(fac.getOnlinePlayers().size());
            }
            case OFFLINE_COUNT: {
                return String.valueOf(fac.getFPlayers().size() - fac.getOnlinePlayers().size());
            }
            case FACTION_SIZE: {
                return String.valueOf(fac.getFPlayers().size());
            }
        }
        return null;
    }

    protected static List<TagReplacer> getByType(TagType type) {
        ArrayList<TagReplacer> tagReplacers = new ArrayList<TagReplacer>();
        for (TagReplacer tagReplacer : TagReplacer.values()) {
            if (type == TagType.FANCY) {
                if (tagReplacer.type != TagType.FANCY) continue;
                tagReplacers.add(tagReplacer);
                continue;
            }
            if (tagReplacer.type.id < type.id) continue;
            tagReplacers.add(tagReplacer);
        }
        return tagReplacers;
    }

    public String replace(String original, String value) {
        return original.replace(this.tag, value);
    }

    public boolean contains(String toSearch) {
        return toSearch.contains(this.tag);
    }

    public String getTag() {
        return this.tag;
    }

    protected static enum TagType {
        FANCY(0),
        PLAYER(1),
        FACTION(2),
        GENERAL(3);

        public int id;

        private TagType(int id) {
            this.id = id;
        }
    }
}

